/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import org.apache.hc.client5.http.impl.RequestSupport;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestRequestSupport {
    TestRequestSupport() {
    }

    @Test
    void testPathPrefixExtraction() {
        Assertions.assertEquals((Object)"/aaaa/", (Object)RequestSupport.extractPathPrefix((HttpRequest)new BasicHttpRequest("GET", "/aaaa/bbbb")));
        Assertions.assertEquals((Object)"/aaaa/", (Object)RequestSupport.extractPathPrefix((HttpRequest)new BasicHttpRequest("GET", "/aaaa/")));
        Assertions.assertEquals((Object)"/aaaa/", (Object)RequestSupport.extractPathPrefix((HttpRequest)new BasicHttpRequest("GET", "/aaaa/../aaaa/")));
        Assertions.assertEquals((Object)"/aaaa/bbbb/", (Object)RequestSupport.extractPathPrefix((HttpRequest)new BasicHttpRequest("GET", "/aaaa/bbbb/cccc")));
        Assertions.assertEquals((Object)"/aaaa/bbbb/", (Object)RequestSupport.extractPathPrefix((HttpRequest)new BasicHttpRequest("GET", "/aaaa/bbbb/")));
        Assertions.assertEquals((Object)"/aaaa/", (Object)RequestSupport.extractPathPrefix((HttpRequest)new BasicHttpRequest("GET", "/aaaa/bbbb?////")));
        Assertions.assertEquals((Object)"/aa%2Faa/", (Object)RequestSupport.extractPathPrefix((HttpRequest)new BasicHttpRequest("GET", "/aa%2faa/bbbb")));
        Assertions.assertEquals((Object)"/aa%2Faa/", (Object)RequestSupport.extractPathPrefix((HttpRequest)new BasicHttpRequest("GET", "/a%61%2fa%61/bbbb")));
        Assertions.assertEquals((Object)"/", (Object)RequestSupport.extractPathPrefix((HttpRequest)new BasicHttpRequest("GET", "/")));
        Assertions.assertEquals((Object)"/", (Object)RequestSupport.extractPathPrefix((HttpRequest)new BasicHttpRequest("GET", "/aaaa")));
        Assertions.assertEquals((Object)"/", (Object)RequestSupport.extractPathPrefix((HttpRequest)new BasicHttpRequest("GET", "")));
    }
}

