/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.protocol.HttpContext;

public class ClientRemoteEndpointDetails {
    public static void main(String[] args) throws Exception {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpClientContext localContext = HttpClientContext.create();
            HttpGet httpget = new HttpGet("http://httpbin.org/get");
            System.out.println("Executing request " + httpget.getMethod() + " " + httpget.getUri());
            httpclient.execute((ClassicHttpRequest)httpget, (HttpContext)localContext, response -> {
                System.out.println("----------------------------------------");
                System.out.println(httpget + "->" + new StatusLine((HttpResponse)response));
                EntityUtils.consume((HttpEntity)response.getEntity());
                EndpointDetails endpointDetails = localContext.getEndpointDetails();
                System.out.println("Remote address: " + endpointDetails.getRemoteAddress());
                System.out.println("Request counts: " + endpointDetails.getRequestCount());
                System.out.println("Response counts: " + endpointDetails.getResponseCount());
                System.out.println("Bytes sent: " + endpointDetails.getSentBytesCount());
                System.out.println("Bytes received: " + endpointDetails.getReceivedBytesCount());
                return null;
            });
            HttpHead httphead = new HttpHead("http://httpbin.org/get");
            System.out.println("Executing request " + httphead.getMethod() + " " + httphead.getUri());
            httpclient.execute((ClassicHttpRequest)httphead, (HttpContext)localContext, response -> {
                System.out.println("----------------------------------------");
                System.out.println(httphead + "->" + new StatusLine((HttpResponse)response));
                EntityUtils.consume((HttpEntity)response.getEntity());
                EndpointDetails endpointDetails = localContext.getEndpointDetails();
                System.out.println("Remote address: " + endpointDetails.getRemoteAddress());
                System.out.println("Request counts: " + endpointDetails.getRequestCount());
                System.out.println("Response counts: " + endpointDetails.getResponseCount());
                System.out.println("Bytes sent: " + endpointDetails.getSentBytesCount());
                System.out.println("Bytes received: " + endpointDetails.getReceivedBytesCount());
                return null;
            });
        }
    }
}

