/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.psl.DomainType;
import org.apache.hc.client5.http.psl.PublicSuffixListParser;
import org.apache.hc.client5.http.psl.PublicSuffixMatcher;
import org.apache.hc.client5.http.ssl.CertificatesToPlayWith;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.SubjectName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestDefaultHostnameVerifier {
    private DefaultHostnameVerifier impl;
    private PublicSuffixMatcher publicSuffixMatcher;
    private static final String PUBLIC_SUFFIX_MATCHER_SOURCE_FILE = "suffixlistmatcher.txt";

    TestDefaultHostnameVerifier() {
    }

    @BeforeEach
    void setup() throws IOException {
        this.impl = new DefaultHostnameVerifier();
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream in = classLoader.getResourceAsStream(PUBLIC_SUFFIX_MATCHER_SOURCE_FILE);
        Assertions.assertNotNull((Object)in);
        List lists = PublicSuffixListParser.INSTANCE.parseByType((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        this.publicSuffixMatcher = new PublicSuffixMatcher((Collection)lists);
    }

    @Test
    void testVerify() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(CertificatesToPlayWith.X509_FOO);
        X509Certificate x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.exceptionPlease(this.impl, "bar.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease(this.impl, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_FOO_BAR);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.impl.verify("bar.com", x509);
        this.exceptionPlease(this.impl, "a.bar.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_FOO_BAR_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.impl.verify("bar.com", x509);
        this.exceptionPlease(this.impl, "a.bar.com", x509);
        this.exceptionPlease(this.impl, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_NO_CNS_FOO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_NO_CNS_FOO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_THREE_CNS_FOO_BAR_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.exceptionPlease(this.impl, "bar.com", x509);
        this.exceptionPlease(this.impl, "a.bar.com", x509);
        this.impl.verify("\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease(this.impl, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_WILD_FOO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.impl.verify("www.foo.com", x509);
        this.impl.verify("\u82b1\u5b50.foo.com", x509);
        this.exceptionPlease(this.impl, "a.b.foo.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_WILD_CO_JP);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("*.co.jp", x509);
        this.impl.verify("foo.co.jp", x509);
        this.impl.verify("\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_WILD_FOO_BAR_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "www.foo.com", x509);
        this.exceptionPlease(this.impl, "\u82b1\u5b50.foo.com", x509);
        this.exceptionPlease(this.impl, "a.b.foo.com", x509);
        this.exceptionPlease(this.impl, "bar.com", x509);
        this.impl.verify("www.bar.com", x509);
        this.impl.verify("\u82b1\u5b50.bar.com", x509);
        this.exceptionPlease(this.impl, "a.b.bar.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_MULTIPLE_VALUE_AVA);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("repository.infonotary.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.S_GOOGLE_COM);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("*.google.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.S_GOOGLE_COM);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("*.Google.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.IP_1_1_1_1);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("1.1.1.1", x509);
        this.impl.verify("dummy-value.com", x509);
        this.exceptionPlease(this.impl, "1.1.1.2", x509);
        this.exceptionPlease(this.impl, "not-the-cn.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.EMAIL_ALT_SUBJECT_NAME);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("www.company.com", x509);
    }

    @Test
    void testSubjectAlt() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(CertificatesToPlayWith.X509_MULTIPLE_SUBJECT_ALT);
        X509Certificate x509 = (X509Certificate)cf.generateCertificate(in);
        Assertions.assertEquals((Object)"CN=localhost, OU=Unknown, O=Unknown, L=Unknown, ST=Unknown, C=CH", (Object)x509.getSubjectDN().getName());
        this.impl.verify("localhost.localdomain", x509);
        this.impl.verify("127.0.0.1", x509);
        Assertions.assertThrows(SSLException.class, () -> this.impl.verify("localhost", x509));
        Assertions.assertThrows(SSLException.class, () -> this.impl.verify("local.host", x509));
        Assertions.assertThrows(SSLException.class, () -> this.impl.verify("127.0.0.2", x509));
    }

    public void exceptionPlease(DefaultHostnameVerifier hv, String host, X509Certificate x509) {
        Assertions.assertThrows(SSLException.class, () -> hv.verify(host, x509));
    }

    @Test
    void testParseFQDN() {
        Assertions.assertEquals(Arrays.asList("blah"), (Object)DefaultHostnameVerifier.parseFQDN((CharSequence)"blah"));
        Assertions.assertEquals(Arrays.asList("blah", "blah"), (Object)DefaultHostnameVerifier.parseFQDN((CharSequence)"blah.blah"));
        Assertions.assertEquals(Arrays.asList("blah", "blah", "blah"), (Object)DefaultHostnameVerifier.parseFQDN((CharSequence)"blah.blah.blah"));
        Assertions.assertEquals(Arrays.asList("", "", "blah", ""), (Object)DefaultHostnameVerifier.parseFQDN((CharSequence)".blah.."));
        Assertions.assertEquals(Arrays.asList(""), (Object)DefaultHostnameVerifier.parseFQDN((CharSequence)""));
        Assertions.assertEquals(Arrays.asList("", ""), (Object)DefaultHostnameVerifier.parseFQDN((CharSequence)"."));
        Assertions.assertEquals(Arrays.asList("com", "domain", "host"), (Object)DefaultHostnameVerifier.parseFQDN((CharSequence)"host.domain.com"));
    }

    @Test
    void testDomainRootMatching() {
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchDomainRoot((String)"a.b.c", null));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchDomainRoot((String)"a.b.c", (String)"a.b.c"));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchDomainRoot((String)"aa.b.c", (String)"a.b.c"));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchDomainRoot((String)"a.b.c", (String)"aa.b.c"));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchDomainRoot((String)"a.a.b.c", (String)"a.b.c"));
    }

    @Test
    void testIdentityMatching() {
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.b.c", (String)"*.b.c"));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.b.c", (String)"*.b.c"));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"s.a.b.c", (String)"*.b.c"));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"s.a.b.c", (String)"*.b.c"));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.gov.uk", (String)"*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.gov.uk", (String)"*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"s.a.gov.uk", (String)"*.a.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"s.a.gov.uk", (String)"*.a.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"s.a.gov.uk", (String)"*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"s.a.gov.uk", (String)"*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.gov.com", (String)"*.gov.com", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.gov.com", (String)"*.gov.com", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"s.a.gov.com", (String)"*.gov.com", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"s.a.gov.com", (String)"*.gov.com", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.gov.uk", (String)"a*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.gov.uk", (String)"a*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"s.a.gov.uk", (String)"a*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"s.a.gov.uk", (String)"a*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.b.c", (String)"*.b.*"));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.b.c", (String)"*.b.*"));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.b.c", (String)"*.*.c"));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.b.c", (String)"*.*.c"));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.b.xxx.uk", (String)"a.b.xxx.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.b.xxx.uk", (String)"a.b.xxx.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.b.xxx.uk", (String)"*.b.xxx.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.b.xxx.uk", (String)"*.b.xxx.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"b.xxx.uk", (String)"b.xxx.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"b.xxx.uk", (String)"b.xxx.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"b.xxx.uk", (String)"*.xxx.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"b.xxx.uk", (String)"*.xxx.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
    }

    @Test
    void testHTTPCLIENT_1097() {
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.b.c", (String)"a*.b.c"));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.b.c", (String)"a*.b.c"));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.a.b.c", (String)"a*.b.c"));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.a.b.c", (String)"a*.b.c"));
    }

    @Test
    void testHTTPCLIENT_1255() {
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"mail.a.b.c.com", (String)"m*.a.b.c.com"));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"mail.a.b.c.com", (String)"m*.a.b.c.com"));
    }

    @Test
    void testHTTPCLIENT_1997_ANY() {
        String domain = "dev.b.cloud.a";
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain)));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain)));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher));
        domain = "dev.b.cloud.com";
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain)));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain)));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher));
        domain = "dev.b.cloud.lan";
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain)));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain)));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher));
    }

    @Test
    void testHTTPCLIENT_1997_ICANN() {
        String domain = "dev.b.cloud.a";
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.ICANN));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.ICANN));
        domain = "dev.b.cloud.com";
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.ICANN));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.ICANN));
        domain = "dev.b.cloud.lan";
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.ICANN));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.ICANN));
    }

    @Test
    void testHTTPCLIENT_1997_PRIVATE() {
        String domain = "dev.b.cloud.a";
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.PRIVATE));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.PRIVATE));
        domain = "dev.b.cloud.com";
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.PRIVATE));
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.PRIVATE));
        domain = "dev.b.cloud.lan";
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.PRIVATE));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.PRIVATE));
    }

    @Test
    void testHTTPCLIENT_1997_UNKNOWN() {
        String domain = "dev.b.cloud.a";
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.UNKNOWN));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.UNKNOWN));
        domain = "dev.b.cloud.com";
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.UNKNOWN));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.UNKNOWN));
        domain = "dev.b.cloud.lan";
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.UNKNOWN));
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.UNKNOWN));
    }

    @Test
    void testHTTPCLIENT_1316() throws Exception {
        String host1 = "2001:0db8:aaaa:bbbb:cccc:0:0:0001";
        DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc:0:0:0001", Collections.singletonList(SubjectName.IP((String)"2001:0db8:aaaa:bbbb:cccc:0:0:0001")));
        DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc:0:0:0001", Collections.singletonList(SubjectName.IP((String)"2001:0db8:aaaa:bbbb:cccc::1")));
        Assertions.assertThrows(SSLException.class, () -> DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc:0:0:0001", Collections.singletonList(SubjectName.IP((String)"2001:0db8:aaaa:bbbb:cccc::10"))));
        String host2 = "2001:0db8:aaaa:bbbb:cccc::1";
        DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc::1", Collections.singletonList(SubjectName.IP((String)"2001:0db8:aaaa:bbbb:cccc:0:0:0001")));
        DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc::1", Collections.singletonList(SubjectName.IP((String)"2001:0db8:aaaa:bbbb:cccc::1")));
        Assertions.assertThrows(SSLException.class, () -> DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc::1", Collections.singletonList(SubjectName.IP((String)"2001:0db8:aaaa:bbbb:cccc::10"))));
    }

    @Test
    void testHTTPCLIENT_2149() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(CertificatesToPlayWith.SUBJECT_ALT_IP_ONLY);
        X509Certificate x509 = (X509Certificate)cf.generateCertificate(in);
        Assertions.assertEquals((Object)"CN=www.foo.com", (Object)x509.getSubjectDN().getName());
        this.impl.verify("127.0.0.1", x509);
        this.impl.verify("www.foo.com", x509);
        this.exceptionPlease(this.impl, "127.0.0.2", x509);
        this.exceptionPlease(this.impl, "www.bar.com", x509);
    }

    @Test
    void testExtractCN() throws Exception {
        Assertions.assertEquals((Object)"blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=blah, ou=blah, o=blah"));
        Assertions.assertEquals((Object)"blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=blah, cn=yada, cn=booh"));
        Assertions.assertEquals((Object)"blah", (Object)DefaultHostnameVerifier.extractCN((String)"c = pampa ,  cn  =    blah    , ou = blah , o = blah"));
        Assertions.assertEquals((Object)"blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=\"blah\", ou=blah, o=blah"));
        Assertions.assertEquals((Object)"blah  blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=\"blah  blah\", ou=blah, o=blah"));
        Assertions.assertEquals((Object)"blah, blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=\"blah, blah\", ou=blah, o=blah"));
        Assertions.assertEquals((Object)"blah, blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=blah\\, blah, ou=blah, o=blah"));
        Assertions.assertEquals((Object)"blah", (Object)DefaultHostnameVerifier.extractCN((String)"c = cn=uuh, cn=blah, ou=blah, o=blah"));
        Assertions.assertThrows(SSLException.class, () -> DefaultHostnameVerifier.extractCN((String)"blah,blah"));
        Assertions.assertThrows(SSLException.class, () -> DefaultHostnameVerifier.extractCN((String)"cn,o=blah"));
    }

    @Test
    void testMatchDNSName() throws Exception {
        DefaultHostnameVerifier.matchDNSName((String)"host.domain.com", Collections.singletonList(SubjectName.DNS((String)"*.domain.com")), (PublicSuffixMatcher)this.publicSuffixMatcher);
        DefaultHostnameVerifier.matchDNSName((String)"host.xx", Collections.singletonList(SubjectName.DNS((String)"*.xx")), (PublicSuffixMatcher)this.publicSuffixMatcher);
        DefaultHostnameVerifier.matchDNSName((String)"host.appspot.com", Collections.singletonList(SubjectName.DNS((String)"*.appspot.com")), (PublicSuffixMatcher)this.publicSuffixMatcher);
        DefaultHostnameVerifier.matchDNSName((String)"demo-s3-bucket.s3.eu-central-1.amazonaws.com", Collections.singletonList(SubjectName.DNS((String)"*.s3.eu-central-1.amazonaws.com")), (PublicSuffixMatcher)this.publicSuffixMatcher);
        DefaultHostnameVerifier.matchDNSName((String)"hostname-workspace-1.local", Collections.singletonList(SubjectName.DNS((String)"hostname-workspace-1.local")), (PublicSuffixMatcher)this.publicSuffixMatcher);
        Assertions.assertThrows(SSLException.class, () -> DefaultHostnameVerifier.matchDNSName((String)"host.domain.com", Collections.singletonList(SubjectName.DNS((String)"some.other.com")), (PublicSuffixMatcher)this.publicSuffixMatcher));
        DefaultHostnameVerifier.matchDNSName((String)"host.ec2.compute-1.amazonaws.com", Collections.singletonList(SubjectName.DNS((String)"host.ec2.compute-1.amazonaws.com")), (PublicSuffixMatcher)this.publicSuffixMatcher);
        DefaultHostnameVerifier.matchDNSName((String)"host.ec2.compute-1.amazonaws.com", Collections.singletonList(SubjectName.DNS((String)"*.ec2.compute-1.amazonaws.com")), (PublicSuffixMatcher)this.publicSuffixMatcher);
        Assertions.assertThrows(SSLException.class, () -> DefaultHostnameVerifier.matchDNSName((String)"ec2.compute-1.amazonaws.com", Collections.singletonList(SubjectName.DNS((String)"ec2.compute-1.amazonaws.com")), (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assertions.assertThrows(SSLException.class, () -> DefaultHostnameVerifier.matchDNSName((String)"ec2.compute-1.amazonaws.com", Collections.singletonList(SubjectName.DNS((String)"*.compute-1.amazonaws.com")), (PublicSuffixMatcher)this.publicSuffixMatcher));
    }

    @Test
    void testMatchIdentity() {
        String unicodeHost1 = "\u043f\u043e\u0438\u0441\u043a-\u0441\u043b\u043e\u0432.\u0440\u0444";
        String punycodeHost1 = "xn----dtbqigoecuc.xn--p1ai";
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"\u043f\u043e\u0438\u0441\u043a-\u0441\u043b\u043e\u0432.\u0440\u0444", (String)"xn----dtbqigoecuc.xn--p1ai"), (String)"Expected the Unicode host and its punycode to match");
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"example.com", (String)"xn----dtbqigoecuc.xn--p1ai"), (String)"Expected mismatch between example.com and xn----dtbqigoecuc.xn--p1ai");
        String unicodeHost2 = "\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444";
        String unicodeIdentity2 = "\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444";
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444", (String)"\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444"), (String)"Expected Unicode host and Unicode identity to match");
        String unicodeHost3 = "\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444";
        String punycodeIdentity3 = "xn--e1afmkfd.xn--p1ai";
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444", (String)"xn--e1afmkfd.xn--p1ai"), (String)"Expected Unicode host and punycode identity to match");
        String unicodeHost4 = "sub.\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444";
        String unicodeIdentity4 = "*.\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444";
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"sub.\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444", (String)"*.\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444"), (String)"Expected wildcard to match subdomain");
        String invalidHost = "invalid_host";
        String unicodeIdentity5 = "\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444";
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"invalid_host", (String)"\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444"), (String)"Expected invalid host to not match");
        String unicodeHost4b = "\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444";
        String invalidIdentity = "xn--invalid-punycode";
        Assertions.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444", (String)"xn--invalid-punycode"), (String)"Expected invalid identity to not match");
        String unicodeHost5 = "\u041f\u0440\u0418\u043c\u0435\u0420.\u0440\u0444";
        String unicodeIdentity6 = "\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444";
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"\u041f\u0440\u0418\u043c\u0435\u0420.\u0440\u0444", (String)"\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444"), (String)"Expected case-insensitive Unicode comparison to match");
        String unicodeHost6 = "sub.\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444";
        String unicodeIdentity8 = "sub.*.\u0440\u0444";
        Assertions.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"sub.\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444", (String)"sub.*.\u0440\u0444"), (String)"Expected wildcard in the middle label to match");
    }
}

