/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.CookieSpecFactory;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.ExecChainElement;
import org.apache.hc.client5.http.impl.classic.InternalHttpClient;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

class TestInternalHttpClient {
    @Mock
    private HttpClientConnectionManager connManager;
    @Mock
    private HttpRequestExecutor requestExecutor;
    @Mock
    private ExecChainHandler execChain;
    @Mock
    private HttpRoutePlanner routePlanner;
    @Mock
    private Lookup<CookieSpecFactory> cookieSpecRegistry;
    @Mock
    private Lookup<AuthSchemeFactory> authSchemeRegistry;
    @Mock
    private CookieStore cookieStore;
    @Mock
    private CredentialsProvider credentialsProvider;
    @Mock
    private RequestConfig defaultConfig;
    @Mock
    private Closeable closeable1;
    @Mock
    private Closeable closeable2;
    private InternalHttpClient client;

    TestInternalHttpClient() {
    }

    @BeforeEach
    void setup() {
        MockitoAnnotations.openMocks((Object)this);
        this.client = new InternalHttpClient(this.connManager, this.requestExecutor, new ExecChainElement(this.execChain, null), this.routePlanner, this.cookieSpecRegistry, this.authSchemeRegistry, this.cookieStore, this.credentialsProvider, HttpClientContext::castOrCreate, this.defaultConfig, Arrays.asList(this.closeable1, this.closeable2));
    }

    @Test
    void testExecute() throws Exception {
        HttpGet httpget = new HttpGet("http://somehost/stuff");
        HttpRoute route = new HttpRoute(new HttpHost("somehost", 80));
        Mockito.when((Object)this.routePlanner.determineRoute((HttpHost)Mockito.eq((Object)new HttpHost("somehost")), (HttpRequest)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)route);
        Mockito.when((Object)this.execChain.execute((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any(), (ExecChain)Mockito.any())).thenReturn((Object)CloseableHttpResponse.adapt((ClassicHttpResponse)new BasicClassicHttpResponse(200)));
        this.client.execute((ClassicHttpRequest)httpget, response -> null);
        ((ExecChainHandler)Mockito.verify((Object)this.execChain)).execute((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any(), (ExecChain)Mockito.any());
    }

    @Test
    void testExecuteHttpException() throws Exception {
        HttpGet httpget = new HttpGet("http://somehost/stuff");
        HttpRoute route = new HttpRoute(new HttpHost("somehost", 80));
        Mockito.when((Object)this.routePlanner.determineRoute((HttpHost)Mockito.eq((Object)new HttpHost("somehost")), (HttpRequest)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)route);
        Mockito.when((Object)this.execChain.execute((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any(), (ExecChain)Mockito.any())).thenReturn((Object)CloseableHttpResponse.adapt((ClassicHttpResponse)new BasicClassicHttpResponse(200)));
        Mockito.when((Object)this.execChain.execute((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any(), (ExecChain)Mockito.any())).thenThrow(new Throwable[]{new HttpException()});
        Assertions.assertThrows(ClientProtocolException.class, () -> this.client.execute((ClassicHttpRequest)httpget, response -> null));
    }

    @Test
    void testExecuteDefaultContext() throws Exception {
        HttpGet httpget = new HttpGet("http://somehost/stuff");
        HttpRoute route = new HttpRoute(new HttpHost("somehost", 80));
        Mockito.when((Object)this.routePlanner.determineRoute((HttpHost)Mockito.eq((Object)new HttpHost("somehost")), (HttpRequest)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)route);
        Mockito.when((Object)this.execChain.execute((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any(), (ExecChain)Mockito.any())).thenReturn((Object)CloseableHttpResponse.adapt((ClassicHttpResponse)new BasicClassicHttpResponse(200)));
        HttpClientContext context = HttpClientContext.create();
        this.client.execute((ClassicHttpRequest)httpget, (HttpContext)context, response -> null);
        Assertions.assertSame(this.cookieSpecRegistry, (Object)context.getCookieSpecRegistry());
        Assertions.assertSame(this.authSchemeRegistry, (Object)context.getAuthSchemeRegistry());
        Assertions.assertSame((Object)this.cookieStore, (Object)context.getCookieStore());
        Assertions.assertSame((Object)this.credentialsProvider, (Object)context.getCredentialsProvider());
        Assertions.assertSame((Object)this.defaultConfig, (Object)context.getRequestConfigOrDefault());
    }

    @Test
    void testExecuteRequestConfig() throws Exception {
        HttpGet httpget = new HttpGet("http://somehost/stuff");
        HttpRoute route = new HttpRoute(new HttpHost("somehost", 80));
        Mockito.when((Object)this.routePlanner.determineRoute((HttpHost)Mockito.eq((Object)new HttpHost("somehost")), (HttpRequest)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)route);
        Mockito.when((Object)this.execChain.execute((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any(), (ExecChain)Mockito.any())).thenReturn((Object)CloseableHttpResponse.adapt((ClassicHttpResponse)new BasicClassicHttpResponse(200)));
        RequestConfig config = RequestConfig.custom().build();
        httpget.setConfig(config);
        HttpClientContext context = HttpClientContext.create();
        this.client.execute((ClassicHttpRequest)httpget, (HttpContext)context, response -> null);
        Assertions.assertSame((Object)config, (Object)context.getRequestConfigOrDefault());
    }

    @Test
    void testExecuteLocalContext() throws Exception {
        HttpGet httpget = new HttpGet("http://somehost/stuff");
        HttpRoute route = new HttpRoute(new HttpHost("somehost", 80));
        Mockito.when((Object)this.routePlanner.determineRoute((HttpHost)Mockito.eq((Object)new HttpHost("somehost")), (HttpRequest)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)route);
        Mockito.when((Object)this.execChain.execute((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any(), (ExecChain)Mockito.any())).thenReturn((Object)CloseableHttpResponse.adapt((ClassicHttpResponse)new BasicClassicHttpResponse(200)));
        HttpClientContext context = HttpClientContext.create();
        Lookup localCookieSpecRegistry = (Lookup)Mockito.mock(Lookup.class);
        Lookup localAuthSchemeRegistry = (Lookup)Mockito.mock(Lookup.class);
        CookieStore localCookieStore = (CookieStore)Mockito.mock(CookieStore.class);
        CredentialsProvider localCredentialsProvider = (CredentialsProvider)Mockito.mock(CredentialsProvider.class);
        RequestConfig localConfig = RequestConfig.custom().build();
        context.setCookieSpecRegistry(localCookieSpecRegistry);
        context.setAuthSchemeRegistry(localAuthSchemeRegistry);
        context.setCookieStore(localCookieStore);
        context.setCredentialsProvider(localCredentialsProvider);
        context.setRequestConfig(localConfig);
        this.client.execute((ClassicHttpRequest)httpget, (HttpContext)context, response -> null);
        Assertions.assertSame((Object)localCookieSpecRegistry, (Object)context.getCookieSpecRegistry());
        Assertions.assertSame((Object)localAuthSchemeRegistry, (Object)context.getAuthSchemeRegistry());
        Assertions.assertSame((Object)localCookieStore, (Object)context.getCookieStore());
        Assertions.assertSame((Object)localCredentialsProvider, (Object)context.getCredentialsProvider());
        Assertions.assertSame((Object)localConfig, (Object)context.getRequestConfigOrDefault());
    }

    @Test
    void testClientClose() throws Exception {
        this.client.close();
        ((Closeable)Mockito.verify((Object)this.closeable1)).close();
        ((Closeable)Mockito.verify((Object)this.closeable2)).close();
    }

    @Test
    void testClientCloseIOException() throws Exception {
        ((Closeable)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.closeable1)).close();
        this.client.close();
        ((Closeable)Mockito.verify((Object)this.closeable1)).close();
        ((Closeable)Mockito.verify((Object)this.closeable2)).close();
    }
}

