/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import java.net.InetAddress;
import java.util.HashSet;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHttpRoute {
    public static final HttpHost TARGET1 = new HttpHost("target1.test.invalid", 80);
    public static final HttpHost TARGET2 = new HttpHost("target2.test.invalid", 8080);
    public static final HttpHost PROXY1 = new HttpHost("proxy1.test.invalid");
    public static final HttpHost PROXY2 = new HttpHost("proxy2.test.invalid", 1080);
    public static final HttpHost PROXY3 = new HttpHost("proxy3.test.invalid", 88);
    public static final InetAddress LOCAL41;
    public static final InetAddress LOCAL42;
    public static final InetAddress LOCAL61;
    public static final InetAddress LOCAL62;

    TestHttpRoute() {
    }

    @Test
    void testCstrFullRoute() {
        HttpHost[] chain3 = new HttpHost[]{PROXY1, PROXY2, PROXY3};
        HttpRoute route = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        Assertions.assertEquals((Object)TARGET1, (Object)route.getTargetHost(), (String)"wrong target");
        Assertions.assertEquals((Object)LOCAL41, (Object)route.getLocalAddress(), (String)"wrong local address");
        Assertions.assertEquals((Object)PROXY1, (Object)route.getProxyHost(), (String)"wrong proxy host");
        Assertions.assertEquals((int)4, (int)route.getHopCount(), (String)"wrong hop count");
        Assertions.assertEquals((Object)PROXY1, (Object)route.getHopTarget(0), (String)"wrong hop 0");
        Assertions.assertEquals((Object)PROXY2, (Object)route.getHopTarget(1), (String)"wrong hop 1");
        Assertions.assertEquals((Object)PROXY3, (Object)route.getHopTarget(2), (String)"wrong hop 2");
        Assertions.assertEquals((Object)TARGET1, (Object)route.getHopTarget(3), (String)"wrong hop 3");
        Assertions.assertFalse((boolean)route.isSecure(), (String)"wrong flag: secured");
        Assertions.assertFalse((boolean)route.isTunnelled(), (String)"wrong flag: tunnelled");
        Assertions.assertFalse((boolean)route.isLayered(), (String)"wrong flag: layered");
        String routestr = route.toString();
        Assertions.assertTrue((boolean)routestr.contains(TARGET1.getHostName()), (String)"missing target in toString");
        Assertions.assertTrue((boolean)routestr.contains(LOCAL41.toString()), (String)"missing local address in toString");
        Assertions.assertTrue((boolean)routestr.contains(PROXY1.getHostName()), (String)"missing proxy 1 in toString");
        Assertions.assertTrue((boolean)routestr.contains(PROXY2.getHostName()), (String)"missing proxy 2 in toString");
        Assertions.assertTrue((boolean)routestr.contains(PROXY3.getHostName()), (String)"missing proxy 3 in toString");
    }

    @Test
    void testCstrFullFlags() {
        HttpHost[] chain3 = new HttpHost[]{PROXY1, PROXY2, PROXY3};
        HttpRoute routefff = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute routefft = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.LAYERED);
        HttpRoute routeftf = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        HttpRoute routeftt = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        HttpRoute routetff = new HttpRoute(TARGET1, LOCAL41, chain3, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute routetft = new HttpRoute(TARGET1, LOCAL41, chain3, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.LAYERED);
        HttpRoute routettf = new HttpRoute(TARGET1, LOCAL41, chain3, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        HttpRoute routettt = new HttpRoute(TARGET1, LOCAL41, chain3, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        Assertions.assertFalse((boolean)routefff.isSecure(), (String)"routefff.secure");
        Assertions.assertFalse((boolean)routefff.isTunnelled(), (String)"routefff.tunnel");
        Assertions.assertFalse((boolean)routefff.isLayered(), (String)"routefff.layer");
        Assertions.assertFalse((boolean)routefft.isSecure(), (String)"routefft.secure");
        Assertions.assertFalse((boolean)routefft.isTunnelled(), (String)"routefft.tunnel");
        Assertions.assertTrue((boolean)routefft.isLayered(), (String)"routefft.layer");
        Assertions.assertFalse((boolean)routeftf.isSecure(), (String)"routeftf.secure");
        Assertions.assertTrue((boolean)routeftf.isTunnelled(), (String)"routeftf.tunnel");
        Assertions.assertFalse((boolean)routeftf.isLayered(), (String)"routeftf.layer");
        Assertions.assertFalse((boolean)routeftt.isSecure(), (String)"routeftt.secure");
        Assertions.assertTrue((boolean)routeftt.isTunnelled(), (String)"routeftt.tunnel");
        Assertions.assertTrue((boolean)routeftt.isLayered(), (String)"routeftt.layer");
        Assertions.assertTrue((boolean)routetff.isSecure(), (String)"routetff.secure");
        Assertions.assertFalse((boolean)routetff.isTunnelled(), (String)"routetff.tunnel");
        Assertions.assertFalse((boolean)routetff.isLayered(), (String)"routetff.layer");
        Assertions.assertTrue((boolean)routetft.isSecure(), (String)"routetft.secure");
        Assertions.assertFalse((boolean)routetft.isTunnelled(), (String)"routetft.tunnel");
        Assertions.assertTrue((boolean)routetft.isLayered(), (String)"routetft.layer");
        Assertions.assertTrue((boolean)routettf.isSecure(), (String)"routettf.secure");
        Assertions.assertTrue((boolean)routettf.isTunnelled(), (String)"routettf.tunnel");
        Assertions.assertFalse((boolean)routettf.isLayered(), (String)"routettf.layer");
        Assertions.assertTrue((boolean)routettt.isSecure(), (String)"routettt.secure");
        Assertions.assertTrue((boolean)routettt.isTunnelled(), (String)"routettt.tunnel");
        Assertions.assertTrue((boolean)routettt.isLayered(), (String)"routettt.layer");
    }

    @Test
    void testInvalidArguments() {
        HttpHost[] chain1 = new HttpHost[]{PROXY1};
        HttpRoute route = new HttpRoute(TARGET1, null, chain1, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        Assertions.assertNotNull((Object)route);
        Assertions.assertThrows(NullPointerException.class, () -> new HttpRoute(null, null, chain1, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HttpRoute(TARGET1, null, (HttpHost[])null, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN));
    }

    @Test
    void testNullEnums() {
        HttpRoute route = new HttpRoute(TARGET1, null, PROXY1, false, null, null);
        Assertions.assertFalse((boolean)route.isTunnelled(), (String)"default tunnelling");
        Assertions.assertEquals((Object)RouteInfo.TunnelType.PLAIN, (Object)route.getTunnelType(), (String)"untunnelled");
        Assertions.assertFalse((boolean)route.isLayered(), (String)"default layering");
        Assertions.assertEquals((Object)RouteInfo.LayerType.PLAIN, (Object)route.getLayerType(), (String)"unlayered");
    }

    @Test
    void testEqualsHashcodeClone() throws CloneNotSupportedException {
        HttpHost[] chain0 = new HttpHost[]{};
        HttpHost[] chain1 = new HttpHost[]{PROXY1};
        HttpHost[] chain3 = new HttpHost[]{PROXY1, PROXY2, PROXY3};
        HttpHost[] chain4 = new HttpHost[]{PROXY1, PROXY3, PROXY2};
        HttpRoute route1a = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route1b = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route1c = (HttpRoute)route1a.clone();
        Assertions.assertEquals((Object)route1a, (Object)route1a, (String)"1a 1a");
        Assertions.assertEquals((Object)route1a, (Object)route1b, (String)"1a 1b");
        Assertions.assertEquals((Object)route1a, (Object)route1c, (String)"1a 1c");
        Assertions.assertEquals((int)route1a.hashCode(), (int)route1a.hashCode(), (String)"hashcode 1a");
        Assertions.assertEquals((int)route1a.hashCode(), (int)route1b.hashCode(), (String)"hashcode 1b");
        Assertions.assertEquals((int)route1a.hashCode(), (int)route1c.hashCode(), (String)"hashcode 1c");
        Assertions.assertEquals((Object)route1a.toString(), (Object)route1b.toString(), (String)"toString 1b");
        Assertions.assertEquals((Object)route1a.toString(), (Object)route1a.toString(), (String)"toString 1a");
        Assertions.assertEquals((Object)route1a.toString(), (Object)route1c.toString(), (String)"toString 1c");
        HttpRoute route2a = new HttpRoute(TARGET2, LOCAL41, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2b = new HttpRoute(TARGET1, LOCAL42, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2c = new HttpRoute(TARGET1, LOCAL61, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2d = new HttpRoute(TARGET1, null, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2e = new HttpRoute(TARGET1, LOCAL41, (HttpHost[])null, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2f = new HttpRoute(TARGET1, LOCAL41, chain0, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2g = new HttpRoute(TARGET1, LOCAL41, chain1, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2h = new HttpRoute(TARGET1, LOCAL41, chain4, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2i = new HttpRoute(TARGET1, LOCAL41, chain3, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2j = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        HttpRoute route2k = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.LAYERED);
        HttpRoute route2m = new HttpRoute(TARGET2, (NamedEndpoint)new URIAuthority(TARGET2.getHostName(), TARGET2.getPort()), LOCAL41, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        Assertions.assertEquals((Object)route2e, (Object)route2f, (String)"2e 2f");
        Assertions.assertEquals((int)route2e.hashCode(), (int)route2f.hashCode(), (String)"hashcode 2e 2f");
        Assertions.assertEquals((Object)route2e.toString(), (Object)route2f.toString(), (String)"toString 2e 2f");
        Assertions.assertNotEquals((Object)route1a, (Object)route2a, (String)"1a 2a");
        Assertions.assertNotEquals((Object)route1a, (Object)route2b, (String)"1a 2b");
        Assertions.assertNotEquals((Object)route1a, (Object)route2c, (String)"1a 2c");
        Assertions.assertNotEquals((Object)route1a, (Object)route2d, (String)"1a 2d");
        Assertions.assertNotEquals((Object)route1a, (Object)route2e, (String)"1a 2e");
        Assertions.assertNotEquals((Object)route1a, (Object)route2f, (String)"1a 2f");
        Assertions.assertNotEquals((Object)route1a, (Object)route2g, (String)"1a 2g");
        Assertions.assertNotEquals((Object)route1a, (Object)route2h, (String)"1a 2h");
        Assertions.assertNotEquals((Object)route1a, (Object)route2i, (String)"1a 2i");
        Assertions.assertNotEquals((Object)route1a, (Object)route2j, (String)"1a 2j");
        Assertions.assertNotEquals((Object)route1a, (Object)route2k, (String)"1a 2k");
        Assertions.assertNotEquals((Object)route1a, (Object)route2m, (String)"1a 2k");
        Assertions.assertNotEquals((Object)route2b, (Object)route1a, (String)"2b 1a");
        Assertions.assertNotEquals((Object)route2c, (Object)route1a, (String)"2c 1a");
        Assertions.assertNotEquals((Object)route2d, (Object)route1a, (String)"2d 1a");
        Assertions.assertNotEquals((Object)route2e, (Object)route1a, (String)"2e 1a");
        Assertions.assertNotEquals((Object)route2a, (Object)route1a, (String)"2a 1a");
        Assertions.assertNotEquals((Object)route2f, (Object)route1a, (String)"2f 1a");
        Assertions.assertNotEquals((Object)route2g, (Object)route1a, (String)"2g 1a");
        Assertions.assertNotEquals((Object)route2h, (Object)route1a, (String)"2h 1a");
        Assertions.assertNotEquals((Object)route2i, (Object)route1a, (String)"2i 1a");
        Assertions.assertNotEquals((Object)route2j, (Object)route1a, (String)"2j 1a");
        Assertions.assertNotEquals((Object)route2k, (Object)route1a, (String)"2k 1a");
        Assertions.assertNotEquals((Object)route2m, (Object)route1a, (String)"2k 1a");
        Assertions.assertNotEquals((Object)route1a.toString(), (Object)route2a.toString(), (String)"toString 1a 2a");
        Assertions.assertNotEquals((Object)route1a.toString(), (Object)route2b.toString(), (String)"toString 1a 2b");
        Assertions.assertNotEquals((Object)route1a.toString(), (Object)route2c.toString(), (String)"toString 1a 2c");
        Assertions.assertNotEquals((Object)route1a.toString(), (Object)route2d.toString(), (String)"toString 1a 2d");
        Assertions.assertNotEquals((Object)route1a.toString(), (Object)route2e.toString(), (String)"toString 1a 2e");
        Assertions.assertNotEquals((Object)route1a.toString(), (Object)route2f.toString(), (String)"toString 1a 2f");
        Assertions.assertNotEquals((Object)route1a.toString(), (Object)route2g.toString(), (String)"toString 1a 2g");
        Assertions.assertNotEquals((Object)route1a.toString(), (Object)route2h.toString(), (String)"toString 1a 2h");
        Assertions.assertNotEquals((Object)route1a.toString(), (Object)route2i.toString(), (String)"toString 1a 2i");
        Assertions.assertNotEquals((Object)route1a.toString(), (Object)route2j.toString(), (String)"toString 1a 2j");
        Assertions.assertNotEquals((Object)route1a.toString(), (Object)route2k.toString(), (String)"toString 1a 2k");
        Assertions.assertNotEquals((Object)route1a.toString(), (Object)route2m.toString(), (String)"toString 1a 2k");
        HashSet<HttpRoute> routes = new HashSet<HttpRoute>();
        routes.add(route1a);
        routes.add(route2a);
        routes.add(route2b);
        routes.add(route2c);
        routes.add(route2d);
        routes.add(route2e);
        routes.add(route2g);
        routes.add(route2h);
        routes.add(route2i);
        routes.add(route2j);
        routes.add(route2k);
        routes.add(route2m);
        for (HttpRoute origin : routes) {
            HttpRoute cloned = (HttpRoute)origin.clone();
            Assertions.assertEquals((Object)origin, (Object)cloned, (String)("clone of " + origin));
            Assertions.assertTrue((boolean)routes.contains(cloned), (String)("clone of " + origin));
        }
        Assertions.assertNotEquals(null, (Object)route1a, (String)"route equals null");
        Assertions.assertNotEquals((Object)"route1a", (Object)route1a, (String)"route equals string");
    }

    @Test
    void testHopping() {
        HttpHost[] proxies = null;
        HttpRoute route = new HttpRoute(TARGET1, null, proxies, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        Assertions.assertEquals((int)1, (int)route.getHopCount(), (String)"A: hop count");
        Assertions.assertEquals((Object)TARGET1, (Object)route.getHopTarget(0), (String)"A: hop 0");
        Assertions.assertThrows(IllegalArgumentException.class, () -> route.getHopTarget(1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> route.getHopTarget(-1));
        HttpHost[] proxies2 = new HttpHost[]{PROXY3};
        HttpRoute route2 = new HttpRoute(TARGET1, LOCAL62, proxies2, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        Assertions.assertEquals((int)2, (int)route2.getHopCount(), (String)"B: hop count");
        Assertions.assertEquals((Object)PROXY3, (Object)route2.getHopTarget(0), (String)"B: hop 0");
        Assertions.assertEquals((Object)TARGET1, (Object)route2.getHopTarget(1), (String)"B: hop 1");
        Assertions.assertThrows(IllegalArgumentException.class, () -> route2.getHopTarget(2));
        Assertions.assertThrows(IllegalArgumentException.class, () -> route2.getHopTarget(-2));
        HttpHost[] proxies3 = new HttpHost[]{PROXY3, PROXY1, PROXY2};
        HttpRoute route3 = new HttpRoute(TARGET1, LOCAL42, proxies3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.LAYERED);
        Assertions.assertEquals((int)4, (int)route3.getHopCount(), (String)"C: hop count");
        Assertions.assertEquals((Object)PROXY3, (Object)route3.getHopTarget(0), (String)"C: hop 0");
        Assertions.assertEquals((Object)PROXY1, (Object)route3.getHopTarget(1), (String)"C: hop 1");
        Assertions.assertEquals((Object)PROXY2, (Object)route3.getHopTarget(2), (String)"C: hop 2");
        Assertions.assertEquals((Object)TARGET1, (Object)route3.getHopTarget(3), (String)"C: hop 3");
        Assertions.assertThrows(IllegalArgumentException.class, () -> route3.getHopTarget(4));
        Assertions.assertThrows(IllegalArgumentException.class, () -> route3.getHopTarget(Integer.MIN_VALUE));
    }

    @Test
    void testCstr1() {
        HttpRoute route = new HttpRoute(TARGET2);
        HttpRoute should = new HttpRoute(TARGET2, null, (HttpHost[])null, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        Assertions.assertEquals((Object)route, (Object)should, (String)"bad convenience route");
    }

    @Test
    void testCstr3() {
        HttpRoute route = new HttpRoute(TARGET2, LOCAL61, false);
        HttpRoute should = new HttpRoute(TARGET2, LOCAL61, (HttpHost[])null, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        Assertions.assertEquals((Object)route, (Object)should, (String)"bad convenience route 3/insecure");
        route = new HttpRoute(TARGET2, null, true);
        should = new HttpRoute(TARGET2, null, (HttpHost[])null, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        Assertions.assertEquals((Object)route, (Object)should, (String)"bad convenience route 3/secure");
    }

    @Test
    void testCstr4() {
        HttpRoute route = new HttpRoute(TARGET2, null, PROXY2, false);
        HttpRoute should = new HttpRoute(TARGET2, null, new HttpHost[]{PROXY2}, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        Assertions.assertEquals((Object)route, (Object)should, (String)"bad convenience route 4/insecure");
        route = new HttpRoute(TARGET2, LOCAL42, PROXY1, true);
        should = new HttpRoute(TARGET2, LOCAL42, new HttpHost[]{PROXY1}, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        Assertions.assertEquals((Object)route, (Object)should, (String)"bad convenience route 4/secure");
        Assertions.assertThrows(NullPointerException.class, () -> new HttpRoute(TARGET1, LOCAL61, null, false));
    }

    @Test
    void testCstr6() {
        HttpRoute route = new HttpRoute(TARGET2, null, PROXY2, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        HttpRoute should = new HttpRoute(TARGET2, null, new HttpHost[]{PROXY2}, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        Assertions.assertEquals((Object)route, (Object)should, (String)"bad convenience route 6/proxied");
        route = new HttpRoute(TARGET2, null, (HttpHost)null, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.LAYERED);
        should = new HttpRoute(TARGET2, null, (HttpHost[])null, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.LAYERED);
        Assertions.assertEquals((Object)route, (Object)should, (String)"bad convenience route 6/direct");
    }

    @Test
    void testImmutable() throws CloneNotSupportedException {
        HttpHost[] proxies = new HttpHost[]{PROXY1, PROXY2, PROXY3};
        HttpRoute route1 = new HttpRoute(TARGET1, null, proxies, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2 = (HttpRoute)route1.clone();
        HttpRoute route3 = new HttpRoute(TARGET1, null, (HttpHost[])proxies.clone(), false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        proxies[1] = PROXY3;
        proxies[2] = PROXY2;
        Assertions.assertEquals((Object)route2, (Object)route1, (String)"route differs from clone");
        Assertions.assertEquals((Object)route3, (Object)route1, (String)"route was modified");
    }

    static {
        try {
            LOCAL41 = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            LOCAL42 = InetAddress.getByAddress(new byte[]{127, 0, 0, 2});
            LOCAL61 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
            LOCAL62 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2});
        }
        catch (Exception x) {
            throw new ExceptionInInitializerError(x);
        }
    }
}

