/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.util.ArrayList;
import org.apache.hc.client5.http.protocol.RequestDefaultHeaders;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRequestDefaultHeaders {
    @Test
    public void testRequestParameterCheck() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        RequestDefaultHeaders interceptor = RequestDefaultHeaders.INSTANCE;
        Assertions.assertThrows(NullPointerException.class, () -> TestRequestDefaultHeaders.lambda$testRequestParameterCheck$0((HttpRequestInterceptor)interceptor, (HttpContext)context));
    }

    @Test
    public void testNoDefaultHeadersForConnectRequest() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("CONNECT", "www.somedomain.com");
        ArrayList<BasicHeader> defheaders = new ArrayList<BasicHeader>();
        defheaders.add(new BasicHeader("custom", (Object)"stuff"));
        BasicHttpContext context = new BasicHttpContext();
        RequestDefaultHeaders interceptor = new RequestDefaultHeaders(defheaders);
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header header1 = request.getFirstHeader("custom");
        Assertions.assertNull((Object)header1);
    }

    @Test
    public void testDefaultHeaders() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader("custom", (Object)"stuff");
        ArrayList<BasicHeader> defheaders = new ArrayList<BasicHeader>();
        defheaders.add(new BasicHeader("custom", (Object)"other stuff"));
        BasicHttpContext context = new BasicHttpContext();
        RequestDefaultHeaders interceptor = new RequestDefaultHeaders(defheaders);
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header[] headers = request.getHeaders("custom");
        Assertions.assertNotNull((Object)headers);
        Assertions.assertEquals((int)1, (int)headers.length);
        Assertions.assertEquals((Object)"stuff", (Object)headers[0].getValue());
    }

    private static /* synthetic */ void lambda$testRequestParameterCheck$0(HttpRequestInterceptor interceptor, HttpContext context) throws Throwable {
        interceptor.process(null, null, context);
    }
}

