/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.routing;

import java.net.InetAddress;
import java.util.HashSet;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.client5.http.RouteTracker;
import org.apache.hc.client5.http.impl.routing.BasicRouteDirector;
import org.apache.hc.client5.http.routing.HttpRouteDirector;
import org.apache.hc.core5.http.HttpHost;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRouteTracker {
    public static final HttpHost TARGET1 = new HttpHost("target1.test.invalid", 80);
    public static final HttpHost TARGET2 = new HttpHost("target2.test.invalid", 8080);
    public static final HttpHost PROXY1 = new HttpHost("proxy1.test.invalid", 80);
    public static final HttpHost PROXY2 = new HttpHost("proxy2.test.invalid", 1080);
    public static final HttpHost PROXY3 = new HttpHost("proxy3.test.invalid", 88);
    public static final InetAddress LOCAL41;
    public static final InetAddress LOCAL42;
    public static final InetAddress LOCAL61;
    public static final InetAddress LOCAL62;

    @Test
    public void testCstrTargetLocal() {
        RouteTracker rt = new RouteTracker(TARGET1, null);
        Assertions.assertEquals((Object)TARGET1, (Object)rt.getTargetHost(), (String)"wrong target (target,null)");
        Assertions.assertNull((Object)rt.getLocalAddress(), (String)"wrong local address (target,null)");
        Assertions.assertEquals((int)0, (int)rt.getHopCount(), (String)"wrong hop count (target,null)");
        Assertions.assertNull((Object)rt.getProxyHost(), (String)"wrong proxy (target,null)");
        Assertions.assertNull((Object)rt.toRoute(), (String)"wrong route (target,null)");
        TestRouteTracker.checkCTLS(rt, false, false, false, false);
        rt = new RouteTracker(TARGET2, LOCAL61);
        Assertions.assertEquals((Object)TARGET2, (Object)rt.getTargetHost(), (String)"wrong target (target,local)");
        Assertions.assertEquals((Object)LOCAL61, (Object)rt.getLocalAddress(), (String)"wrong local address (target,local)");
        Assertions.assertEquals((int)0, (int)rt.getHopCount(), (String)"wrong hop count (target,local)");
        Assertions.assertNull((Object)rt.getProxyHost(), (String)"wrong proxy (target,local)");
        Assertions.assertNull((Object)rt.toRoute(), (String)"wrong route (target,local)");
        TestRouteTracker.checkCTLS(rt, false, false, false, false);
        Assertions.assertThrows(NullPointerException.class, () -> new RouteTracker(null, LOCAL41));
    }

    @Test
    public void testCstrRoute() {
        HttpRoute r = new HttpRoute(TARGET1);
        RouteTracker rt = new RouteTracker(r);
        Assertions.assertEquals((Object)TARGET1, (Object)rt.getTargetHost(), (String)"wrong target (r1)");
        Assertions.assertNull((Object)rt.getLocalAddress(), (String)"wrong local address (r1)");
        Assertions.assertEquals((int)0, (int)rt.getHopCount(), (String)"wrong hop count (r1)");
        Assertions.assertNull((Object)rt.getProxyHost(), (String)"wrong proxy (r1)");
        Assertions.assertNull((Object)rt.toRoute(), (String)"wrong route (r1)");
        TestRouteTracker.checkCTLS(rt, false, false, false, false);
        r = new HttpRoute(TARGET2, LOCAL61, true);
        rt = new RouteTracker(r);
        Assertions.assertEquals((Object)TARGET2, (Object)rt.getTargetHost(), (String)"wrong target (r2)");
        Assertions.assertEquals((Object)LOCAL61, (Object)rt.getLocalAddress(), (String)"wrong local address (r2)");
        Assertions.assertEquals((int)0, (int)rt.getHopCount(), (String)"wrong hop count (r2)");
        Assertions.assertNull((Object)rt.getProxyHost(), (String)"wrong proxy (r2)");
        Assertions.assertNull((Object)rt.toRoute(), (String)"wrong route (r2)");
        TestRouteTracker.checkCTLS(rt, false, false, false, false);
        r = new HttpRoute(TARGET1, LOCAL42, PROXY3, true);
        rt = new RouteTracker(r);
        Assertions.assertEquals((Object)TARGET1, (Object)rt.getTargetHost(), (String)"wrong target (r3)");
        Assertions.assertEquals((Object)LOCAL42, (Object)rt.getLocalAddress(), (String)"wrong local address (r3)");
        Assertions.assertEquals((int)0, (int)rt.getHopCount(), (String)"wrong hop count (r3)");
        Assertions.assertNull((Object)rt.getProxyHost(), (String)"wrong proxy (r3)");
        Assertions.assertNull((Object)rt.toRoute(), (String)"wrong route (r3)");
        TestRouteTracker.checkCTLS(rt, false, false, false, false);
        Assertions.assertThrows(NullPointerException.class, () -> new RouteTracker(null));
    }

    @Test
    public void testIllegalArgs() {
        RouteTracker rt = new RouteTracker(TARGET2, null);
        Assertions.assertThrows(NullPointerException.class, () -> rt.connectProxy(null, true));
        Assertions.assertThrows(NullPointerException.class, () -> rt.connectProxy(null, false));
        rt.connectProxy(PROXY1, false);
        Assertions.assertThrows(NullPointerException.class, () -> rt.tunnelProxy(null, false));
        Assertions.assertThrows(NullPointerException.class, () -> rt.tunnelProxy(null, true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> rt.getHopTarget(-1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> rt.getHopTarget(2));
    }

    @Test
    public void testIllegalStates() {
        RouteTracker rt = new RouteTracker(TARGET1, null);
        Assertions.assertThrows(IllegalStateException.class, () -> rt.tunnelTarget(false));
        Assertions.assertThrows(IllegalStateException.class, () -> rt.tunnelProxy(PROXY1, false));
        Assertions.assertThrows(IllegalStateException.class, () -> rt.layerProtocol(true));
        rt.connectTarget(false);
        Assertions.assertThrows(IllegalStateException.class, () -> rt.connectTarget(false));
        Assertions.assertThrows(IllegalStateException.class, () -> rt.connectProxy(PROXY2, false));
        Assertions.assertThrows(IllegalStateException.class, () -> rt.tunnelTarget(false));
        Assertions.assertThrows(IllegalStateException.class, () -> rt.tunnelProxy(PROXY1, false));
    }

    @Test
    public void testDirectRoutes() {
        BasicRouteDirector rd = BasicRouteDirector.INSTANCE;
        HttpRoute r = new HttpRoute(TARGET1, LOCAL41, false);
        RouteTracker rt = new RouteTracker(r);
        boolean complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 2);
        Assertions.assertTrue((boolean)complete, (String)"incomplete route 1");
        r = new HttpRoute(TARGET2, LOCAL62, true);
        rt = new RouteTracker(r);
        complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 2);
        Assertions.assertTrue((boolean)complete, (String)"incomplete route 2");
    }

    @Test
    public void testProxyRoutes() {
        BasicRouteDirector rd = BasicRouteDirector.INSTANCE;
        HttpRoute r = new HttpRoute(TARGET2, null, PROXY1, false);
        RouteTracker rt = new RouteTracker(r);
        boolean complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 2);
        Assertions.assertTrue((boolean)complete, (String)"incomplete route 1");
        r = new HttpRoute(TARGET1, LOCAL61, PROXY3, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        rt = new RouteTracker(r);
        complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 3);
        Assertions.assertTrue((boolean)complete, (String)"incomplete route 2");
        r = new HttpRoute(TARGET1, LOCAL61, PROXY3, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        rt = new RouteTracker(r);
        complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 4);
        Assertions.assertTrue((boolean)complete, (String)"incomplete route 3");
        r = new HttpRoute(TARGET1, LOCAL61, PROXY3, true);
        rt = new RouteTracker(r);
        complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 4);
        Assertions.assertTrue((boolean)complete, (String)"incomplete route 4");
    }

    @Test
    public void testProxyChainRoutes() {
        BasicRouteDirector rd = BasicRouteDirector.INSTANCE;
        HttpHost[] proxies = new HttpHost[]{PROXY1, PROXY2};
        HttpRoute r = new HttpRoute(TARGET2, LOCAL42, proxies, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        RouteTracker rt = new RouteTracker(r);
        boolean complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 3);
        Assertions.assertTrue((boolean)complete, (String)"incomplete route 1");
        proxies = new HttpHost[]{PROXY3, PROXY2};
        r = new HttpRoute(TARGET1, null, proxies, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        rt = new RouteTracker(r);
        complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 4);
        Assertions.assertTrue((boolean)complete, (String)"incomplete route 2");
        proxies = new HttpHost[]{PROXY3, PROXY2, PROXY1};
        r = new HttpRoute(TARGET2, LOCAL61, proxies, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        rt = new RouteTracker(r);
        complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 6);
        Assertions.assertTrue((boolean)complete, (String)"incomplete route 3");
        proxies = new HttpHost[]{PROXY1, PROXY3};
        r = new HttpRoute(TARGET1, LOCAL61, proxies, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        rt = new RouteTracker(r);
        complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 5);
        Assertions.assertTrue((boolean)complete, (String)"incomplete route 4");
    }

    @Test
    public void testEqualsHashcodeCloneToString() throws CloneNotSupportedException {
        RouteTracker rt0 = new RouteTracker(TARGET1, null);
        RouteTracker rt1 = new RouteTracker(TARGET2, null);
        RouteTracker rt2 = new RouteTracker(TARGET1, null);
        RouteTracker rt3 = new RouteTracker(TARGET1, null);
        RouteTracker rt4 = new RouteTracker(TARGET1, LOCAL41);
        RouteTracker rt6 = new RouteTracker(TARGET1, LOCAL62);
        Assertions.assertNotEquals(null, (Object)rt0, (String)"rt0");
        Assertions.assertEquals((Object)rt0, (Object)rt0, (String)"rt0");
        Assertions.assertNotEquals((Object)"rt0", (Object)rt0, (String)rt0.toString());
        Assertions.assertNotEquals((Object)rt0, (Object)rt4, (String)"rt0 == rt4");
        Assertions.assertNotEquals((Object)rt0, (Object)rt1, (String)"rt0 == rt1");
        Assertions.assertEquals((Object)rt0, (Object)rt2, (String)"rt0 != rt2");
        rt2.connectTarget(false);
        Assertions.assertNotEquals((Object)rt0, (Object)rt2, (String)"rt0 == rt2");
        Assertions.assertEquals((Object)rt0, (Object)rt3, (String)"rt0 != rt3");
        rt3.connectTarget(true);
        Assertions.assertNotEquals((Object)rt0, (Object)rt3, (String)"rt0 == rt3");
        Assertions.assertNotEquals((Object)rt2, (Object)rt3, (String)"rt2 == rt3");
        Assertions.assertNotEquals((Object)rt4, (Object)rt0, (String)"rt4 == rt0");
        Assertions.assertNotEquals((Object)rt0, (Object)rt6, (String)"rt0 == rt6");
        Assertions.assertNotEquals((Object)rt6, (Object)rt0, (String)"rt6 == rt0");
        Assertions.assertNotEquals((Object)rt4, (Object)rt6, (String)"rt4 == rt6");
        Assertions.assertNotEquals((Object)rt6, (Object)rt4, (String)"rt6 == rt4");
        Assertions.assertNotEquals((int)rt0.hashCode(), (int)rt4.hashCode(), (String)"rt0 == rt4 (hashcode)");
        Assertions.assertNotEquals((int)rt0.hashCode(), (int)rt6.hashCode(), (String)"rt0 == rt6 (hashcode)");
        Assertions.assertNotEquals((int)rt6.hashCode(), (int)rt4.hashCode(), (String)"rt6 == rt4 (hashcode)");
        Assertions.assertEquals((Object)rt0, (Object)rt0.clone(), (String)"rt0 (clone)");
        Assertions.assertEquals((Object)rt4, (Object)rt4.clone(), (String)"rt4 (clone)");
        Assertions.assertEquals((Object)rt6, (Object)rt6.clone(), (String)"rt6 (clone)");
        HashSet<RouteTracker> hs = new HashSet<RouteTracker>();
        HashSet<Integer> hc0 = new HashSet<Integer>();
        HashSet<Integer> hc4 = new HashSet<Integer>();
        HashSet<Integer> hc6 = new HashSet<Integer>();
        RouteTracker rt = null;
        Assertions.assertTrue((boolean)hs.add(rt0));
        Assertions.assertTrue((boolean)hs.add(rt4));
        Assertions.assertTrue((boolean)hs.add(rt6));
        Assertions.assertTrue((boolean)hc0.add(rt0.hashCode()));
        Assertions.assertTrue((boolean)hc4.add(rt4.hashCode()));
        Assertions.assertTrue((boolean)hc6.add(rt6.hashCode()));
        rt = (RouteTracker)rt0.clone();
        rt.connectTarget(false);
        Assertions.assertTrue((boolean)hs.add(rt));
        Assertions.assertTrue((boolean)hc0.add(rt.hashCode()));
        rt = (RouteTracker)rt0.clone();
        rt.connectTarget(true);
        Assertions.assertTrue((boolean)hs.add(rt));
        Assertions.assertTrue((boolean)hc0.add(rt.hashCode()));
        rt = (RouteTracker)rt4.clone();
        rt.connectProxy(PROXY1, false);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assertions.assertTrue((boolean)hc4.add(rt.hashCode()));
        rt.tunnelTarget(false);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assertions.assertTrue((boolean)hc4.add(rt.hashCode()));
        rt.layerProtocol(true);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assertions.assertTrue((boolean)hc4.add(rt.hashCode()));
        rt = (RouteTracker)rt4.clone();
        rt.connectProxy(PROXY1, true);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assertions.assertTrue((boolean)hc4.add(rt.hashCode()));
        rt.tunnelTarget(true);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assertions.assertTrue((boolean)hc4.add(rt.hashCode()));
        rt.layerProtocol(false);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assertions.assertTrue((boolean)hc4.add(rt.hashCode()));
        rt = (RouteTracker)rt6.clone();
        rt.connectProxy(PROXY1, false);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assertions.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt.tunnelProxy(PROXY2, false);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assertions.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt.tunnelTarget(false);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assertions.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt.layerProtocol(true);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assertions.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt = (RouteTracker)rt6.clone();
        rt.connectProxy(PROXY1, true);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assertions.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt.tunnelProxy(PROXY2, true);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assertions.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt.tunnelTarget(true);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assertions.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt.layerProtocol(false);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assertions.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt = (RouteTracker)rt6.clone();
        rt.connectProxy(PROXY2, false);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assertions.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt.tunnelProxy(PROXY1, false);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        rt.tunnelTarget(false);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        rt.layerProtocol(true);
        Assertions.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        HashSet<String> rtstrings = new HashSet<String>();
        for (RouteTracker current : hs) {
            String rts = TestRouteTracker.checkToString(current);
            Assertions.assertTrue((boolean)rtstrings.add(rts), (String)("duplicate toString: " + rts));
        }
    }

    public static final void checkCTLS(RouteTracker rt, boolean c, boolean t, boolean l, boolean s) {
        String rts = rt.toString();
        Assertions.assertEquals((Object)c, (Object)rt.isConnected(), (String)("wrong flag connected: " + rts));
        Assertions.assertEquals((Object)t, (Object)rt.isTunnelled(), (String)("wrong flag tunnelled: " + rts));
        Assertions.assertEquals((Object)(t ? RouteInfo.TunnelType.TUNNELLED : RouteInfo.TunnelType.PLAIN), (Object)rt.getTunnelType(), (String)("wrong enum tunnelled: " + rts));
        Assertions.assertEquals((Object)l, (Object)rt.isLayered(), (String)("wrong flag layered: " + rts));
        Assertions.assertEquals((Object)(l ? RouteInfo.LayerType.LAYERED : RouteInfo.LayerType.PLAIN), (Object)rt.getLayerType(), (String)("wrong enum layered: " + rts));
        Assertions.assertEquals((Object)s, (Object)rt.isSecure(), (String)("wrong flag secure: " + rts));
    }

    public static final boolean checkVia(RouteTracker rt, HttpRoute r, HttpRouteDirector rd, int steps) {
        String msg = r + " @ " + rt;
        boolean complete = false;
        block8: for (int n = steps; !complete && n > 0; --n) {
            int action = rd.nextStep((RouteInfo)r, (RouteInfo)rt.toRoute());
            switch (action) {
                case 0: {
                    complete = true;
                    Assertions.assertEquals((Object)r, (Object)rt.toRoute());
                    continue block8;
                }
                case 1: {
                    boolean sec = r.isSecure();
                    rt.connectTarget(sec);
                    TestRouteTracker.checkCTLS(rt, true, false, false, sec);
                    Assertions.assertEquals((int)1, (int)rt.getHopCount(), (String)("wrong hop count " + msg));
                    Assertions.assertEquals((Object)r.getTargetHost(), (Object)rt.getHopTarget(0), (String)("wrong hop0 " + msg));
                    continue block8;
                }
                case 2: {
                    boolean sec = false;
                    rt.connectProxy(r.getProxyHost(), false);
                    TestRouteTracker.checkCTLS(rt, true, false, false, false);
                    Assertions.assertEquals((int)2, (int)rt.getHopCount(), (String)("wrong hop count " + msg));
                    Assertions.assertEquals((Object)r.getProxyHost(), (Object)rt.getHopTarget(0), (String)("wrong hop0 " + msg));
                    Assertions.assertEquals((Object)r.getTargetHost(), (Object)rt.getHopTarget(1), (String)("wrong hop1 " + msg));
                    continue block8;
                }
                case 3: {
                    int hops = rt.getHopCount();
                    boolean sec = false;
                    rt.tunnelTarget(false);
                    TestRouteTracker.checkCTLS(rt, true, true, false, false);
                    Assertions.assertEquals((int)hops, (int)rt.getHopCount(), (String)("wrong hop count " + msg));
                    Assertions.assertEquals((Object)r.getProxyHost(), (Object)rt.getHopTarget(0), (String)("wrong hop0 " + msg));
                    Assertions.assertEquals((Object)r.getTargetHost(), (Object)rt.getHopTarget(hops - 1), (String)("wrong hopN " + msg));
                    continue block8;
                }
                case 4: {
                    int hops = rt.getHopCount();
                    boolean sec = false;
                    HttpHost pxy = r.getHopTarget(hops - 1);
                    rt.tunnelProxy(pxy, false);
                    TestRouteTracker.checkCTLS(rt, true, false, false, false);
                    Assertions.assertEquals((int)(hops + 1), (int)rt.getHopCount(), (String)("wrong hop count " + msg));
                    Assertions.assertEquals((Object)r.getProxyHost(), (Object)rt.getHopTarget(0), (String)("wrong hop0 " + msg));
                    Assertions.assertEquals((Object)pxy, (Object)rt.getHopTarget(hops - 1), (String)("wrong hop" + hops + " " + msg));
                    Assertions.assertEquals((Object)r.getTargetHost(), (Object)rt.getHopTarget(hops), (String)("wrong hopN " + msg));
                    continue block8;
                }
                case 5: {
                    int hops = rt.getHopCount();
                    boolean tun = rt.isTunnelled();
                    boolean sec = r.isSecure();
                    rt.layerProtocol(sec);
                    TestRouteTracker.checkCTLS(rt, true, tun, true, sec);
                    Assertions.assertEquals((int)hops, (int)rt.getHopCount(), (String)("wrong hop count " + msg));
                    Assertions.assertEquals((Object)r.getProxyHost(), (Object)rt.getProxyHost(), (String)("wrong proxy " + msg));
                    Assertions.assertEquals((Object)r.getTargetHost(), (Object)rt.getTargetHost(), (String)("wrong target " + msg));
                    continue block8;
                }
                default: {
                    Assertions.fail((String)("unexpected action " + action + " from director, " + msg));
                }
            }
        }
        return complete;
    }

    public static final String checkToString(RouteTracker rt) {
        if (rt == null) {
            return null;
        }
        String rts = rt.toString();
        if (rt.getLocalAddress() != null) {
            String las = rt.getLocalAddress().toString();
            Assertions.assertTrue((boolean)rts.contains(las), (String)("no local address in toString(): " + rts));
        }
        for (int i = 0; i < rt.getHopCount(); ++i) {
            String hts = rt.getHopTarget(i).toString();
            Assertions.assertTrue((boolean)rts.contains(hts), (String)("hop " + i + " (" + hts + ") missing in toString(): " + rts));
        }
        return rts;
    }

    static {
        try {
            LOCAL41 = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            LOCAL42 = InetAddress.getByAddress(new byte[]{127, 0, 0, 2});
            LOCAL61 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
            LOCAL62 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2});
        }
        catch (Exception x) {
            throw new ExceptionInInitializerError(x);
        }
    }
}

