/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.UnsupportedSchemeException;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.io.DefaultHttpClientConnectionOperator;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHttpClientConnectionOperator {
    private ManagedHttpClientConnection conn;
    private Socket socket;
    private ConnectionSocketFactory plainSocketFactory;
    private LayeredConnectionSocketFactory sslSocketFactory;
    private Lookup<ConnectionSocketFactory> socketFactoryRegistry;
    private SchemePortResolver schemePortResolver;
    private DnsResolver dnsResolver;
    private DefaultHttpClientConnectionOperator connectionOperator;

    @BeforeEach
    public void setup() throws Exception {
        this.conn = (ManagedHttpClientConnection)Mockito.mock(ManagedHttpClientConnection.class);
        this.socket = (Socket)Mockito.mock(Socket.class);
        this.plainSocketFactory = (ConnectionSocketFactory)Mockito.mock(ConnectionSocketFactory.class);
        this.sslSocketFactory = (LayeredConnectionSocketFactory)Mockito.mock(LayeredConnectionSocketFactory.class);
        this.socketFactoryRegistry = (Lookup)Mockito.mock(Lookup.class);
        this.schemePortResolver = (SchemePortResolver)Mockito.mock(SchemePortResolver.class);
        this.dnsResolver = (DnsResolver)Mockito.mock(DnsResolver.class);
        this.connectionOperator = new DefaultHttpClientConnectionOperator(this.socketFactoryRegistry, this.schemePortResolver, this.dnsResolver);
    }

    @Test
    public void testConnect() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        HttpHost host = new HttpHost("somehost");
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 0});
        InetAddress ip1 = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        InetAddress ip2 = InetAddress.getByAddress(new byte[]{127, 0, 0, 2});
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{ip1, ip2});
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(host)).thenReturn((Object)80);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket((Socket)Mockito.any(), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (Timeout)Mockito.any(), Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(true).setSoReuseAddress(true).setSoTimeout(5000, TimeUnit.MILLISECONDS).setTcpNoDelay(true).setSoLinger(50, TimeUnit.MILLISECONDS).build();
        TlsConfig tlsConfig = TlsConfig.custom().build();
        InetSocketAddress localAddress = new InetSocketAddress(local, 0);
        this.connectionOperator.connect(this.conn, host, localAddress, Timeout.ofMilliseconds((long)123L), socketConfig, (Object)tlsConfig, (HttpContext)context);
        ((Socket)Mockito.verify((Object)this.socket)).setKeepAlive(true);
        ((Socket)Mockito.verify((Object)this.socket)).setReuseAddress(true);
        ((Socket)Mockito.verify((Object)this.socket)).setSoTimeout(5000);
        ((Socket)Mockito.verify((Object)this.socket)).setSoLinger(true, 50);
        ((Socket)Mockito.verify((Object)this.socket)).setTcpNoDelay(true);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory)).connectSocket(this.socket, host, new InetSocketAddress(ip1, 80), localAddress, Timeout.ofMilliseconds((long)123L), (Object)tlsConfig, (HttpContext)context);
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).bind(this.socket);
    }

    @Test
    public void testConnectTimeout() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        HttpHost host = new HttpHost("somehost");
        InetAddress ip1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress ip2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{ip1, ip2});
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(host)).thenReturn((Object)80);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket((Socket)Mockito.any(), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (Timeout)Mockito.any(), Mockito.any(), (HttpContext)Mockito.any())).thenThrow(new Throwable[]{new SocketTimeoutException()});
        Assertions.assertThrows(ConnectTimeoutException.class, () -> this.lambda$testConnectTimeout$0(host, (HttpContext)context));
    }

    @Test
    public void testConnectFailure() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        HttpHost host = new HttpHost("somehost");
        InetAddress ip1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress ip2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{ip1, ip2});
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(host)).thenReturn((Object)80);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket((Socket)Mockito.any(), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (Timeout)Mockito.any(), Mockito.any(), (HttpContext)Mockito.any())).thenThrow(new Throwable[]{new ConnectException()});
        Assertions.assertThrows(HttpHostConnectException.class, () -> this.lambda$testConnectFailure$1(host, (HttpContext)context));
    }

    @Test
    public void testConnectFailover() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        HttpHost host = new HttpHost("somehost");
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 0});
        InetAddress ip1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress ip2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{ip1, ip2});
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(host)).thenReturn((Object)80);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket((Socket)Mockito.any(), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.eq((Object)new InetSocketAddress(ip1, 80)), (InetSocketAddress)Mockito.any(), (Timeout)Mockito.any(), Mockito.any(), (HttpContext)Mockito.any())).thenThrow(new Throwable[]{new ConnectException()});
        Mockito.when((Object)this.plainSocketFactory.connectSocket((Socket)Mockito.any(), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.eq((Object)new InetSocketAddress(ip2, 80)), (InetSocketAddress)Mockito.any(), (Timeout)Mockito.any(), Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        InetSocketAddress localAddress = new InetSocketAddress(local, 0);
        TlsConfig tlsConfig = TlsConfig.custom().build();
        this.connectionOperator.connect(this.conn, host, localAddress, Timeout.ofMilliseconds((long)123L), SocketConfig.DEFAULT, (Object)tlsConfig, (HttpContext)context);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory)).connectSocket(this.socket, host, new InetSocketAddress(ip2, 80), localAddress, Timeout.ofMilliseconds((long)123L), (Object)tlsConfig, (HttpContext)context);
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)3))).bind(this.socket);
    }

    @Test
    public void testConnectExplicitAddress() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 0});
        InetAddress ip = InetAddress.getByAddress(new byte[]{127, 0, 0, 23});
        HttpHost host = new HttpHost(ip);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(host)).thenReturn((Object)80);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket((Socket)Mockito.any(), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (Timeout)Mockito.any(), Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        InetSocketAddress localAddress = new InetSocketAddress(local, 0);
        TlsConfig tlsConfig = TlsConfig.custom().build();
        this.connectionOperator.connect(this.conn, host, localAddress, Timeout.ofMilliseconds((long)123L), SocketConfig.DEFAULT, (Object)tlsConfig, (HttpContext)context);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory)).connectSocket(this.socket, host, new InetSocketAddress(ip, 80), localAddress, Timeout.ofMilliseconds((long)123L), (Object)tlsConfig, (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.never())).resolve(Mockito.anyString());
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).bind(this.socket);
    }

    @Test
    public void testUpgrade() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        HttpHost host = new HttpHost("https", "somehost", -1);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.conn.getSocket()).thenReturn((Object)this.socket);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("https")).thenReturn((Object)this.sslSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(host)).thenReturn((Object)443);
        Mockito.when((Object)this.sslSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.sslSocketFactory.createLayeredSocket((Socket)Mockito.any(), (String)Mockito.eq((Object)"somehost"), Mockito.eq((int)443), Mockito.eq((Object)Timeout.ofMilliseconds((long)345L)), (HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        this.connectionOperator.upgrade(this.conn, host, (Object)Timeout.ofMilliseconds((long)345L), (HttpContext)context);
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn)).bind(this.socket);
    }

    @Test
    public void testUpgradeUpsupportedScheme() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        HttpHost host = new HttpHost("httpsssss", "somehost", -1);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Assertions.assertThrows(UnsupportedSchemeException.class, () -> this.lambda$testUpgradeUpsupportedScheme$2(host, (HttpContext)context));
    }

    @Test
    public void testUpgradeNonLayeringScheme() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        HttpHost host = new HttpHost("http", "somehost", -1);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Assertions.assertThrows(UnsupportedSchemeException.class, () -> this.lambda$testUpgradeNonLayeringScheme$3(host, (HttpContext)context));
    }

    private /* synthetic */ void lambda$testUpgradeNonLayeringScheme$3(HttpHost host, HttpContext context) throws Throwable {
        this.connectionOperator.upgrade(this.conn, host, context);
    }

    private /* synthetic */ void lambda$testUpgradeUpsupportedScheme$2(HttpHost host, HttpContext context) throws Throwable {
        this.connectionOperator.upgrade(this.conn, host, context);
    }

    private /* synthetic */ void lambda$testConnectFailure$1(HttpHost host, HttpContext context) throws Throwable {
        this.connectionOperator.connect(this.conn, host, null, TimeValue.ofMilliseconds((long)1000L), SocketConfig.DEFAULT, context);
    }

    private /* synthetic */ void lambda$testConnectTimeout$0(HttpHost host, HttpContext context) throws Throwable {
        this.connectionOperator.connect(this.conn, host, null, TimeValue.ofMilliseconds((long)1000L), SocketConfig.DEFAULT, context);
    }
}

