/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieAttributeHandler;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.cookie.SetCookie;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.apache.hc.client5.http.impl.cookie.BasicDomainHandler;
import org.apache.hc.client5.http.impl.cookie.BasicExpiresHandler;
import org.apache.hc.client5.http.impl.cookie.BasicHttpOnlyHandler;
import org.apache.hc.client5.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.hc.client5.http.impl.cookie.BasicPathHandler;
import org.apache.hc.client5.http.impl.cookie.BasicSecureHandler;
import org.apache.hc.client5.http.impl.cookie.PublicSuffixDomainFilter;
import org.apache.hc.client5.http.psl.DomainType;
import org.apache.hc.client5.http.psl.PublicSuffixMatcher;
import org.apache.hc.client5.http.utils.DateUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBasicCookieAttribHandlers {
    @Test
    public void testBasicDomainParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicDomainHandler h = BasicDomainHandler.INSTANCE;
        h.parse((SetCookie)cookie, "www.somedomain.com");
        Assertions.assertEquals((Object)"www.somedomain.com", (Object)cookie.getDomain());
    }

    @Test
    public void testBasicDomainParseInvalid1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicDomainHandler h = BasicDomainHandler.INSTANCE;
        Assertions.assertThrows(MalformedCookieException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicDomainParseInvalid1$0((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testBasicDomainParseInvalid2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicDomainHandler h = BasicDomainHandler.INSTANCE;
        Assertions.assertThrows(MalformedCookieException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicDomainParseInvalid2$1((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testBasicDomainValidate1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("www.somedomain.com", 80, "/", false);
        BasicDomainHandler h = BasicDomainHandler.INSTANCE;
        cookie.setDomain(".somedomain.com");
        h.validate((Cookie)cookie, origin);
        cookie.setDomain(".otherdomain.com");
        Assertions.assertThrows(MalformedCookieException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicDomainValidate1$2((CookieAttributeHandler)h, cookie, origin));
        cookie.setDomain("www.otherdomain.com");
        Assertions.assertThrows(MalformedCookieException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicDomainValidate1$3((CookieAttributeHandler)h, cookie, origin));
    }

    @Test
    public void testBasicDomainValidate2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/", false);
        BasicDomainHandler h = BasicDomainHandler.INSTANCE;
        cookie.setDomain("somehost");
        h.validate((Cookie)cookie, origin);
        cookie.setDomain("otherhost");
        Assertions.assertThrows(MalformedCookieException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicDomainValidate2$4((CookieAttributeHandler)h, cookie, origin));
    }

    @Test
    public void testBasicDomainValidate3() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somedomain.com", 80, "/", false);
        BasicDomainHandler h = BasicDomainHandler.INSTANCE;
        cookie.setDomain(".somedomain.com");
        h.validate((Cookie)cookie, origin);
    }

    @Test
    public void testBasicDomainValidate4() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somedomain.com", 80, "/", false);
        BasicDomainHandler h = BasicDomainHandler.INSTANCE;
        cookie.setDomain(null);
        Assertions.assertThrows(MalformedCookieException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicDomainValidate4$5((CookieAttributeHandler)h, cookie, origin));
    }

    @Test
    public void testBasicDomainMatch1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somedomain.com", 80, "/", false);
        BasicDomainHandler h = BasicDomainHandler.INSTANCE;
        cookie.setDomain("somedomain.com");
        cookie.setAttribute("domain", "somedomain.com");
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, origin));
        cookie.setDomain(".somedomain.com");
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicDomainMatch2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("www.somedomain.com", 80, "/", false);
        BasicDomainHandler h = BasicDomainHandler.INSTANCE;
        cookie.setDomain("somedomain.com");
        cookie.setAttribute("domain", "somedomain.com");
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, origin));
        cookie.setDomain(".somedomain.com");
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, origin));
        cookie.setDomain(null);
        Assertions.assertFalse((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicDomainMatchOneLetterPrefix() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("a.somedomain.com", 80, "/", false);
        BasicDomainHandler h = BasicDomainHandler.INSTANCE;
        cookie.setDomain("somedomain.com");
        cookie.setAttribute("domain", "somedomain.com");
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicDomainMatchMixedCase() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("a.SomeDomain.com", 80, "/", false);
        BasicDomainHandler h = BasicDomainHandler.INSTANCE;
        cookie.setDomain("somedoMain.Com");
        cookie.setAttribute("domain", "somedoMain.Com");
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicDomainInvalidInput() throws Exception {
        BasicDomainHandler h = BasicDomainHandler.INSTANCE;
        Assertions.assertThrows(NullPointerException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicDomainInvalidInput$6((CookieAttributeHandler)h));
        Assertions.assertThrows(NullPointerException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicDomainInvalidInput$7((CookieAttributeHandler)h));
        Assertions.assertThrows(NullPointerException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicDomainInvalidInput$8((CookieAttributeHandler)h));
        Assertions.assertThrows(NullPointerException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicDomainInvalidInput$9((CookieAttributeHandler)h));
        Assertions.assertThrows(NullPointerException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicDomainInvalidInput$10((CookieAttributeHandler)h));
    }

    @Test
    public void testBasicPathParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicPathHandler h = BasicPathHandler.INSTANCE;
        h.parse((SetCookie)cookie, "stuff");
        Assertions.assertEquals((Object)"stuff", (Object)cookie.getPath());
        h.parse((SetCookie)cookie, "");
        Assertions.assertEquals((Object)"/", (Object)cookie.getPath());
        h.parse((SetCookie)cookie, null);
        Assertions.assertEquals((Object)"/", (Object)cookie.getPath());
    }

    @Test
    public void testBasicPathMatch1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/stuff", false);
        BasicPathHandler h = BasicPathHandler.INSTANCE;
        cookie.setPath("/stuff");
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicPathMatch2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/stuff/", false);
        BasicPathHandler h = BasicPathHandler.INSTANCE;
        cookie.setPath("/stuff");
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicPathMatch3() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/stuff/more-stuff", false);
        BasicPathHandler h = BasicPathHandler.INSTANCE;
        cookie.setPath("/stuff");
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicPathMatch4() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/stuffed", false);
        BasicPathHandler h = BasicPathHandler.INSTANCE;
        cookie.setPath("/stuff");
        Assertions.assertFalse((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicPathMatch5() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/otherstuff", false);
        BasicPathHandler h = BasicPathHandler.INSTANCE;
        cookie.setPath("/stuff");
        Assertions.assertFalse((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicPathMatch6() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/stuff", false);
        BasicPathHandler h = BasicPathHandler.INSTANCE;
        cookie.setPath("/stuff/");
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicPathMatch7() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/stuff", false);
        BasicPathHandler h = BasicPathHandler.INSTANCE;
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicPathInvalidInput() throws Exception {
        BasicPathHandler h = BasicPathHandler.INSTANCE;
        Assertions.assertThrows(NullPointerException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicPathInvalidInput$11((CookieAttributeHandler)h));
        Assertions.assertThrows(NullPointerException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicPathInvalidInput$12((CookieAttributeHandler)h));
        Assertions.assertThrows(NullPointerException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicPathInvalidInput$13((CookieAttributeHandler)h));
    }

    @Test
    public void testBasicMaxAgeParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicMaxAgeHandler h = BasicMaxAgeHandler.INSTANCE;
        h.parse((SetCookie)cookie, "2000");
        Assertions.assertNotNull((Object)cookie.getExpiryInstant());
    }

    @Test
    public void testBasicMaxAgeParseInvalid() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicMaxAgeHandler h = BasicMaxAgeHandler.INSTANCE;
        Assertions.assertThrows(MalformedCookieException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicMaxAgeParseInvalid$14((CookieAttributeHandler)h, cookie));
        Assertions.assertThrows(MalformedCookieException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicMaxAgeParseInvalid$15((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testBasicMaxAgeInvalidInput() throws Exception {
        BasicMaxAgeHandler h = BasicMaxAgeHandler.INSTANCE;
        Assertions.assertThrows(NullPointerException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicMaxAgeInvalidInput$16((CookieAttributeHandler)h));
    }

    @Test
    public void testBasicSecureParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicSecureHandler h = BasicSecureHandler.INSTANCE;
        h.parse((SetCookie)cookie, "whatever");
        Assertions.assertTrue((boolean)cookie.isSecure());
        h.parse((SetCookie)cookie, null);
        Assertions.assertTrue((boolean)cookie.isSecure());
    }

    @Test
    public void testBasicSecureMatch() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicSecureHandler h = BasicSecureHandler.INSTANCE;
        CookieOrigin origin1 = new CookieOrigin("somehost", 80, "/stuff", false);
        cookie.setSecure(false);
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, origin1));
        cookie.setSecure(true);
        Assertions.assertFalse((boolean)h.match((Cookie)cookie, origin1));
        CookieOrigin origin2 = new CookieOrigin("somehost", 80, "/stuff", true);
        cookie.setSecure(false);
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, origin2));
        cookie.setSecure(true);
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, origin2));
    }

    @Test
    public void testBasicSecureInvalidInput() throws Exception {
        BasicSecureHandler h = new BasicSecureHandler();
        Assertions.assertThrows(NullPointerException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicSecureInvalidInput$17((CookieAttributeHandler)h));
        Assertions.assertThrows(NullPointerException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicSecureInvalidInput$18((CookieAttributeHandler)h));
        Assertions.assertThrows(NullPointerException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicSecureInvalidInput$19((CookieAttributeHandler)h));
    }

    @Test
    public void testBasicExpiresParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicExpiresHandler h = new BasicExpiresHandler(new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1123});
        h.parse((SetCookie)cookie, DateUtils.formatStandardDate((Instant)Instant.now()));
        Assertions.assertNotNull((Object)cookie.getExpiryInstant());
    }

    @Test
    public void testBasicExpiresParseInvalid() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicExpiresHandler h = new BasicExpiresHandler(new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1123});
        Assertions.assertThrows(MalformedCookieException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicExpiresParseInvalid$20((CookieAttributeHandler)h, cookie));
        Assertions.assertThrows(MalformedCookieException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicExpiresParseInvalid$21((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testBasicExpiresInvalidInput() throws Exception {
        BasicExpiresHandler h = new BasicExpiresHandler(new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1123});
        Assertions.assertThrows(NullPointerException.class, () -> TestBasicCookieAttribHandlers.lambda$testBasicExpiresInvalidInput$22((CookieAttributeHandler)h));
    }

    @Test
    public void testPublicSuffixFilter() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        PublicSuffixMatcher matcher = new PublicSuffixMatcher(DomainType.ICANN, Arrays.asList("co.uk", "com"), null);
        PublicSuffixDomainFilter h = new PublicSuffixDomainFilter((CommonCookieAttributeHandler)BasicDomainHandler.INSTANCE, matcher);
        cookie.setDomain(".co.uk");
        cookie.setAttribute("domain", ".co.uk");
        Assertions.assertFalse((boolean)h.match((Cookie)cookie, new CookieOrigin("apache.co.uk", 80, "/stuff", false)));
        cookie.setDomain("co.uk");
        cookie.setAttribute("domain", "co.uk");
        Assertions.assertFalse((boolean)h.match((Cookie)cookie, new CookieOrigin("apache.co.uk", 80, "/stuff", false)));
        cookie.setDomain(".co.com");
        cookie.setAttribute("domain", ".co.com");
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, new CookieOrigin("apache.co.com", 80, "/stuff", false)));
        cookie.setDomain("co.com");
        cookie.setAttribute("domain", "co.com");
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, new CookieOrigin("apache.co.com", 80, "/stuff", false)));
        cookie.setDomain(".com");
        cookie.setAttribute("domain", ".com");
        Assertions.assertFalse((boolean)h.match((Cookie)cookie, new CookieOrigin("apache.com", 80, "/stuff", false)));
        cookie.setDomain("com");
        cookie.setAttribute("domain", "com");
        Assertions.assertFalse((boolean)h.match((Cookie)cookie, new CookieOrigin("apache.com", 80, "/stuff", false)));
        cookie.setDomain("apache.com");
        cookie.setAttribute("domain", "apache.com");
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, new CookieOrigin("apache.com", 80, "/stuff", false)));
        cookie.setDomain(".apache.com");
        cookie.setAttribute("domain", ".apache.com");
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, new CookieOrigin("www.apache.com", 80, "/stuff", false)));
        cookie.setDomain("localhost");
        cookie.setAttribute("domain", "localhost");
        Assertions.assertTrue((boolean)h.match((Cookie)cookie, new CookieOrigin("localhost", 80, "/stuff", false)));
    }

    @Test
    public void testBasicHttpOnlyParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicHttpOnlyHandler h = new BasicHttpOnlyHandler();
        h.parse((SetCookie)cookie, "true");
        Assertions.assertTrue((boolean)cookie.isHttpOnly());
        h.parse((SetCookie)cookie, "anyone");
        Assertions.assertTrue((boolean)cookie.isHttpOnly());
    }

    private static /* synthetic */ void lambda$testBasicExpiresInvalidInput$22(CookieAttributeHandler h) throws Throwable {
        h.parse(null, null);
    }

    private static /* synthetic */ void lambda$testBasicExpiresParseInvalid$21(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, null);
    }

    private static /* synthetic */ void lambda$testBasicExpiresParseInvalid$20(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, "garbage");
    }

    private static /* synthetic */ void lambda$testBasicSecureInvalidInput$19(CookieAttributeHandler h) throws Throwable {
        h.match((Cookie)new BasicClientCookie("name", "value"), null);
    }

    private static /* synthetic */ void lambda$testBasicSecureInvalidInput$18(CookieAttributeHandler h) throws Throwable {
        h.match(null, null);
    }

    private static /* synthetic */ void lambda$testBasicSecureInvalidInput$17(CookieAttributeHandler h) throws Throwable {
        h.parse(null, null);
    }

    private static /* synthetic */ void lambda$testBasicMaxAgeInvalidInput$16(CookieAttributeHandler h) throws Throwable {
        h.parse(null, null);
    }

    private static /* synthetic */ void lambda$testBasicMaxAgeParseInvalid$15(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, null);
    }

    private static /* synthetic */ void lambda$testBasicMaxAgeParseInvalid$14(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, "garbage");
    }

    private static /* synthetic */ void lambda$testBasicPathInvalidInput$13(CookieAttributeHandler h) throws Throwable {
        h.match((Cookie)new BasicClientCookie("name", "value"), null);
    }

    private static /* synthetic */ void lambda$testBasicPathInvalidInput$12(CookieAttributeHandler h) throws Throwable {
        h.match(null, null);
    }

    private static /* synthetic */ void lambda$testBasicPathInvalidInput$11(CookieAttributeHandler h) throws Throwable {
        h.parse(null, null);
    }

    private static /* synthetic */ void lambda$testBasicDomainInvalidInput$10(CookieAttributeHandler h) throws Throwable {
        h.match((Cookie)new BasicClientCookie("name", "value"), null);
    }

    private static /* synthetic */ void lambda$testBasicDomainInvalidInput$9(CookieAttributeHandler h) throws Throwable {
        h.match(null, null);
    }

    private static /* synthetic */ void lambda$testBasicDomainInvalidInput$8(CookieAttributeHandler h) throws Throwable {
        h.validate((Cookie)new BasicClientCookie("name", "value"), null);
    }

    private static /* synthetic */ void lambda$testBasicDomainInvalidInput$7(CookieAttributeHandler h) throws Throwable {
        h.validate(null, null);
    }

    private static /* synthetic */ void lambda$testBasicDomainInvalidInput$6(CookieAttributeHandler h) throws Throwable {
        h.parse(null, null);
    }

    private static /* synthetic */ void lambda$testBasicDomainValidate4$5(CookieAttributeHandler h, BasicClientCookie cookie, CookieOrigin origin) throws Throwable {
        h.validate((Cookie)cookie, origin);
    }

    private static /* synthetic */ void lambda$testBasicDomainValidate2$4(CookieAttributeHandler h, BasicClientCookie cookie, CookieOrigin origin) throws Throwable {
        h.validate((Cookie)cookie, origin);
    }

    private static /* synthetic */ void lambda$testBasicDomainValidate1$3(CookieAttributeHandler h, BasicClientCookie cookie, CookieOrigin origin) throws Throwable {
        h.validate((Cookie)cookie, origin);
    }

    private static /* synthetic */ void lambda$testBasicDomainValidate1$2(CookieAttributeHandler h, BasicClientCookie cookie, CookieOrigin origin) throws Throwable {
        h.validate((Cookie)cookie, origin);
    }

    private static /* synthetic */ void lambda$testBasicDomainParseInvalid2$1(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, null);
    }

    private static /* synthetic */ void lambda$testBasicDomainParseInvalid1$0(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, "");
    }
}

