/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.auth.CredentialsProviderBuilder;
import org.apache.hc.client5.http.impl.auth.NTLMScheme;
import org.apache.hc.client5.http.impl.classic.ProtocolExec;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

public class TestProtocolExec {
    @Mock
    private AuthenticationStrategy targetAuthStrategy;
    @Mock
    private AuthenticationStrategy proxyAuthStrategy;
    @Mock
    private ExecChain chain;
    @Mock
    private ExecRuntime execRuntime;
    private ProtocolExec protocolExec;
    private HttpHost target;
    private HttpHost proxy;

    @BeforeEach
    public void setup() throws Exception {
        MockitoAnnotations.openMocks((Object)this);
        this.protocolExec = new ProtocolExec(this.targetAuthStrategy, this.proxyAuthStrategy, null, true);
        this.target = new HttpHost("foo", 80);
        this.proxy = new HttpHost("bar", 8888);
    }

    @Test
    public void testUserInfoInRequestURI() throws Exception {
        HttpRoute route = new HttpRoute(new HttpHost("somehost", 8080));
        HttpGet request = new HttpGet("http://somefella:secret@bar/test");
        HttpClientContext context = HttpClientContext.create();
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testUserInfoInRequestURI$0((ClassicHttpRequest)request, scope));
    }

    @Test
    public void testPostProcessHttpException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response);
        ((ExecChain)Mockito.doThrow((Throwable[])new Throwable[]{new HttpException("Ooopsie")}).when((Object)this.chain)).proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any());
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        Assertions.assertThrows(HttpException.class, () -> this.lambda$testPostProcessHttpException$1((ClassicHttpRequest)request, scope));
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).discardEndpoint();
    }

    @Test
    public void testPostProcessIOException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response);
        ((ExecChain)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Ooopsie")}).when((Object)this.chain)).proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any());
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        Assertions.assertThrows(IOException.class, () -> this.lambda$testPostProcessIOException$2((ClassicHttpRequest)request, scope));
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).discardEndpoint();
    }

    @Test
    public void testPostProcessRuntimeException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response);
        ((ExecChain)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Ooopsie")}).when((Object)this.chain)).proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any());
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        Assertions.assertThrows(RuntimeException.class, () -> this.lambda$testPostProcessRuntimeException$3((ClassicHttpRequest)request, scope));
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).discardEndpoint();
    }

    @Test
    public void testExecRequestRetryOnAuthChallenge() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://foo/test");
        BasicClassicHttpResponse response1 = new BasicClassicHttpResponse(401, "Huh?");
        response1.setHeader("WWW-Authenticate", (Object)"Basic realm=test");
        InputStream inStream1 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        response1.setEntity(EntityBuilder.create().setStream(inStream1).build());
        BasicClassicHttpResponse response2 = new BasicClassicHttpResponse(200, "OK");
        InputStream inStream2 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{2, 3, 4}));
        response2.setEntity(EntityBuilder.create().setStream(inStream2).build());
        context.setCredentialsProvider(CredentialsProviderBuilder.create().add(new AuthScope(this.target), "user", "pass".toCharArray()).build());
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.same((Object)request), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response1, (Object[])new ClassicHttpResponse[]{response2});
        Mockito.when((Object)this.targetAuthStrategy.select((ChallengeType)Mockito.eq((Object)ChallengeType.TARGET), (Map)Mockito.any(), (HttpContext)Mockito.any())).thenReturn(Collections.singletonList(new BasicScheme()));
        Mockito.when((Object)this.execRuntime.isConnectionReusable()).thenReturn((Object)true);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        ClassicHttpResponse finalResponse = this.protocolExec.execute((ClassicHttpRequest)request, scope, this.chain);
        ((ExecChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)2))).proceed((ClassicHttpRequest)request, scope);
        ((InputStream)Mockito.verify((Object)inStream1)).close();
        ((InputStream)Mockito.verify((Object)inStream2, (VerificationMode)Mockito.never())).close();
        Assertions.assertNotNull((Object)finalResponse);
        Assertions.assertEquals((int)200, (int)finalResponse.getCode());
    }

    @Test
    public void testExecEntityEnclosingRequestRetryOnAuthChallenge() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("http://foo/test");
        BasicClassicHttpResponse response1 = new BasicClassicHttpResponse(401, "Huh?");
        response1.setHeader("WWW-Authenticate", (Object)"Basic realm=test");
        InputStream inStream1 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        response1.setEntity(EntityBuilder.create().setStream(inStream1).build());
        BasicClassicHttpResponse response2 = new BasicClassicHttpResponse(200, "OK");
        InputStream inStream2 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{2, 3, 4}));
        response2.setEntity(EntityBuilder.create().setStream(inStream2).build());
        HttpClientContext context = new HttpClientContext();
        AuthExchange authExchange = new AuthExchange();
        authExchange.setState(AuthExchange.State.SUCCESS);
        authExchange.select((AuthScheme)new NTLMScheme());
        context.setAuthExchange(this.target, authExchange);
        context.setCredentialsProvider(CredentialsProviderBuilder.create().add(new AuthScope(this.target), "user", "pass".toCharArray()).build());
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.same((Object)request), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response1, (Object[])new ClassicHttpResponse[]{response2});
        Mockito.when((Object)this.targetAuthStrategy.select((ChallengeType)Mockito.eq((Object)ChallengeType.TARGET), (Map)Mockito.any(), (HttpContext)Mockito.any())).thenReturn(Collections.singletonList(new BasicScheme()));
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        ClassicHttpResponse finalResponse = this.protocolExec.execute((ClassicHttpRequest)request, scope, this.chain);
        ((ExecChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)2))).proceed((ClassicHttpRequest)request, scope);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).disconnectEndpoint();
        ((InputStream)Mockito.verify((Object)inStream2, (VerificationMode)Mockito.never())).close();
        Assertions.assertNotNull((Object)finalResponse);
        Assertions.assertEquals((int)200, (int)finalResponse.getCode());
        Assertions.assertNotNull((Object)authExchange.getAuthScheme());
    }

    @Test
    public void testExecEntityEnclosingRequest() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpPost request = new HttpPost("http://foo/test");
        ByteArrayInputStream inStream0 = new ByteArrayInputStream(new byte[]{1, 2, 3});
        request.setEntity(EntityBuilder.create().setStream((InputStream)inStream0).build());
        BasicClassicHttpResponse response1 = new BasicClassicHttpResponse(401, "Huh?");
        response1.setHeader("WWW-Authenticate", (Object)"Basic realm=test");
        ByteArrayInputStream inStream1 = new ByteArrayInputStream(new byte[]{1, 2, 3});
        response1.setEntity(EntityBuilder.create().setStream((InputStream)inStream1).build());
        context.setCredentialsProvider(CredentialsProviderBuilder.create().add(new AuthScope(this.target), "user", "pass".toCharArray()).build());
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.same((Object)request), (ExecChain.Scope)Mockito.any())).thenAnswer(arg_0 -> TestProtocolExec.lambda$testExecEntityEnclosingRequest$4((ClassicHttpResponse)response1, arg_0));
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        ClassicHttpResponse response = this.protocolExec.execute((ClassicHttpRequest)request, scope, this.chain);
        Assertions.assertEquals((int)401, (int)response.getCode());
    }

    private static /* synthetic */ HttpResponse lambda$testExecEntityEnclosingRequest$4(ClassicHttpResponse response1, InvocationOnMock invocationOnMock) throws Throwable {
        Object[] args = invocationOnMock.getArguments();
        ClassicHttpRequest requestEE = (ClassicHttpRequest)args[0];
        requestEE.getEntity().writeTo((OutputStream)new ByteArrayOutputStream());
        return response1;
    }

    private /* synthetic */ void lambda$testPostProcessRuntimeException$3(ClassicHttpRequest request, ExecChain.Scope scope) throws Throwable {
        this.protocolExec.execute(request, scope, this.chain);
    }

    private /* synthetic */ void lambda$testPostProcessIOException$2(ClassicHttpRequest request, ExecChain.Scope scope) throws Throwable {
        this.protocolExec.execute(request, scope, this.chain);
    }

    private /* synthetic */ void lambda$testPostProcessHttpException$1(ClassicHttpRequest request, ExecChain.Scope scope) throws Throwable {
        this.protocolExec.execute(request, scope, this.chain);
    }

    private /* synthetic */ void lambda$testUserInfoInRequestURI$0(ClassicHttpRequest request, ExecChain.Scope scope) throws Throwable {
        this.protocolExec.execute(request, scope, this.chain);
    }
}

