/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.AuthChallengeParser;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.auth.CredentialsProviderBuilder;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBasicScheme {
    private static final Base64.Encoder BASE64_ENC = Base64.getEncoder();
    static final String TEST_UTF8_PASSWORD = "123\u00a3";

    private static AuthChallenge parse(String s) throws ParseException {
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(s);
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List authChallenges = AuthChallengeParser.INSTANCE.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assertions.assertEquals((int)1, (int)authChallenges.size());
        return (AuthChallenge)authChallenges.get(0);
    }

    @Test
    public void testBasicAuthenticationEmptyChallenge() throws Exception {
        String challenge = "Basic";
        AuthChallenge authChallenge = TestBasicScheme.parse("Basic");
        BasicScheme authscheme = new BasicScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertNull((Object)authscheme.getRealm());
    }

    @Test
    public void testBasicAuthentication() throws Exception {
        AuthChallenge authChallenge = TestBasicScheme.parse("Basic realm=\"test\"");
        BasicScheme authscheme = new BasicScheme();
        authscheme.processChallenge(authChallenge, null);
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "test", null), "testuser", "testpass".toCharArray()).build();
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        byte[] testCreds = "testuser:testpass".getBytes(StandardCharsets.US_ASCII);
        String expected = "Basic " + BASE64_ENC.encodeToString(testCreds);
        Assertions.assertEquals((Object)expected, (Object)authResponse);
        Assertions.assertEquals((Object)"test", (Object)authscheme.getRealm());
        Assertions.assertTrue((boolean)authscheme.isChallengeComplete());
        Assertions.assertFalse((boolean)authscheme.isConnectionBased());
    }

    @Test
    public void testBasicAuthenticationDefaultCharsetASCII() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("test", TEST_UTF8_PASSWORD.toCharArray());
        BasicScheme authscheme = new BasicScheme(StandardCharsets.US_ASCII);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        authscheme.initPreemptive((Credentials)creds);
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Assertions.assertEquals((Object)"Basic dGVzdDoxMjM/", (Object)authResponse);
    }

    @Test
    public void testBasicAuthenticationDefaultCharsetISO88591() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("test", TEST_UTF8_PASSWORD.toCharArray());
        BasicScheme authscheme = new BasicScheme(StandardCharsets.ISO_8859_1);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        authscheme.initPreemptive((Credentials)creds);
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Assertions.assertEquals((Object)"Basic dGVzdDoxMjOj", (Object)authResponse);
    }

    @Test
    public void testBasicAuthenticationDefaultCharsetUTF8() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("test", TEST_UTF8_PASSWORD.toCharArray());
        BasicScheme authscheme = new BasicScheme(StandardCharsets.UTF_8);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        authscheme.initPreemptive((Credentials)creds);
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Assertions.assertEquals((Object)"Basic dGVzdDoxMjPCow==", (Object)authResponse);
    }

    @Test
    public void testBasicAuthenticationWithCharset() throws Exception {
        AuthChallenge authChallenge = TestBasicScheme.parse("Basic realm=\"test\", charset=\"utf-8\"");
        BasicScheme authscheme = new BasicScheme();
        authscheme.processChallenge(authChallenge, null);
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "test", null), "test", TEST_UTF8_PASSWORD.toCharArray()).build();
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Assertions.assertEquals((Object)"Basic dGVzdDoxMjPCow==", (Object)authResponse);
        Assertions.assertEquals((Object)"test", (Object)authscheme.getRealm());
        Assertions.assertTrue((boolean)authscheme.isChallengeComplete());
        Assertions.assertFalse((boolean)authscheme.isConnectionBased());
    }

    @Test
    public void testSerialization() throws Exception {
        AuthChallenge authChallenge = TestBasicScheme.parse("Basic realm=\"test\"");
        BasicScheme basicScheme = new BasicScheme();
        basicScheme.processChallenge(authChallenge, null);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(basicScheme);
        out.flush();
        byte[] raw = buffer.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(raw));
        BasicScheme authScheme = (BasicScheme)in.readObject();
        Assertions.assertEquals((Object)basicScheme.getName(), (Object)authScheme.getName());
        Assertions.assertEquals((Object)basicScheme.getRealm(), (Object)authScheme.getRealm());
        Assertions.assertEquals((Object)basicScheme.isChallengeComplete(), (Object)authScheme.isChallengeComplete());
    }

    @Test
    public void testSerializationUnchallenged() throws Exception {
        BasicScheme basicScheme = new BasicScheme();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(basicScheme);
        out.flush();
        byte[] raw = buffer.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(raw));
        BasicScheme authScheme = (BasicScheme)in.readObject();
        Assertions.assertEquals((Object)basicScheme.getName(), (Object)authScheme.getName());
        Assertions.assertEquals((Object)basicScheme.getRealm(), (Object)authScheme.getRealm());
        Assertions.assertEquals((Object)basicScheme.isChallengeComplete(), (Object)authScheme.isChallengeComplete());
    }

    @Test
    public void testBasicAuthenticationUserCredentialsMissing() throws Exception {
        BasicScheme authscheme = new BasicScheme();
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        Assertions.assertThrows(AuthenticationException.class, () -> TestBasicScheme.lambda$testBasicAuthenticationUserCredentialsMissing$0(authscheme, host, (HttpRequest)request));
    }

    @Test
    public void testBasicAuthenticationUsernameWithBlank() throws Exception {
        BasicScheme authscheme = new BasicScheme();
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        authscheme.initPreemptive((Credentials)new UsernamePasswordCredentials("blah blah", null));
        authscheme.generateAuthResponse(host, (HttpRequest)request, null);
    }

    @Test
    public void testBasicAuthenticationUsernameWithTab() throws Exception {
        BasicScheme authscheme = new BasicScheme();
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        authscheme.initPreemptive((Credentials)new UsernamePasswordCredentials("blah\tblah", null));
        Assertions.assertThrows(AuthenticationException.class, () -> TestBasicScheme.lambda$testBasicAuthenticationUsernameWithTab$1(authscheme, host, (HttpRequest)request));
    }

    @Test
    public void testBasicAuthenticationUsernameWithColon() throws Exception {
        BasicScheme authscheme = new BasicScheme();
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        authscheme.initPreemptive((Credentials)new UsernamePasswordCredentials("blah:blah", null));
        Assertions.assertThrows(AuthenticationException.class, () -> TestBasicScheme.lambda$testBasicAuthenticationUsernameWithColon$2(authscheme, host, (HttpRequest)request));
    }

    private static /* synthetic */ void lambda$testBasicAuthenticationUsernameWithColon$2(BasicScheme authscheme, HttpHost host, HttpRequest request) throws Throwable {
        authscheme.generateAuthResponse(host, request, null);
    }

    private static /* synthetic */ void lambda$testBasicAuthenticationUsernameWithTab$1(BasicScheme authscheme, HttpHost host, HttpRequest request) throws Throwable {
        authscheme.generateAuthResponse(host, request, null);
    }

    private static /* synthetic */ void lambda$testBasicAuthenticationUserCredentialsMissing$0(BasicScheme authscheme, HttpHost host, HttpRequest request) throws Throwable {
        authscheme.generateAuthResponse(host, request, null);
    }
}

