/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;

public class ClientMultiThreadedExecution {
    public static void main(String[] args) throws Exception {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(100);
        try (CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();){
            String[] urisToGet = new String[]{"http://hc.apache.org/", "http://hc.apache.org/httpcomponents-core-ga/", "http://hc.apache.org/httpcomponents-client-ga/"};
            GetThread[] threads = new GetThread[urisToGet.length];
            for (int i = 0; i < threads.length; ++i) {
                HttpGet httpget = new HttpGet(urisToGet[i]);
                threads[i] = new GetThread(httpclient, httpget, i + 1);
            }
            for (GetThread thread : threads) {
                thread.start();
            }
            for (GetThread thread : threads) {
                thread.join();
            }
        }
    }

    static class GetThread
    extends Thread {
        private final CloseableHttpClient httpClient;
        private final HttpContext context;
        private final HttpGet httpget;
        private final int id;

        public GetThread(CloseableHttpClient httpClient, HttpGet httpget, int id) {
            this.httpClient = httpClient;
            this.context = new BasicHttpContext();
            this.httpget = httpget;
            this.id = id;
        }

        @Override
        public void run() {
            try {
                System.out.println(this.id + " - about to get something from " + this.httpget.getUri());
                this.httpClient.execute((ClassicHttpRequest)this.httpget, response -> {
                    System.out.println(this.id + " - get executed");
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
                        System.out.println(this.id + " - " + bytes.length + " bytes read");
                    }
                    return null;
                });
            }
            catch (Exception e) {
                System.out.println(this.id + " - error: " + e);
            }
        }
    }
}

