/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.entity.GzipCompressingEntity;
import org.apache.hc.client5.http.entity.GzipDecompressingEntity;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestGZip {
    @Test
    public void testBasic() throws Exception {
        String s = "some kind of text";
        StringEntity e = new StringEntity("some kind of text", ContentType.TEXT_PLAIN, false);
        try (GzipCompressingEntity gzipe = new GzipCompressingEntity((HttpEntity)e);){
            Assertions.assertTrue((boolean)gzipe.isChunked());
            Assertions.assertEquals((long)-1L, (long)gzipe.getContentLength());
            Assertions.assertNotNull((Object)gzipe.getContentEncoding());
            Assertions.assertEquals((Object)"gzip", (Object)gzipe.getContentEncoding());
        }
    }

    @Test
    public void testCompressionDecompression() throws Exception {
        StringEntity in = new StringEntity("some kind of text", ContentType.TEXT_PLAIN);
        try (GzipCompressingEntity gzipe = new GzipCompressingEntity((HttpEntity)in);){
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            gzipe.writeTo((OutputStream)buf);
            ByteArrayEntity out = new ByteArrayEntity(buf.toByteArray(), ContentType.APPLICATION_OCTET_STREAM);
            GzipDecompressingEntity gunzipe = new GzipDecompressingEntity((HttpEntity)out);
            Assertions.assertEquals((Object)"some kind of text", (Object)EntityUtils.toString((HttpEntity)gunzipe, (Charset)StandardCharsets.US_ASCII));
        }
    }

    @Test
    public void testCompressionIOExceptionLeavesOutputStreamOpen() throws Exception {
        HttpEntity in = (HttpEntity)Mockito.mock(HttpEntity.class);
        ((HttpEntity)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Ooopsie")}).when((Object)in)).writeTo((OutputStream)ArgumentMatchers.any());
        try (GzipCompressingEntity gzipe = new GzipCompressingEntity(in);){
            OutputStream out = (OutputStream)Mockito.mock(OutputStream.class);
            try {
                gzipe.writeTo(out);
            }
            catch (IOException ex) {
                ((OutputStream)Mockito.verify((Object)out, (VerificationMode)Mockito.never())).close();
            }
        }
    }

    @Test
    public void testDecompressionWithMultipleGZipStream() throws Exception {
        int[] data = new int[]{31, 139, 8, 8, 3, 241, 85, 90, 0, 3, 116, 101, 115, 116, 49, 0, 43, 46, 41, 74, 77, 204, 213, 53, 228, 2, 0, 3, 97, 240, 95, 9, 0, 0, 0, 31, 139, 8, 8, 8, 241, 85, 90, 0, 3, 116, 101, 115, 116, 50, 0, 43, 46, 41, 74, 77, 204, 213, 53, 226, 2, 0, 192, 50, 221, 116, 9, 0, 0, 0};
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            bytes[i] = (byte)(data[i] & 0xFF);
        }
        try (GzipDecompressingEntity entity = new GzipDecompressingEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(bytes), ContentType.APPLICATION_OCTET_STREAM));){
            Assertions.assertEquals((Object)"stream-1\nstream-2\n", (Object)EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.US_ASCII));
        }
    }
}

