/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.cookie;

import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCookieOrigin {
    @Test
    public void testConstructor() {
        CookieOrigin origin = new CookieOrigin("www.apache.org", 80, "/", false);
        Assertions.assertEquals((Object)"www.apache.org", (Object)origin.getHost());
        Assertions.assertEquals((int)80, (int)origin.getPort());
        Assertions.assertEquals((Object)"/", (Object)origin.getPath());
        Assertions.assertFalse((boolean)origin.isSecure());
    }

    @Test
    public void testNullHost() {
        Assertions.assertThrows(NullPointerException.class, () -> new CookieOrigin(null, 80, "/", false));
    }

    @Test
    public void testEmptyHost() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CookieOrigin("   ", 80, "/", false));
    }

    @Test
    public void testNegativePort() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CookieOrigin("www.apache.org", -80, "/", false));
    }

    @Test
    public void testNullPath() {
        Assertions.assertThrows(NullPointerException.class, () -> new CookieOrigin("www.apache.org", 80, null, false));
    }

    @Test
    public void testEmptyPath() {
        CookieOrigin origin = new CookieOrigin("www.apache.org", 80, "", false);
        Assertions.assertEquals((Object)"www.apache.org", (Object)origin.getHost());
        Assertions.assertEquals((int)80, (int)origin.getPort());
        Assertions.assertEquals((Object)"/", (Object)origin.getPath());
        Assertions.assertFalse((boolean)origin.isSecure());
    }
}

