/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.auth;

import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.core5.http.HttpHost;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAuthScope {
    @Test
    public void testBasics() {
        AuthScope authscope = new AuthScope("http", "somehost", 80, "somerealm", "SomeScheme");
        Assertions.assertEquals((Object)"SomeScheme", (Object)authscope.getSchemeName());
        Assertions.assertEquals((Object)"http", (Object)authscope.getProtocol());
        Assertions.assertEquals((Object)"somehost", (Object)authscope.getHost());
        Assertions.assertEquals((int)80, (int)authscope.getPort());
        Assertions.assertEquals((Object)"somerealm", (Object)authscope.getRealm());
        Assertions.assertEquals((Object)"SomeScheme 'somerealm' http://somehost:80", (Object)authscope.toString());
    }

    @Test
    public void testByOrigin() {
        HttpHost host = new HttpHost("http", "somehost", 8080);
        AuthScope authscope = new AuthScope(host);
        Assertions.assertNull((Object)authscope.getSchemeName());
        Assertions.assertEquals((Object)"somehost", (Object)authscope.getHost());
        Assertions.assertEquals((int)8080, (int)authscope.getPort());
        Assertions.assertNull((Object)authscope.getRealm());
        Assertions.assertEquals((Object)"http", (Object)authscope.getProtocol());
        Assertions.assertEquals((Object)"<any auth scheme> <any realm> http://somehost:8080", (Object)authscope.toString());
    }

    @Test
    public void testMixedCaseHostname() {
        AuthScope authscope = new AuthScope("SomeHost", 80);
        Assertions.assertNull((Object)authscope.getSchemeName());
        Assertions.assertEquals((Object)"somehost", (Object)authscope.getHost());
        Assertions.assertEquals((int)80, (int)authscope.getPort());
        Assertions.assertNull((Object)authscope.getRealm());
        Assertions.assertEquals((Object)"<any auth scheme> <any realm> <any protocol>://somehost:80", (Object)authscope.toString());
    }

    @Test
    public void testByOriginMixedCaseHostname() throws Exception {
        HttpHost host = new HttpHost("http", "SomeHost", 8080);
        AuthScope authscope = new AuthScope(host);
        Assertions.assertEquals((Object)"somehost", (Object)authscope.getHost());
    }

    @Test
    public void testBasicsAllOptional() {
        AuthScope authscope = new AuthScope(null, null, -1, null, null);
        Assertions.assertNull((Object)authscope.getSchemeName());
        Assertions.assertNull((Object)authscope.getHost());
        Assertions.assertEquals((int)-1, (int)authscope.getPort());
        Assertions.assertNull((Object)authscope.getRealm());
        Assertions.assertEquals((Object)"<any auth scheme> <any realm> <any protocol>://<any host>:<any port>", (Object)authscope.toString());
    }

    @Test
    public void testScopeMatching() {
        AuthScope authscope1 = new AuthScope("http", "somehost", 80, "somerealm", "somescheme");
        AuthScope authscope2 = new AuthScope("http", "someotherhost", 80, "somerealm", "somescheme");
        Assertions.assertTrue((authscope1.match(authscope2) < 0 ? 1 : 0) != 0);
        int m1 = authscope1.match(new AuthScope(null, null, -1, null, "somescheme"));
        int m2 = authscope1.match(new AuthScope(null, null, -1, "somerealm", null));
        Assertions.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(null, null, -1, null, "somescheme"));
        m2 = authscope1.match(new AuthScope(null, null, -1, "somerealm", null));
        Assertions.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(null, null, -1, "somerealm", "somescheme"));
        m2 = authscope1.match(new AuthScope(null, null, 80, null, null));
        Assertions.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(null, null, 80, "somerealm", "somescheme"));
        m2 = authscope1.match(new AuthScope(null, "somehost", -1, null, null));
        Assertions.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(null, null, 80, "somerealm", "somescheme"));
        m2 = authscope1.match(new AuthScope(null, "somehost", -1, null, null));
        Assertions.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(null, null, -1, null, null));
        m2 = authscope1.match(new AuthScope(null, null, -1, null, "somescheme"));
        Assertions.assertTrue((m2 > m1 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        AuthScope authscope1 = new AuthScope("http", "somehost", 80, "somerealm", "somescheme");
        AuthScope authscope2 = new AuthScope("http", "someotherhost", 80, "somerealm", "somescheme");
        AuthScope authscope3 = new AuthScope("http", "somehost", 80, "somerealm", "somescheme");
        AuthScope authscope4 = new AuthScope("http", "somehost", 8080, "somerealm", "somescheme");
        AuthScope authscope5 = new AuthScope("http", "somehost", 80, "someotherrealm", "somescheme");
        AuthScope authscope6 = new AuthScope("http", "somehost", 80, "somerealm", "someotherscheme");
        AuthScope authscope7 = new AuthScope("https", "somehost", 80, "somerealm", "somescheme");
        AuthScope authscope8 = new AuthScope("https", "somehost", 80, "somerealm", "SomeScheme");
        Assertions.assertEquals((Object)authscope1, (Object)authscope1);
        Assertions.assertNotEquals((Object)authscope1, (Object)authscope2);
        Assertions.assertEquals((Object)authscope1, (Object)authscope3);
        Assertions.assertNotEquals((Object)authscope1, (Object)authscope4);
        Assertions.assertNotEquals((Object)authscope1, (Object)authscope5);
        Assertions.assertNotEquals((Object)authscope1, (Object)authscope6);
        Assertions.assertNotEquals((Object)authscope1, (Object)authscope7);
        Assertions.assertEquals((Object)authscope7, (Object)authscope8);
    }

    @Test
    public void testHash() {
        AuthScope authscope1 = new AuthScope("http", "somehost", 80, "somerealm", "somescheme");
        AuthScope authscope2 = new AuthScope("http", "someotherhost", 80, "somerealm", "somescheme");
        AuthScope authscope3 = new AuthScope("http", "somehost", 80, "somerealm", "somescheme");
        AuthScope authscope4 = new AuthScope("http", "somehost", 8080, "somerealm", "somescheme");
        AuthScope authscope5 = new AuthScope("http", "somehost", 80, "someotherrealm", "somescheme");
        AuthScope authscope6 = new AuthScope("http", "somehost", 80, "somerealm", "someotherscheme");
        AuthScope authscope7 = new AuthScope("https", "somehost", 80, "somerealm", "somescheme");
        AuthScope authscope8 = new AuthScope("https", "somehost", 80, "somerealm", "SomeScheme");
        Assertions.assertEquals((int)authscope1.hashCode(), (int)authscope1.hashCode());
        Assertions.assertNotEquals((int)authscope1.hashCode(), (int)authscope2.hashCode());
        Assertions.assertEquals((int)authscope1.hashCode(), (int)authscope3.hashCode());
        Assertions.assertNotEquals((int)authscope1.hashCode(), (int)authscope4.hashCode());
        Assertions.assertNotEquals((int)authscope1.hashCode(), (int)authscope5.hashCode());
        Assertions.assertNotEquals((int)authscope1.hashCode(), (int)authscope6.hashCode());
        Assertions.assertNotEquals((int)authscope1.hashCode(), (int)authscope7.hashCode());
        Assertions.assertEquals((int)authscope7.hashCode(), (int)authscope8.hashCode());
    }
}

