/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import java.util.Objects;
import org.apache.hc.core5.http.Header;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class HeadersMatcher
extends BaseMatcher<Header[]> {
    private final Header[] expectedHeaders;

    public HeadersMatcher(Header ... headers) {
        this.expectedHeaders = headers;
    }

    public boolean matches(Object item) {
        Header[] headers;
        if (item instanceof Header[] && (headers = (Header[])item).length == this.expectedHeaders.length) {
            for (int i = 0; i < headers.length; ++i) {
                Header h1 = headers[i];
                Header h2 = this.expectedHeaders[i];
                if (h1.getName().equalsIgnoreCase(h2.getName()) && Objects.equals(h1.getValue(), h2.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("same headers as ").appendValueList("[", ", ", "]", (Object[])this.expectedHeaders);
    }

    public static Matcher<Header[]> same(Header ... headers) {
        return new HeadersMatcher(headers);
    }
}

