/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.htrace.HBaseHTraceConfiguration;
import org.apache.htrace.HTraceConfiguration;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.SpanReceiverBuilder;
import org.apache.htrace.Trace;

public class HBaseSpanReceiverHost {
    public static final String SPAN_RECEIVERS_CONF_KEY = "hbase.trace.spanreceiver.classes";
    private static final Log LOG = LogFactory.getLog(HBaseSpanReceiverHost.class);
    private Collection<SpanReceiver> receivers = new HashSet<SpanReceiver>();
    private Configuration conf;
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HBaseSpanReceiverHost getInstance(Configuration conf) {
        Object object = SingletonHolder.INSTANCE.lock;
        synchronized (object) {
            if (SingletonHolder.INSTANCE.host != null) {
                return SingletonHolder.INSTANCE.host;
            }
            HBaseSpanReceiverHost host = new HBaseSpanReceiverHost(conf);
            host.loadSpanReceivers();
            SingletonHolder.INSTANCE.host = host;
            return SingletonHolder.INSTANCE.host;
        }
    }

    HBaseSpanReceiverHost(Configuration conf) {
        this.conf = conf;
    }

    public void loadSpanReceivers() {
        String[] receiverNames = this.conf.getStrings(SPAN_RECEIVERS_CONF_KEY);
        if (receiverNames == null || receiverNames.length == 0) {
            return;
        }
        SpanReceiverBuilder builder = new SpanReceiverBuilder((HTraceConfiguration)new HBaseHTraceConfiguration(this.conf));
        for (String className : receiverNames) {
            SpanReceiver receiver = builder.spanReceiverClass(className.trim()).build();
            if (receiver == null) continue;
            this.receivers.add(receiver);
            LOG.info((Object)("SpanReceiver " + className + " was loaded successfully."));
        }
        for (SpanReceiver rcvr : this.receivers) {
            Trace.addReceiver((SpanReceiver)rcvr);
        }
    }

    public synchronized void closeReceivers() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (SpanReceiver rcvr : this.receivers) {
            try {
                rcvr.close();
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to close SpanReceiver correctly: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static enum SingletonHolder {
        INSTANCE;

        Object lock = new Object();
        HBaseSpanReceiverHost host = null;
    }
}

