/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.log;

import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.AbstractService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.log.LogDivertAppender;
import org.apache.hive.service.cli.log.OperationLog;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class LogManager
extends AbstractService {
    private HiveConf hiveConf;
    private final Map<OperationHandle, OperationLog> OperationLogByOperation = new ConcurrentHashMap<OperationHandle, OperationLog>();
    private final Map<String, OperationLog> OperationLogByThreadName = new ConcurrentHashMap<String, OperationLog>();
    private boolean isOperationLogCaptureIntialized = false;
    private static final String DEFAULT_LAYOUT_PATTERN = "%d{yy/MM/dd HH:mm:ss} %p %c{2}: %m%n";
    private static Logger LOG = Logger.getLogger((String)LogManager.class.getName());
    private SessionManager sessionManager;

    public LogManager() {
        super("LogManager");
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void initOperationLogCapture() {
        Object ap;
        if (this.isOperationLogCaptureIntialized) {
            return;
        }
        Logger root = Logger.getRootLogger();
        PatternLayout layout = null;
        Enumeration appenders = root.getAllAppenders();
        while (appenders.hasMoreElements()) {
            ap = (Appender)appenders.nextElement();
            if (!ap.getClass().equals(ConsoleAppender.class)) continue;
            layout = ap.getLayout();
            break;
        }
        if (layout == null) {
            layout = new PatternLayout(DEFAULT_LAYOUT_PATTERN);
            LOG.info((Object)"Cannot find a Layout from a ConsoleAppender. Using default Layout pattern.");
        }
        ap = new LogDivertAppender((Layout)layout, this);
        root.addAppender(ap);
        this.isOperationLogCaptureIntialized = true;
    }

    public OperationLog createNewOperationLog(OperationHandle operationHandle, String name) {
        int size = HiveConf.getIntVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_IN_MEM_LOG_SIZE);
        LOG.info((Object)("Operation log size: " + size));
        OperationLog OperationLog2 = new OperationLog(name, size);
        this.OperationLogByOperation.put(operationHandle, OperationLog2);
        return OperationLog2;
    }

    public boolean destroyOperationLog(OperationHandle operationHandle) {
        OperationLog OperationLog2 = this.OperationLogByOperation.remove(operationHandle);
        if (OperationLog2 == null) {
            LOG.debug((Object)("No OperationLog found for operation: " + operationHandle.hashCode()));
            return false;
        }
        return true;
    }

    public void registerCurrentThread(OperationHandle operationHandle) throws HiveSQLException {
        String threadName = Thread.currentThread().getName();
        OperationLog OperationLog2 = this.getOperationLogByOperation(operationHandle, true);
        if (this.OperationLogByThreadName.containsKey(threadName)) {
            LOG.debug((Object)("Thread: " + threadName + " is already registered."));
        }
        this.OperationLogByThreadName.put(threadName, OperationLog2);
    }

    public void registerCurrentThread(OperationLog OperationLog2) {
        String threadName = Thread.currentThread().getName();
        this.OperationLogByThreadName.put(threadName, OperationLog2);
    }

    public boolean unregisterCurrentThread() {
        String threadName = Thread.currentThread().getName();
        OperationLog OperationLog2 = this.OperationLogByThreadName.remove(threadName);
        if (OperationLog2 == null) {
            LOG.debug((Object)("Failed to unregister thread " + threadName + ": OperationLog object is currently " + "not regsitered"));
            return false;
        }
        return true;
    }

    public OperationLog getOperationLogByThreadName(String threadName) {
        OperationLog OperationLog2 = this.OperationLogByThreadName.get(threadName);
        if (OperationLog2 == null) {
            LOG.debug((Object)("Operation log assocaited with thread: " + threadName + " couldn't be found."));
        }
        return OperationLog2;
    }

    public OperationLog getOperationLogByOperation(OperationHandle operationHandle, boolean createIfAbsent) throws HiveSQLException {
        OperationLog operationLog = this.OperationLogByOperation.get(operationHandle);
        if (operationLog == null && createIfAbsent) {
            operationLog = this.createNewOperationLog(operationHandle, operationHandle.toString());
        } else if (operationLog == null) {
            throw new HiveSQLException("Couldn't find log associated with operation handle: " + operationHandle.toString());
        }
        return operationLog;
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        super.init(hiveConf);
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_IN_MEM_LOGGING)) {
            this.initOperationLogCapture();
        } else {
            LOG.info((Object)"Opeation level logging is turned off");
        }
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
    }
}

