/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.typeinfo;

import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.BaseTypeParams;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeParams;

public class ParameterizedPrimitiveTypeUtils {
    public static BaseTypeParams getTypeParamsFromTypeInfo(TypeInfo typeInfo) {
        BaseTypeParams typeParams = null;
        if (typeInfo instanceof PrimitiveTypeInfo) {
            PrimitiveTypeInfo ppti = (PrimitiveTypeInfo)typeInfo;
            typeParams = ppti.getTypeParams();
        }
        return typeParams;
    }

    public static BaseTypeParams getTypeParamsFromPrimitiveTypeEntry(PrimitiveObjectInspectorUtils.PrimitiveTypeEntry typeEntry) {
        return typeEntry.typeParams;
    }

    public static BaseTypeParams getTypeParamsFromPrimitiveObjectInspector(PrimitiveObjectInspector oi) {
        return oi.getTypeParams();
    }

    public static boolean doesWritableMatchTypeParams(HiveVarcharWritable writable, VarcharTypeParams typeParams) {
        return typeParams == null || typeParams.length >= writable.getCharacterLength();
    }

    public static boolean doesPrimitiveMatchTypeParams(HiveVarchar value, VarcharTypeParams typeParams) {
        return typeParams == null || typeParams.length == value.getCharacterLength();
    }

    public static class HiveVarcharSerDeHelper {
        public int maxLength;
        public HiveVarcharWritable writable = new HiveVarcharWritable();

        public HiveVarcharSerDeHelper(VarcharTypeParams typeParams) {
            if (typeParams == null) {
                throw new RuntimeException("varchar type used without type params");
            }
            this.maxLength = typeParams.getLength();
        }
    }
}

