/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase.stats;

import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.hbase.stats.ColumnStatsAggregator;

public class StringColumnStatsAggregator
implements ColumnStatsAggregator {
    @Override
    public void aggregate(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        StringColumnStatsData aggregateData = aggregateColStats.getStatsData().getStringStats();
        StringColumnStatsData newData = newColStats.getStatsData().getStringStats();
        aggregateData.setMaxColLen(Math.max(aggregateData.getMaxColLen(), newData.getMaxColLen()));
        aggregateData.setAvgColLen(Math.max(aggregateData.getAvgColLen(), newData.getAvgColLen()));
        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
        aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
    }
}

