/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.mapred.JobConf;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.input.MultiMRInput;

@InterfaceAudience.Private
public class LlapTezUtils {
    public static boolean isSourceOfInterest(String inputClassName) {
        return !inputClassName.equals(MRInputLegacy.class.getName()) && !inputClassName.equals(MultiMRInput.class.getName()) && !inputClassName.equals(MRInput.class.getName());
    }

    public static String getDagId(JobConf job) {
        return job.get("tez.mapreduce.dag.id");
    }

    public static String getFragmentId(JobConf job) {
        String taskAttemptId = job.get("tez.mapreduce.task.attempt.id");
        if (taskAttemptId != null) {
            return LlapTezUtils.stripAttemptPrefix(taskAttemptId);
        }
        return null;
    }

    public static String stripAttemptPrefix(String s) {
        if (s.startsWith("attempt")) {
            return s.substring("attempt".length() + 1);
        }
        return s;
    }
}

