/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.daemon.impl.LlapTokenManager;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.hive.llap.security.SecretManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLlapTokenManager
implements LlapTokenManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLlapTokenManager.class);
    private final ScheduledExecutorService tokenChecker = Executors.newScheduledThreadPool(1);
    private final List<TokenWrapper> tokens = new ArrayList<TokenWrapper>();
    private SecretManager secretManager;
    private String clusterUser;

    public DefaultLlapTokenManager(Configuration conf, SecretManager secretManager) {
        this.secretManager = secretManager;
        try {
            this.clusterUser = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOG.info("Initializing periodic token refresh in daemon, will run in every {}s", (Object)300L);
        this.tokenChecker.scheduleAtFixedRate(() -> {
            LOG.debug("Checking tokens, count: {}", (Object)this.tokens.size());
            ListIterator<TokenWrapper> tokensIt = this.tokens.listIterator();
            while (tokensIt.hasNext()) {
                TokenWrapper token = tokensIt.next();
                if (this.needsRecreate(token)) {
                    try {
                        LOG.info("Cancelling token: {}", (Object)token.realToken);
                        secretManager.cancelToken(token.realToken, this.clusterUser);
                        tokensIt.remove();
                    }
                    catch (IOException e) {
                        LOG.error("Error while cancelling token: {}", (Object)token.realToken, (Object)e);
                    }
                    continue;
                }
                if (!this.needsRenew(token)) continue;
                token.renew();
            }
        }, 0L, 300L, TimeUnit.SECONDS);
    }

    private boolean needsRecreate(TokenWrapper token) {
        long now = Time.now();
        long tokenWholeLifeTimeMs = token.maxDate - token.issueDate;
        long tokenRemainingLifeTimeMs = Math.max(token.maxDate - now, 0L);
        double tokenRemainingLifeTimePercent = (double)tokenRemainingLifeTimeMs / (double)tokenWholeLifeTimeMs;
        boolean needsRecreate = tokenRemainingLifeTimePercent < 0.1;
        LOG.debug("Token needsRecreate? {}, now: {}, maxDate: {}, issueDate: {}, tokenWholeLifeTime(ms): {}, tokenRemainingLifeTime(ms): {}, tokenRemainingLifeTimePercent: {}%", new Object[]{needsRecreate, now, token.maxDate, token.issueDate, tokenWholeLifeTimeMs, tokenRemainingLifeTimeMs, this.toPercentString(tokenRemainingLifeTimePercent)});
        return needsRecreate;
    }

    private boolean needsRenew(TokenWrapper token) {
        long now = Time.now();
        long tokenWholeValidityPeriodMs = token.expirationTime - token.renewalTime;
        long tokenRemainingValidityPeriodMs = Math.max(token.expirationTime - now, 0L);
        double tokenRemainingValidityPeriodPercent = (double)tokenRemainingValidityPeriodMs / (double)tokenWholeValidityPeriodMs;
        boolean needsRenew = tokenRemainingValidityPeriodPercent < 0.1;
        LOG.debug("Token needsRenew? {}, now: {}, expirationTime: {}, renewalTime: {}, tokenWholeValidityPeriod(ms): {}, tokenRemainingValidityPeriod(ms): {}, tokenRelativeRemainingValidityPeriod: {}%", new Object[]{needsRenew, now, token.expirationTime, token.renewalTime, tokenWholeValidityPeriodMs, tokenRemainingValidityPeriodMs, this.toPercentString(tokenRemainingValidityPeriodPercent)});
        return needsRenew;
    }

    private String toPercentString(double dblNumber) {
        return Double.toString((double)Math.round(dblNumber * 1000.0) / 10.0);
    }

    @Override
    public Token<LlapTokenIdentifier> getToken(LlapDaemonProtocolProtos.GetTokenRequestProto request, boolean isSigningRequired) throws IOException {
        Token<LlapTokenIdentifier> token;
        Token<LlapTokenIdentifier> token2 = token = this.tokens.isEmpty() ? null : this.tokens.get(0).realToken;
        if (token == null) {
            token = this.generateToken(request, isSigningRequired);
        } else {
            LOG.debug("Returning already existing token: {}", (Object)token);
        }
        return token;
    }

    private Token<LlapTokenIdentifier> generateToken(LlapDaemonProtocolProtos.GetTokenRequestProto request, boolean isSigningRequired) throws IOException {
        Token token = this.secretManager.createLlapToken(request.hasAppId() ? request.getAppId() : null, null, isSigningRequired);
        this.tokens.add(new TokenWrapper((Token<LlapTokenIdentifier>)token));
        LOG.info("Added new token: {}, #tokens: {}", (Object)token, (Object)this.tokens.size());
        return token;
    }

    @Override
    public void close() {
        this.cancelTokens(this.tokens);
    }

    private void cancelTokens(List<TokenWrapper> tokensToCancel) {
        ListIterator<TokenWrapper> tokensIt = tokensToCancel.listIterator();
        while (tokensIt.hasNext()) {
            TokenWrapper token = tokensIt.next();
            try {
                this.secretManager.cancelToken(token.realToken, this.clusterUser);
                tokensIt.remove();
            }
            catch (IOException e) {
                LOG.warn("Cannot cancel token while shutting down (on IOException): " + token + ", giving up", (Throwable)e);
            }
        }
    }

    private class TokenWrapper {
        private final Token<LlapTokenIdentifier> realToken;
        private final long issueDate;
        private final long maxDate;
        private long expirationTime = 0L;
        private long renewalTime = 0L;

        public TokenWrapper(Token<LlapTokenIdentifier> token) {
            this.realToken = token;
            try {
                this.renew();
                this.issueDate = ((LlapTokenIdentifier)token.decodeIdentifier()).getIssueDate();
                this.maxDate = ((LlapTokenIdentifier)token.decodeIdentifier()).getMaxDate();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void renew() {
            LOG.info("Renewing token: " + this.realToken);
            try {
                this.expirationTime = DefaultLlapTokenManager.this.secretManager.renewToken(this.realToken, DefaultLlapTokenManager.this.clusterUser);
                this.renewalTime = Time.now();
                LOG.info("Renewed token: " + this.realToken);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.realToken.toString();
        }
    }
}

