/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.metadata;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.MemoryManager;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileEstimateErrors;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileMetadata;
import org.apache.hadoop.hive.llap.io.metadata.OrcStripeMetadata;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;

public class OrcMetadataCache {
    private final ConcurrentHashMap<Object, OrcFileMetadata> metadata = new ConcurrentHashMap();
    private final ConcurrentHashMap<OrcBatchKey, OrcStripeMetadata> stripeMetadata = new ConcurrentHashMap();
    private final ConcurrentHashMap<Object, OrcFileEstimateErrors> estimateErrors;
    private final MemoryManager memoryManager;
    private final LowLevelCachePolicy policy;

    public OrcMetadataCache(MemoryManager memoryManager, LowLevelCachePolicy policy, boolean useEstimateCache) {
        this.memoryManager = memoryManager;
        this.policy = policy;
        this.estimateErrors = useEstimateCache ? new ConcurrentHashMap() : null;
    }

    public OrcFileMetadata putFileMetadata(OrcFileMetadata metaData) {
        long memUsage = metaData.getMemoryUsage();
        this.memoryManager.reserveMemory(memUsage);
        OrcFileMetadata val = this.metadata.putIfAbsent(metaData.getFileKey(), metaData);
        return this.touchOnPut(metaData, val, memUsage);
    }

    public OrcStripeMetadata putStripeMetadata(OrcStripeMetadata metaData) {
        long memUsage = metaData.getMemoryUsage();
        this.memoryManager.reserveMemory(memUsage);
        OrcStripeMetadata val = this.stripeMetadata.putIfAbsent(metaData.getKey(), metaData);
        return this.touchOnPut(metaData, val, memUsage);
    }

    private <T extends LlapCacheableBuffer> T touchOnPut(T newVal, T oldVal, long memUsage) {
        if (oldVal == null) {
            oldVal = newVal;
            this.policy.cache(oldVal, LowLevelCache.Priority.HIGH);
        } else {
            this.memoryManager.releaseMemory(memUsage);
            this.policy.notifyLock(oldVal);
        }
        this.policy.notifyUnlock(oldVal);
        return oldVal;
    }

    public void putIncompleteCbs(Object fileKey, DiskRange[] ranges, long baseOffset) {
        if (this.estimateErrors == null) {
            return;
        }
        OrcFileEstimateErrors errorData = this.estimateErrors.get(fileKey);
        boolean isNew = false;
        if (errorData == null) {
            errorData = new OrcFileEstimateErrors(fileKey);
            for (DiskRange range : ranges) {
                errorData.addError(range.getOffset(), range.getLength(), baseOffset);
            }
            long memUsage = errorData.estimateMemoryUsage();
            this.memoryManager.reserveMemory(memUsage);
            OrcFileEstimateErrors old = this.estimateErrors.putIfAbsent(fileKey, errorData);
            if (old != null) {
                errorData = old;
                this.memoryManager.releaseMemory(memUsage);
                this.policy.notifyLock(errorData);
            } else {
                isNew = true;
                this.policy.cache(errorData, LowLevelCache.Priority.NORMAL);
            }
        }
        if (!isNew) {
            for (DiskRange range : ranges) {
                errorData.addError(range.getOffset(), range.getLength(), baseOffset);
            }
        }
        this.policy.notifyUnlock(errorData);
    }

    public OrcStripeMetadata getStripeMetadata(OrcBatchKey stripeKey) throws IOException {
        return (OrcStripeMetadata)this.touchOnGet((LlapCacheableBuffer)this.stripeMetadata.get(stripeKey));
    }

    public OrcFileMetadata getFileMetadata(Object fileKey) throws IOException {
        return (OrcFileMetadata)this.touchOnGet((LlapCacheableBuffer)this.metadata.get(fileKey));
    }

    private <T extends LlapCacheableBuffer> T touchOnGet(T result) {
        if (result != null) {
            this.policy.notifyLock(result);
            this.policy.notifyUnlock(result);
        }
        return result;
    }

    public DiskRangeList getIncompleteCbs(Object fileKey, DiskRangeList ranges, long baseOffset, DataCache.DiskRangeListFactory factory, DataCache.BooleanRef gotAllData) {
        if (this.estimateErrors == null) {
            return ranges;
        }
        OrcFileEstimateErrors errors = this.estimateErrors.get(fileKey);
        if (errors == null) {
            return ranges;
        }
        return errors.getIncompleteCbs(ranges, baseOffset, factory, gotAllData);
    }

    public void notifyEvicted(OrcFileMetadata buffer) {
        this.metadata.remove(buffer.getFileKey());
    }

    public void notifyEvicted(OrcStripeMetadata buffer) {
        this.stripeMetadata.remove(buffer.getKey());
    }

    public void notifyEvicted(OrcFileEstimateErrors buffer) {
        this.estimateErrors.remove(buffer.getFileKey());
    }
}

