/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.arrow.vector.FieldVector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.LlapRowRecordReader;
import org.apache.hadoop.hive.llap.Row;
import org.apache.hadoop.hive.llap.Schema;
import org.apache.hadoop.hive.ql.io.arrow.ArrowColumnarBatchSerDe;
import org.apache.hadoop.hive.ql.io.arrow.ArrowWrapperWritable;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapArrowRowRecordReader
extends LlapRowRecordReader {
    private static final Logger LOG = LoggerFactory.getLogger(LlapArrowRowRecordReader.class);
    private int rowIndex = 0;
    private int batchSize = 0;
    private Object[][] currentBatch;

    public LlapArrowRowRecordReader(Configuration conf, Schema schema, RecordReader<NullWritable, ? extends Writable> reader) throws IOException {
        super(conf, schema, reader);
    }

    public boolean next(NullWritable key, Row value) throws IOException {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        boolean hasNext = false;
        ArrowWrapperWritable batchData = (ArrowWrapperWritable)this.data;
        if (this.batchSize == 0 || this.rowIndex == this.batchSize) {
            this.batchSize = 0;
            this.rowIndex = 0;
            hasNext = this.reader.next((Object)key, (Object)this.data);
            if (hasNext) {
                try {
                    List vectors = batchData.getVectorSchemaRoot().getFieldVectors();
                    Preconditions.checkState((vectors.size() > 0 ? 1 : 0) != 0);
                    this.batchSize = ((FieldVector)vectors.get(0)).getValueCount();
                    ArrowWrapperWritable wrapper = new ArrowWrapperWritable(batchData.getVectorSchemaRoot());
                    this.currentBatch = (Object[][])this.serde.deserialize((Writable)wrapper);
                    StructObjectInspector rowOI = (StructObjectInspector)this.serde.getObjectInspector();
                    LlapArrowRowRecordReader.setRowFromStruct((Row)value, (Object)this.currentBatch[this.rowIndex], (StructObjectInspector)rowOI);
                }
                catch (Exception e) {
                    LOG.error("Failed to fetch Arrow batch", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        } else if (this.rowIndex < this.batchSize) {
            hasNext = true;
            StructObjectInspector rowOI = null;
            try {
                rowOI = (StructObjectInspector)this.serde.getObjectInspector();
            }
            catch (SerDeException e) {
                throw new RuntimeException(e);
            }
            LlapArrowRowRecordReader.setRowFromStruct((Row)value, (Object)this.currentBatch[this.rowIndex], (StructObjectInspector)rowOI);
        }
        ++this.rowIndex;
        return hasNext;
    }

    protected AbstractSerDe createSerDe() throws SerDeException {
        return new ArrowColumnarBatchSerDe();
    }
}

