/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.packages;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hive.hplsql.packages.PackageRegistry;

public class InMemoryPackageRegistry
implements PackageRegistry {
    private Map<String, Source> registry = new HashMap<String, Source>();

    @Override
    public Optional<String> getPackage(String name) {
        Source src = this.registry.get(name.toUpperCase());
        return src == null ? Optional.empty() : Optional.of(src.header + ";\n" + src.body);
    }

    @Override
    public void createPackageHeader(String name, String header, boolean replace) {
        if (this.registry.containsKey(name) && !replace) {
            throw new RuntimeException("Package " + name + " already exits");
        }
        this.registry.put(name, new Source(header, ""));
    }

    @Override
    public void createPackageBody(String name, String body, boolean replace) {
        Source existing = this.registry.get(name);
        if (existing == null || StringUtils.isEmpty((CharSequence)existing.header)) {
            throw new RuntimeException("Package header does not exists " + name);
        }
        if (existing != null && StringUtils.isNotEmpty((CharSequence)existing.body) && !replace) {
            throw new RuntimeException("Package body " + name + " already exits");
        }
        this.registry.getOrDefault((Object)name, (Source)new Source((String)"", (String)"")).body = body;
    }

    @Override
    public void dropPackage(String name) {
        this.registry.remove(name);
    }

    private static class Source {
        String header;
        String body;

        public Source(String header, String body) {
            this.header = header;
            this.body = body;
        }
    }
}

