/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hive.hplsql.Conn;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.executor.QueryException;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.apache.hive.hplsql.executor.QueryResult;
import org.apache.hive.hplsql.functions.BuiltinFunctions;
import org.apache.hive.hplsql.functions.FunctionDatetime;

public class FunctionMisc
extends BuiltinFunctions {
    public FunctionMisc(Exec e, QueryExecutor queryExecutor) {
        super(e, queryExecutor);
    }

    @Override
    public void register(BuiltinFunctions f) {
        f.map.put("DECODE", this::decode);
        f.map.put("NVL2", this::nvl2);
        f.map.put("PART_COUNT_BY", this::partCountBy);
        f.specMap.put("ACTIVITY_COUNT", this::activityCount);
        f.specMap.put("CURRENT", this::current);
        f.specMap.put("CURRENT_USER", this::currentUser);
        f.specMap.put("PART_COUNT", this::partCount);
        f.specMap.put("USER", this::currentUser);
        f.specSqlMap.put("CURRENT", this::currentSql);
    }

    void activityCount(HplsqlParser.Expr_spec_funcContext ctx) {
        this.evalInt(Long.valueOf(this.exec.getRowCount()));
    }

    void current(HplsqlParser.Expr_spec_funcContext ctx) {
        if (ctx.T_DATE() != null) {
            this.evalVar(FunctionDatetime.currentDate());
        } else if (ctx.T_TIMESTAMP() != null) {
            int precision = this.evalPop(ctx.expr(0), 3).intValue();
            this.evalVar(FunctionDatetime.currentTimestamp(precision));
        } else if (ctx.T_USER() != null) {
            this.evalVar(FunctionMisc.currentUser());
        } else {
            this.evalNull();
        }
    }

    void currentSql(HplsqlParser.Expr_spec_funcContext ctx) {
        if (ctx.T_DATE() != null) {
            if (this.exec.getConnectionType() == Conn.Type.HIVE) {
                this.evalString("TO_DATE(FROM_UNIXTIME(UNIX_TIMESTAMP()))");
            } else {
                this.evalString("CURRENT_DATE");
            }
        } else if (ctx.T_TIMESTAMP() != null) {
            if (this.exec.getConnectionType() == Conn.Type.HIVE) {
                this.evalString("FROM_UNIXTIME(UNIX_TIMESTAMP())");
            } else {
                this.evalString("CURRENT_TIMESTAMP");
            }
        } else if (ctx.T_USER() != null) {
            this.evalString("CURRENT_USER()");
        } else {
            this.evalString(Exec.getFormattedText(ctx));
        }
    }

    void currentUser(HplsqlParser.Expr_spec_funcContext ctx) {
        this.evalVar(FunctionMisc.currentUser());
    }

    public static Var currentUser() {
        return new Var("CURRENT_USER()");
    }

    void decode(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = ctx.func_param().size();
        if (cnt < 3) {
            this.evalNull();
            return;
        }
        Var value = this.evalPop(ctx.func_param(0).expr());
        int i = 1;
        while (i + 1 < cnt) {
            Var when = this.evalPop(ctx.func_param(i).expr());
            if (value.isNull() && when.isNull() || value.equals(when)) {
                this.eval(ctx.func_param(i + 1).expr());
                return;
            }
            i += 2;
        }
        if (i < cnt) {
            this.eval(ctx.func_param(i).expr());
        } else {
            this.evalNull();
        }
    }

    void nvl2(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() == 3) {
            Var firstParam = this.evalPop(ctx.func_param(0).expr());
            if (!firstParam.isNull() && !"null".equalsIgnoreCase((String)firstParam.value)) {
                this.eval(ctx.func_param(1).expr());
            } else {
                this.eval(ctx.func_param(2).expr());
            }
        } else {
            this.evalNull();
        }
    }

    public void partCount(HplsqlParser.Expr_spec_funcContext ctx) {
        String tabname = this.evalPop(ctx.expr(0)).toString();
        StringBuilder sql = new StringBuilder();
        sql.append("SHOW PARTITIONS ");
        sql.append(tabname);
        int cnt = ctx.expr().size();
        if (cnt > 1) {
            sql.append(" PARTITION (");
            int i = 1;
            while (i + 1 < cnt) {
                String col = this.evalPop(ctx.expr(i)).toString();
                String val = this.evalPop(ctx.expr(i + 1)).toSqlString();
                if (i > 2) {
                    sql.append(", ");
                }
                sql.append(col);
                sql.append("=");
                sql.append(val);
                i += 2;
            }
            sql.append(")");
        }
        if (this.trace) {
            this.trace(ctx, "Query: " + sql);
        }
        if (this.exec.getOffline()) {
            this.evalNull();
            return;
        }
        QueryResult query = this.queryExecutor.executeQuery(sql.toString(), ctx);
        if (query.error()) {
            this.evalNullClose(query);
            return;
        }
        int result = 0;
        try {
            while (query.next()) {
                ++result;
            }
        }
        catch (Exception e) {
            this.evalNullClose(query);
            return;
        }
        this.evalInt(result);
        query.close();
    }

    public void partCountBy(HplsqlParser.Expr_func_paramsContext ctx) {
        String sql;
        QueryResult query;
        int cnt = ctx.func_param().size();
        if (cnt < 1 || this.exec.getOffline()) {
            return;
        }
        String tabname = this.evalPop(ctx.func_param(0).expr()).toString();
        ArrayList<String> keys = null;
        if (cnt > 1) {
            keys = new ArrayList<String>();
            for (int i = 1; i < cnt; ++i) {
                keys.add(this.evalPop(ctx.func_param(i).expr()).toString().toUpperCase());
            }
        }
        if ((query = this.queryExecutor.executeQuery(sql = "SHOW PARTITIONS " + tabname, ctx)).error()) {
            query.close();
            return;
        }
        HashMap<String, Integer> group = new HashMap<String, Integer>();
        try {
            while (query.next()) {
                Integer count;
                String part = query.column(0, String.class);
                String[] parts = part.split("/");
                String key = parts[0];
                if (cnt > 1) {
                    StringBuilder k = new StringBuilder();
                    for (int i = 0; i < parts.length; ++i) {
                        if (!keys.contains(parts[i].split("=")[0].toUpperCase())) continue;
                        if (k.length() > 0) {
                            k.append("/");
                        }
                        k.append(parts[i]);
                    }
                    key = k.toString();
                }
                if ((count = (Integer)group.get(key)) == null) {
                    count = 0;
                }
                group.put(key, count + 1);
            }
        }
        catch (QueryException e) {
            query.close();
            return;
        }
        if (cnt == 1) {
            this.evalInt(group.size());
        } else {
            for (Map.Entry i : group.entrySet()) {
                this.console.printLine((String)i.getKey() + '\t' + i.getValue());
            }
        }
        query.close();
    }
}

