/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.functions;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.hive.hplsql.Conn;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Utils;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.apache.hive.hplsql.functions.BuiltinFunctions;

public class FunctionDatetime
extends BuiltinFunctions {
    public FunctionDatetime(Exec e, QueryExecutor queryExecutor) {
        super(e, queryExecutor);
    }

    @Override
    public void register(BuiltinFunctions f) {
        f.map.put("DATE", this::date);
        f.map.put("NOW", ctx -> this.now(ctx));
        f.map.put("TIMESTAMP_ISO", this::timestampIso);
        f.map.put("TO_TIMESTAMP", this::toTimestamp);
        f.map.put("CURRENT_TIME_MILLIS", this::currentTimeMillis);
        f.specMap.put("SYSDATE", this::currentTimestamp);
        f.specSqlMap.put("CURRENT_DATE", this::currentDateSql);
        f.specSqlMap.put("CURRENT_TIMESTAMP", this::currentTimestampSql);
    }

    public static Var currentDate() {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        String s = f.format(Calendar.getInstance().getTime());
        return new Var(Var.Type.DATE, Utils.toDate(s));
    }

    public void currentDateSql(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.exec.getConnectionType() == Conn.Type.HIVE) {
            this.evalString("TO_DATE(FROM_UNIXTIME(UNIX_TIMESTAMP()))");
        } else {
            this.evalString(Exec.getFormattedText(ctx));
        }
    }

    public void currentTimestamp(HplsqlParser.Expr_spec_funcContext ctx) {
        int precision = this.evalPop(ctx.expr(0), 3).intValue();
        this.evalVar(FunctionDatetime.currentTimestamp(precision));
    }

    public static Var currentTimestamp(int precision) {
        String format = "yyyy-MM-dd HH:mm:ss";
        if (precision > 0 && precision <= 3) {
            format = format + "." + StringUtils.repeat((String)"S", (int)precision);
        }
        SimpleDateFormat f = new SimpleDateFormat(format);
        String s = f.format(Calendar.getInstance(TimeZone.getDefault()).getTime());
        return new Var(Utils.toTimestamp(s), precision);
    }

    public void currentTimestampSql(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.exec.getConnectionType() == Conn.Type.HIVE) {
            this.evalString("FROM_UNIXTIME(UNIX_TIMESTAMP())");
        } else {
            this.evalString(Exec.getFormattedText(ctx));
        }
    }

    void date(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        Var var = new Var(Var.Type.DATE);
        Var date = this.evalPop(ctx.func_param(0).expr());
        date.setValue(Utils.unquoteString(date.toString()));
        var.cast(date);
        this.evalVar(var);
    }

    void now(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx != null) {
            this.evalNull();
            return;
        }
        this.evalVar(FunctionDatetime.currentTimestamp(3));
    }

    void timestampIso(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        Var var = new Var(Var.Type.TIMESTAMP);
        Var val = this.evalPop(ctx.func_param(0).expr());
        val.setValue(Utils.unquoteString(val.toString()));
        var.cast(val);
        this.evalVar(var);
    }

    void toTimestamp(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 2) {
            this.evalNull();
            return;
        }
        String value = Utils.unquoteString(this.evalPop(ctx.func_param(0).expr()).toString());
        String sqlFormat = Utils.unquoteString(this.evalPop(ctx.func_param(1).expr()).toString());
        String format = Utils.convertSqlDatetimeFormat(sqlFormat);
        try {
            long timeInMs = new SimpleDateFormat(format).parse(value).getTime();
            this.evalVar(new Var(Var.Type.TIMESTAMP, new Timestamp(timeInMs)));
        }
        catch (Exception e) {
            this.exec.signal(e);
            this.evalNull();
        }
    }

    public void currentTimeMillis(HplsqlParser.Expr_func_paramsContext ctx) {
        this.evalVar(new Var(System.currentTimeMillis()));
    }
}

