/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hive.hbase.DataInputInputStream;
import org.apache.hadoop.hive.hbase.DataOutputOutputStream;
import org.apache.hadoop.io.Writable;

public class PutWritable
implements Writable {
    private Put put;

    public PutWritable() {
    }

    public PutWritable(Put put) {
        this.put = put;
    }

    public Put getPut() {
        return this.put;
    }

    public void readFields(DataInput in) throws IOException {
        ClientProtos.MutationProto putProto = ClientProtos.MutationProto.parseDelimitedFrom((InputStream)DataInputInputStream.from(in));
        int size = in.readInt();
        if (size < 0) {
            throw new IOException("Invalid size " + size);
        }
        Cell[] kvs = new Cell[size];
        for (int i = 0; i < kvs.length; ++i) {
            kvs[i] = KeyValue.create((DataInput)in);
        }
        this.put = ProtobufUtil.toPut((ClientProtos.MutationProto)putProto, (CellScanner)CellUtil.createCellScanner((Cell[])kvs));
    }

    public void write(DataOutput out) throws IOException {
        ProtobufUtil.toMutationNoData((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)this.put).writeDelimitedTo(DataOutputOutputStream.from(out));
        out.writeInt(this.put.size());
        CellScanner scanner = this.put.cellScanner();
        while (scanner.advance()) {
            KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)scanner.current());
            KeyValue.write((KeyValue)kv, (DataOutput)out);
        }
    }
}

