/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncACosDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncACosLongToDouble;
import org.apache.hadoop.hive.ql.udf.UDFMath;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="acos", value="_FUNC_(x) - returns the arc cosine of x if -1<=x<=1 or NULL otherwise", extended="Example:\n  > SELECT _FUNC_(1) FROM src LIMIT 1;\n  0\n  > SELECT _FUNC_(2) FROM src LIMIT 1;\n  NULL")
@VectorizedExpressions(value={FuncACosLongToDouble.class, FuncACosDoubleToDouble.class})
public class UDFAcos
extends UDFMath {
    private final DoubleWritable result = new DoubleWritable();

    @Override
    protected DoubleWritable doEvaluate(DoubleWritable a) {
        double d = a.get();
        if (d < -1.0 || d > 1.0) {
            return null;
        }
        this.result.set(Math.acos(d));
        return this.result;
    }
}

