/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.CreateTableMessage;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;

class CreateTableHandler
extends AbstractEventHandler {
    CreateTableHandler(NotificationEvent event) {
        super(event);
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        CreateTableMessage ctm = this.deserializer.getCreateTableMessage(this.event.getMessage());
        LOG.info("Processing#{} CREATE_TABLE message : {}", (Object)this.fromEventId(), (Object)this.event.getMessage());
        org.apache.hadoop.hive.metastore.api.Table tobj = ctm.getTableObj();
        if (tobj == null) {
            LOG.debug("Event#{} was a CREATE_TABLE_EVENT with no table listed");
            return;
        }
        Table qlMdTable = new Table(tobj);
        if (!Utils.shouldReplicate(withinContext.replicationSpec, qlMdTable, withinContext.hiveConf).booleanValue()) {
            return;
        }
        if (qlMdTable.isView()) {
            withinContext.replicationSpec.setIsMetadataOnly(true);
        }
        Path metaDataPath = new Path(withinContext.eventRoot, "_metadata");
        EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)withinContext.hiveConf), metaDataPath, qlMdTable, null, withinContext.replicationSpec, withinContext.hiveConf);
        Path dataPath = new Path(withinContext.eventRoot, "data");
        Iterable<String> files = ctm.getFiles();
        if (files != null) {
            try (BufferedWriter fileListWriter = this.writer(withinContext, dataPath);){
                for (String file : files) {
                    fileListWriter.write(file + "\n");
                }
            }
        }
        withinContext.createDmd(this).write();
    }

    private BufferedWriter writer(EventHandler.Context withinContext, Path dataPath) throws IOException {
        FileSystem fs = dataPath.getFileSystem((Configuration)withinContext.hiveConf);
        Path filesPath = new Path(dataPath, "_files");
        return new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(filesPath)));
    }

    @Override
    public DumpType dumpType() {
        return DumpType.EVENT_CREATE_TABLE;
    }
}

