/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.timestamp;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import jodd.datetime.JDateTime;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;

public class NanoTimeUtils {
    static final long NANOS_PER_HOUR = TimeUnit.HOURS.toNanos(1L);
    static final long NANOS_PER_MINUTE = TimeUnit.MINUTES.toNanos(1L);
    static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    static final long NANOS_PER_DAY = TimeUnit.DAYS.toNanos(1L);
    private static final ThreadLocal<Calendar> parquetGMTCalendar = new ThreadLocal();

    private static Calendar getGMTCalendar() {
        if (parquetGMTCalendar.get() == null) {
            parquetGMTCalendar.set(Calendar.getInstance(TimeZone.getTimeZone("GMT")));
        }
        parquetGMTCalendar.get().clear();
        return parquetGMTCalendar.get();
    }

    public static NanoTime getNanoTime(Timestamp ts, boolean skipConversion) {
        return NanoTimeUtils.getNanoTime(ts, skipConversion, null);
    }

    public static NanoTime getNanoTime(Timestamp ts, boolean skipConversion, ZoneId timeZoneId) {
        if (skipConversion) {
            timeZoneId = ZoneOffset.UTC;
        } else if (timeZoneId == null) {
            timeZoneId = TimeZone.getDefault().toZoneId();
        }
        ts = TimestampTZUtil.convertTimestampToZone(ts, timeZoneId, ZoneOffset.UTC);
        Calendar calendar = NanoTimeUtils.getGMTCalendar();
        calendar.setTimeInMillis(ts.toEpochMilli());
        int year = calendar.get(1);
        if (calendar.get(0) == 0) {
            year = 1 - year;
        }
        JDateTime jDateTime = new JDateTime(year, calendar.get(2) + 1, calendar.get(5));
        int days = jDateTime.getJulianDayNumber();
        long hour = calendar.get(11);
        long minute = calendar.get(12);
        long second = calendar.get(13);
        long nanos = ts.getNanos();
        long nanosOfDay = nanos + NANOS_PER_SECOND * second + NANOS_PER_MINUTE * minute + NANOS_PER_HOUR * hour;
        return new NanoTime(days, nanosOfDay);
    }

    public static Timestamp getTimestamp(NanoTime nt, boolean skipConversion) {
        return NanoTimeUtils.getTimestamp(nt, skipConversion, null);
    }

    public static Timestamp getTimestamp(NanoTime nt, boolean skipConversion, ZoneId timeZoneId) {
        long nanosOfDay;
        if (skipConversion) {
            timeZoneId = ZoneOffset.UTC;
        } else if (timeZoneId == null) {
            timeZoneId = TimeZone.getDefault().toZoneId();
        }
        int julianDay = nt.getJulianDay();
        long remainder = nanosOfDay = nt.getTimeOfDayNanos();
        julianDay = (int)((long)julianDay + remainder / NANOS_PER_DAY);
        if ((remainder %= NANOS_PER_DAY) < 0L) {
            remainder += NANOS_PER_DAY;
            --julianDay;
        }
        JDateTime jDateTime = new JDateTime((double)julianDay);
        Calendar calendar = NanoTimeUtils.getGMTCalendar();
        calendar.set(1, jDateTime.getYear());
        calendar.set(2, jDateTime.getMonth() - 1);
        calendar.set(5, jDateTime.getDay());
        int hour = (int)(remainder / NANOS_PER_HOUR);
        int minutes = (int)((remainder %= NANOS_PER_HOUR) / NANOS_PER_MINUTE);
        int seconds = (int)((remainder %= NANOS_PER_MINUTE) / NANOS_PER_SECOND);
        long nanos = remainder % NANOS_PER_SECOND;
        calendar.set(11, hour);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        Timestamp ts = Timestamp.ofEpochMilli(calendar.getTimeInMillis(), (int)nanos);
        ts = TimestampTZUtil.convertTimestampToZone(ts, ZoneOffset.UTC, timeZoneId);
        return ts;
    }
}

