/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.DatabaseEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.BootstrapEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.ConstraintEventsIterator;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.session.LineageState;

@Explain(displayName="Replication Load Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ReplLoadWork
implements Serializable {
    final String dbNameToLoadIn;
    final String tableNameToLoadIn;
    final String dumpDirectory;
    private final BootstrapEventsIterator iterator;
    private final ConstraintEventsIterator constraintsIterator;
    private int loadTaskRunCount = 0;
    private DatabaseEvent.State state = null;
    final LineageState sessionStateLineageState;

    public ReplLoadWork(HiveConf hiveConf, String dumpDirectory, String dbNameToLoadIn, String tableNameToLoadIn, LineageState lineageState) throws IOException {
        this.tableNameToLoadIn = tableNameToLoadIn;
        this.sessionStateLineageState = lineageState;
        this.dumpDirectory = dumpDirectory;
        this.iterator = new BootstrapEventsIterator(dumpDirectory, dbNameToLoadIn, hiveConf);
        this.constraintsIterator = new ConstraintEventsIterator(dumpDirectory, hiveConf);
        this.dbNameToLoadIn = dbNameToLoadIn;
    }

    public ReplLoadWork(HiveConf hiveConf, String dumpDirectory, String dbNameOrPattern, LineageState lineageState) throws IOException {
        this(hiveConf, dumpDirectory, dbNameOrPattern, null, lineageState);
    }

    public BootstrapEventsIterator iterator() {
        return this.iterator;
    }

    public ConstraintEventsIterator constraintIterator() {
        return this.constraintsIterator;
    }

    int executedLoadTask() {
        return ++this.loadTaskRunCount;
    }

    void updateDbEventState(DatabaseEvent.State state) {
        this.state = state;
    }

    DatabaseEvent databaseEvent(HiveConf hiveConf) {
        return this.state.toEvent(hiveConf);
    }

    boolean hasDbState() {
        return this.state != null;
    }
}

