/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.security.DelegationTokenIdentifier;
import org.apache.hadoop.hive.metastore.security.DelegationTokenStore;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryTokenStore
implements DelegationTokenStore {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryTokenStore.class);
    private final Map<Integer, String> masterKeys = new ConcurrentHashMap<Integer, String>();
    private final ConcurrentHashMap<DelegationTokenIdentifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation> tokens = new ConcurrentHashMap();
    private final AtomicInteger masterKeySeq = new AtomicInteger();
    private Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public int addMasterKey(String s) {
        int keySeq = this.masterKeySeq.getAndIncrement();
        LOG.trace("addMasterKey: s = {}, keySeq = {}", (Object)s, (Object)keySeq);
        this.masterKeys.put(keySeq, s);
        return keySeq;
    }

    @Override
    public void updateMasterKey(int keySeq, String s) {
        LOG.trace("updateMasterKey: s = {}, keySeq = {}", (Object)s, (Object)keySeq);
        this.masterKeys.put(keySeq, s);
    }

    @Override
    public boolean removeMasterKey(int keySeq) {
        LOG.trace("removeMasterKey: keySeq = {}", (Object)keySeq);
        return this.masterKeys.remove(keySeq) != null;
    }

    @Override
    public String[] getMasterKeys() {
        return this.masterKeys.values().toArray(new String[0]);
    }

    @Override
    public boolean addToken(DelegationTokenIdentifier tokenIdentifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation token) {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo = this.tokens.putIfAbsent(tokenIdentifier, token);
        LOG.trace("addToken: tokenIdentifier = {}, added = {}", (Object)tokenIdentifier, (Object)(tokenInfo == null ? 1 : 0));
        return tokenInfo == null;
    }

    @Override
    public boolean removeToken(DelegationTokenIdentifier tokenIdentifier) {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo = this.tokens.remove((Object)tokenIdentifier);
        LOG.trace("removeToken: tokenIdentifier = {}, removed = ", (Object)tokenIdentifier, (Object)(tokenInfo != null ? 1 : 0));
        return tokenInfo != null;
    }

    @Override
    public AbstractDelegationTokenSecretManager.DelegationTokenInformation getToken(DelegationTokenIdentifier tokenIdentifier) {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation result = this.tokens.get((Object)tokenIdentifier);
        LOG.trace("getToken: tokenIdentifier = {}, result = {}", (Object)tokenIdentifier, (Object)result);
        return result;
    }

    @Override
    public List<DelegationTokenIdentifier> getAllDelegationTokenIdentifiers() {
        return new ArrayList<DelegationTokenIdentifier>(this.tokens.keySet());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void init(Object hmsHandler, HadoopThriftAuthBridge.Server.ServerMode smode) throws DelegationTokenStore.TokenStoreException {
    }
}

