/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.io.Text;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.FileFormatException;
import org.apache.orc.FileMetadata;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.OrcUtils;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.StripeInformation;
import org.apache.orc.StripeStatistics;
import org.apache.orc.TypeDescription;
import org.apache.orc.UnknownFormatException;
import org.apache.orc.impl.BufferChunk;
import org.apache.orc.impl.ColumnStatisticsImpl;
import org.apache.orc.impl.InStream;
import org.apache.orc.impl.OrcCodecPool;
import org.apache.orc.impl.OrcTail;
import org.apache.orc.impl.RecordReaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderImpl
implements Reader {
    private static final Logger LOG = LoggerFactory.getLogger(ReaderImpl.class);
    private static final int DIRECTORY_SIZE_GUESS = 16384;
    protected final FileSystem fileSystem;
    private final long maxLength;
    protected final Path path;
    protected final CompressionKind compressionKind;
    protected int bufferSize;
    protected OrcProto.Metadata metadata;
    private List<OrcProto.StripeStatistics> stripeStats;
    private final int metadataSize;
    protected final List<OrcProto.Type> types;
    private TypeDescription schema;
    private final List<OrcProto.UserMetadataItem> userMetadata;
    private final List<OrcProto.ColumnStatistics> fileStats;
    private final List<StripeInformation> stripes;
    protected final int rowIndexStride;
    private final long contentLength;
    private final long numberOfRows;
    private long deserializedSize = -1L;
    protected final Configuration conf;
    private final List<Integer> versionList;
    private final OrcFile.WriterVersion writerVersion;
    protected OrcTail tail;

    @Override
    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    @Override
    public List<String> getMetadataKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (OrcProto.UserMetadataItem item : this.userMetadata) {
            result.add(item.getName());
        }
        return result;
    }

    @Override
    public ByteBuffer getMetadataValue(String key) {
        for (OrcProto.UserMetadataItem item : this.userMetadata) {
            if (!item.hasName() || !item.getName().equals(key)) continue;
            return item.getValue().asReadOnlyByteBuffer();
        }
        throw new IllegalArgumentException("Can't find user metadata " + key);
    }

    @Override
    public boolean hasMetadataValue(String key) {
        for (OrcProto.UserMetadataItem item : this.userMetadata) {
            if (!item.hasName() || !item.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    @Override
    public int getCompressionSize() {
        return this.bufferSize;
    }

    @Override
    public List<StripeInformation> getStripes() {
        return this.stripes;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public List<OrcProto.Type> getTypes() {
        return this.types;
    }

    public static OrcFile.Version getFileVersion(List<Integer> versionList) {
        if (versionList == null || versionList.isEmpty()) {
            return OrcFile.Version.V_0_11;
        }
        for (OrcFile.Version version : OrcFile.Version.values()) {
            if (version.getMajor() != versionList.get(0).intValue() || version.getMinor() != versionList.get(1).intValue()) continue;
            return version;
        }
        return OrcFile.Version.FUTURE;
    }

    @Override
    public OrcFile.Version getFileVersion() {
        return ReaderImpl.getFileVersion(this.versionList);
    }

    @Override
    public OrcFile.WriterVersion getWriterVersion() {
        return this.writerVersion;
    }

    @Override
    public OrcProto.FileTail getFileTail() {
        return this.tail.getFileTail();
    }

    @Override
    public int getRowIndexStride() {
        return this.rowIndexStride;
    }

    @Override
    public ColumnStatistics[] getStatistics() {
        return ReaderImpl.deserializeStats(this.fileStats);
    }

    static ColumnStatistics[] deserializeStats(List<OrcProto.ColumnStatistics> fileStats) {
        ColumnStatistics[] result = new ColumnStatistics[fileStats.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ColumnStatisticsImpl.deserialize(fileStats.get(i));
        }
        return result;
    }

    @Override
    public TypeDescription getSchema() {
        return this.schema;
    }

    protected static void ensureOrcFooter(FSDataInputStream in, Path path, int psLen, ByteBuffer buffer) throws IOException {
        int magicLength = "ORC".length();
        int fullLength = magicLength + 1;
        if (psLen < fullLength || buffer.remaining() < fullLength) {
            throw new FileFormatException("Malformed ORC file " + path + ". Invalid postscript length " + psLen);
        }
        int offset = buffer.arrayOffset() + buffer.position() + buffer.limit() - fullLength;
        byte[] array = buffer.array();
        if (!Text.decode((byte[])array, (int)offset, (int)magicLength).equals("ORC")) {
            byte[] header = new byte[magicLength];
            in.readFully(0L, header, 0, magicLength);
            if (!Text.decode((byte[])header, (int)0, (int)magicLength).equals("ORC")) {
                throw new FileFormatException("Malformed ORC file " + path + ". Invalid postscript.");
            }
        }
    }

    protected static void ensureOrcFooter(ByteBuffer buffer, int psLen) throws IOException {
        int magicLength = "ORC".length();
        int fullLength = magicLength + 1;
        if (psLen < fullLength || buffer.remaining() < fullLength) {
            throw new FileFormatException("Malformed ORC file. Invalid postscript length " + psLen);
        }
        int offset = buffer.arrayOffset() + buffer.position() + buffer.limit() - fullLength;
        byte[] array = buffer.array();
        if (!Text.decode((byte[])array, (int)offset, (int)magicLength).equals("ORC") && !Text.decode((byte[])buffer.array(), (int)0, (int)magicLength).equals("ORC")) {
            throw new FileFormatException("Malformed ORC file. Invalid postscript length " + psLen);
        }
    }

    private static String versionString(List<Integer> version) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < version.size(); ++i) {
            if (i != 0) {
                buffer.append('.');
            }
            buffer.append(version.get(i));
        }
        return buffer.toString();
    }

    protected static void checkOrcVersion(Path path, OrcProto.PostScript postscript) throws IOException {
        List<Integer> version = postscript.getVersionList();
        if (ReaderImpl.getFileVersion(version) == OrcFile.Version.FUTURE) {
            throw new UnknownFormatException(path, ReaderImpl.versionString(version), postscript);
        }
    }

    public ReaderImpl(Path path, OrcFile.ReaderOptions options) throws IOException {
        FileSystem fs = options.getFilesystem();
        if (fs == null) {
            fs = path.getFileSystem(options.getConfiguration());
        }
        this.fileSystem = fs;
        this.path = path;
        this.conf = options.getConfiguration();
        this.maxLength = options.getMaxLength();
        FileMetadata fileMetadata = options.getFileMetadata();
        if (fileMetadata != null) {
            this.compressionKind = fileMetadata.getCompressionKind();
            this.bufferSize = fileMetadata.getCompressionBufferSize();
            this.metadataSize = fileMetadata.getMetadataSize();
            this.stripeStats = fileMetadata.getStripeStats();
            this.versionList = fileMetadata.getVersionList();
            this.writerVersion = OrcFile.WriterVersion.from(fileMetadata.getWriterVersionNum());
            this.types = fileMetadata.getTypes();
            this.rowIndexStride = fileMetadata.getRowIndexStride();
            this.contentLength = fileMetadata.getContentLength();
            this.numberOfRows = fileMetadata.getNumberOfRows();
            this.fileStats = fileMetadata.getFileStats();
            this.stripes = fileMetadata.getStripes();
            this.userMetadata = null;
        } else {
            OrcTail orcTail = options.getOrcTail();
            if (orcTail == null) {
                this.tail = this.extractFileTail(fs, path, options.getMaxLength());
                options.orcTail(this.tail);
            } else {
                ReaderImpl.checkOrcVersion(path, orcTail.getPostScript());
                this.tail = orcTail;
            }
            this.compressionKind = this.tail.getCompressionKind();
            this.bufferSize = this.tail.getCompressionBufferSize();
            this.metadataSize = this.tail.getMetadataSize();
            this.versionList = this.tail.getPostScript().getVersionList();
            this.types = this.tail.getFooter().getTypesList();
            this.rowIndexStride = this.tail.getFooter().getRowIndexStride();
            this.contentLength = this.tail.getFooter().getContentLength();
            this.numberOfRows = this.tail.getFooter().getNumberOfRows();
            this.userMetadata = this.tail.getFooter().getMetadataList();
            this.fileStats = this.tail.getFooter().getStatisticsList();
            this.writerVersion = this.tail.getWriterVersion();
            this.stripes = this.tail.getStripes();
            this.stripeStats = this.tail.getStripeStatisticsProto();
        }
        this.schema = OrcUtils.convertTypeFromProtobuf(this.types, 0);
    }

    public static OrcFile.WriterVersion getWriterVersion(int writerVersion) {
        for (OrcFile.WriterVersion version : OrcFile.WriterVersion.values()) {
            if (version.getId() != writerVersion) continue;
            return version;
        }
        return OrcFile.WriterVersion.FUTURE;
    }

    static List<DiskRange> singleton(DiskRange item) {
        ArrayList<DiskRange> result = new ArrayList<DiskRange>();
        result.add(item);
        return result;
    }

    private static OrcProto.Footer extractFooter(ByteBuffer bb, int footerAbsPos, int footerSize, CompressionCodec codec, int bufferSize) throws IOException {
        bb.position(footerAbsPos);
        bb.limit(footerAbsPos + footerSize);
        return OrcProto.Footer.parseFrom(InStream.createCodedInputStream("footer", ReaderImpl.singleton(new BufferChunk(bb, 0L)), footerSize, codec, bufferSize));
    }

    public static OrcProto.Metadata extractMetadata(ByteBuffer bb, int metadataAbsPos, int metadataSize, CompressionCodec codec, int bufferSize) throws IOException {
        bb.position(metadataAbsPos);
        bb.limit(metadataAbsPos + metadataSize);
        return OrcProto.Metadata.parseFrom(InStream.createCodedInputStream("metadata", ReaderImpl.singleton(new BufferChunk(bb, 0L)), metadataSize, codec, bufferSize));
    }

    private static OrcProto.PostScript extractPostScript(ByteBuffer bb, Path path, int psLen, int psAbsOffset) throws IOException {
        assert (bb.hasArray());
        CodedInputStream in = CodedInputStream.newInstance(bb.array(), bb.arrayOffset() + psAbsOffset, psLen);
        OrcProto.PostScript ps = OrcProto.PostScript.parseFrom(in);
        ReaderImpl.checkOrcVersion(path, ps);
        switch (ps.getCompression()) {
            case NONE: 
            case ZLIB: 
            case SNAPPY: 
            case LZO: 
            case LZ4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compression");
            }
        }
        return ps;
    }

    public static OrcTail extractFileTail(ByteBuffer buffer) throws IOException {
        return ReaderImpl.extractFileTail(buffer, -1L, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrcTail extractFileTail(ByteBuffer buffer, long fileLength, long modificationTime) throws IOException {
        OrcProto.FileTail.Builder fileTailBuilder;
        int readSize = buffer.limit();
        int psLen = buffer.get(readSize - 1) & 0xFF;
        int psOffset = readSize - 1 - psLen;
        ReaderImpl.ensureOrcFooter(buffer, psLen);
        byte[] psBuffer = new byte[psLen];
        System.arraycopy(buffer.array(), psOffset, psBuffer, 0, psLen);
        OrcProto.PostScript ps = OrcProto.PostScript.parseFrom(psBuffer);
        int footerSize = (int)ps.getFooterLength();
        CompressionKind kind = CompressionKind.valueOf(ps.getCompression().name());
        CompressionCodec codec = OrcCodecPool.getCodec(kind);
        try {
            OrcProto.Footer footer = ReaderImpl.extractFooter(buffer, (int)((long)buffer.position() + ps.getMetadataLength()), footerSize, codec, (int)ps.getCompressionBlockSize());
            fileTailBuilder = OrcProto.FileTail.newBuilder().setPostscriptLength(psLen).setPostscript(ps).setFooter(footer).setFileLength(fileLength);
        }
        finally {
            OrcCodecPool.returnCodec(kind, codec);
        }
        buffer.clear();
        return new OrcTail(fileTailBuilder.build(), buffer.slice(), modificationTime);
    }

    OrcTail buildEmptyTail() {
        OrcProto.PostScript.Builder postscript = OrcProto.PostScript.newBuilder();
        OrcFile.Version version = OrcFile.Version.CURRENT;
        postscript.setMagic("ORC").setCompression(OrcProto.CompressionKind.NONE).setFooterLength(0L).addVersion(version.getMajor()).addVersion(version.getMinor()).setMetadataLength(0L).setWriterVersion(OrcFile.CURRENT_WRITER.getId());
        OrcProto.Type.Builder struct = OrcProto.Type.newBuilder();
        struct.setKind(OrcProto.Type.Kind.STRUCT);
        OrcProto.Footer.Builder footer = OrcProto.Footer.newBuilder();
        footer.setHeaderLength(0L).setContentLength(0L).addTypes(struct).setNumberOfRows(0L).setRowIndexStride(0);
        OrcProto.FileTail.Builder result = OrcProto.FileTail.newBuilder();
        result.setFooter(footer);
        result.setPostscript(postscript);
        result.setFileLength(0L);
        result.setPostscriptLength(0L);
        return new OrcTail(result.build(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OrcTail extractFileTail(FileSystem fs, Path path, long maxFileLength) throws IOException {
        ByteBuffer buffer;
        long modificationTime;
        FSDataInputStream file = fs.open(path);
        OrcProto.FileTail.Builder fileTailBuilder = OrcProto.FileTail.newBuilder();
        try {
            OrcProto.Footer footer;
            long size;
            Object fileStatus;
            if (maxFileLength == Long.MAX_VALUE) {
                fileStatus = fs.getFileStatus(path);
                size = fileStatus.getLen();
                modificationTime = fileStatus.getModificationTime();
            } else {
                size = maxFileLength;
                modificationTime = -1L;
            }
            if (size == 0L) {
                fileStatus = this.buildEmptyTail();
                return fileStatus;
            }
            if (size <= (long)"ORC".length()) {
                throw new FileFormatException("Not a valid ORC file " + path + " (maxFileLength= " + maxFileLength + ")");
            }
            fileTailBuilder.setFileLength(size);
            int readSize = (int)Math.min(size, 16384L);
            buffer = ByteBuffer.allocate(readSize);
            assert (buffer.position() == 0);
            file.readFully(size - (long)readSize, buffer.array(), buffer.arrayOffset(), readSize);
            buffer.position(0);
            int psLen = buffer.get(readSize - 1) & 0xFF;
            ReaderImpl.ensureOrcFooter(file, path, psLen, buffer);
            int psOffset = readSize - 1 - psLen;
            OrcProto.PostScript ps = ReaderImpl.extractPostScript(buffer, path, psLen, psOffset);
            this.bufferSize = (int)ps.getCompressionBlockSize();
            CompressionKind compressionKind = CompressionKind.valueOf(ps.getCompression().name());
            fileTailBuilder.setPostscriptLength(psLen).setPostscript(ps);
            int footerSize = (int)ps.getFooterLength();
            int metadataSize = (int)ps.getMetadataLength();
            int extra = Math.max(0, psLen + 1 + footerSize + metadataSize - readSize);
            int tailSize = 1 + psLen + footerSize + metadataSize;
            if (extra > 0) {
                ByteBuffer extraBuf = ByteBuffer.allocate(extra + readSize);
                file.readFully(size - (long)readSize - (long)extra, extraBuf.array(), extraBuf.arrayOffset() + extraBuf.position(), extra);
                extraBuf.position(extra);
                extraBuf.put(buffer);
                buffer = extraBuf;
                buffer.position(0);
                buffer.limit(tailSize);
                psOffset = (readSize += extra) - 1 - psLen;
            } else {
                buffer.position(psOffset - footerSize - metadataSize);
                buffer.limit(buffer.position() + tailSize);
            }
            buffer.mark();
            int footerOffset = psOffset - footerSize;
            buffer.position(footerOffset);
            ByteBuffer footerBuffer = buffer.slice();
            buffer.reset();
            CompressionCodec codec = OrcCodecPool.getCodec(compressionKind);
            try {
                footer = ReaderImpl.extractFooter(footerBuffer, 0, footerSize, codec, this.bufferSize);
            }
            finally {
                OrcCodecPool.returnCodec(compressionKind, codec);
            }
            fileTailBuilder.setFooter(footer);
        }
        finally {
            try {
                file.close();
            }
            catch (IOException ex) {
                LOG.error("Failed to close the file after another error", ex);
            }
        }
        ByteBuffer serializedTail = ByteBuffer.allocate(buffer.remaining());
        serializedTail.put(buffer.slice());
        serializedTail.rewind();
        return new OrcTail(fileTailBuilder.build(), serializedTail, modificationTime);
    }

    @Override
    public ByteBuffer getSerializedFileFooter() {
        return this.tail.getSerializedTail();
    }

    @Override
    public Reader.Options options() {
        return new Reader.Options(this.conf);
    }

    @Override
    public RecordReader rows() throws IOException {
        return this.rows(this.options());
    }

    @Override
    public RecordReader rows(Reader.Options options) throws IOException {
        LOG.info("Reading ORC rows from " + this.path + " with " + options);
        return new RecordReaderImpl(this, options);
    }

    @Override
    public long getRawDataSize() {
        if (this.deserializedSize == -1L) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int i = 0; i < this.fileStats.size(); ++i) {
                indices.add(i);
            }
            this.deserializedSize = this.getRawDataSizeFromColIndices(indices);
        }
        return this.deserializedSize;
    }

    @Override
    public long getRawDataSizeFromColIndices(List<Integer> colIndices) {
        return ReaderImpl.getRawDataSizeFromColIndices(colIndices, this.types, this.fileStats);
    }

    public static long getRawDataSizeFromColIndices(List<Integer> colIndices, List<OrcProto.Type> types, List<OrcProto.ColumnStatistics> stats) {
        long result = 0L;
        for (int colIdx : colIndices) {
            result += ReaderImpl.getRawDataSizeOfColumn(colIdx, types, stats);
        }
        return result;
    }

    private static long getRawDataSizeOfColumn(int colIdx, List<OrcProto.Type> types, List<OrcProto.ColumnStatistics> stats) {
        OrcProto.ColumnStatistics colStat = stats.get(colIdx);
        long numVals = colStat.getNumberOfValues();
        OrcProto.Type type = types.get(colIdx);
        switch (type.getKind()) {
            case BINARY: {
                return colStat.getBinaryStatistics().getSum();
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                numVals = numVals == 0L ? 1L : numVals;
                int avgStrLen = (int)(colStat.getStringStatistics().getSum() / numVals);
                return numVals * (long)JavaDataModel.get().lengthForStringOfLength(avgStrLen);
            }
            case TIMESTAMP: {
                return numVals * (long)JavaDataModel.get().lengthOfTimestamp();
            }
            case DATE: {
                return numVals * (long)JavaDataModel.get().lengthOfDate();
            }
            case DECIMAL: {
                return numVals * (long)JavaDataModel.get().lengthOfDecimal();
            }
            case DOUBLE: 
            case LONG: {
                return numVals * (long)JavaDataModel.get().primitive2();
            }
            case FLOAT: 
            case INT: 
            case SHORT: 
            case BOOLEAN: 
            case BYTE: {
                return numVals * (long)JavaDataModel.get().primitive1();
            }
        }
        LOG.debug("Unknown primitive category: " + type.getKind());
        return 0L;
    }

    @Override
    public long getRawDataSizeOfColumns(List<String> colNames) {
        List<Integer> colIndices = this.getColumnIndicesFromNames(colNames);
        return this.getRawDataSizeFromColIndices(colIndices);
    }

    private List<Integer> getColumnIndicesFromNames(List<String> colNames) {
        OrcProto.Type type = this.types.get(0);
        ArrayList<Integer> colIndices = new ArrayList<Integer>();
        List<String> fieldNames = type.getFieldNamesList();
        for (String colName : colNames) {
            if (!fieldNames.contains(colName)) {
                StringBuilder s = new StringBuilder("Cannot find field for: ");
                s.append(colName);
                s.append(" in ");
                for (String fn : fieldNames) {
                    s.append(fn);
                    s.append(", ");
                }
                LOG.warn(s.toString());
                continue;
            }
            int fieldIdx = fieldNames.indexOf(colName);
            int idxStart = type.getSubtypes(fieldIdx);
            int idxEnd = fieldIdx + 1 > fieldNames.size() - 1 ? this.getLastIdx() + 1 : type.getSubtypes(fieldIdx + 1);
            if (idxStart == idxEnd) {
                colIndices.add(idxStart);
                continue;
            }
            for (int i = idxStart; i < idxEnd; ++i) {
                colIndices.add(i);
            }
        }
        return colIndices;
    }

    private int getLastIdx() {
        HashSet<Integer> indices = new HashSet<Integer>();
        for (OrcProto.Type type : this.types) {
            indices.addAll(type.getSubtypesList());
        }
        return (Integer)Collections.max(indices);
    }

    @Override
    public List<OrcProto.StripeStatistics> getOrcProtoStripeStatistics() {
        return this.stripeStats;
    }

    @Override
    public List<OrcProto.ColumnStatistics> getOrcProtoFileStatistics() {
        return this.fileStats;
    }

    @Override
    public List<StripeStatistics> getStripeStatistics() throws IOException {
        if (this.metadata == null) {
            CompressionCodec codec = OrcCodecPool.getCodec(this.compressionKind);
            try {
                this.metadata = ReaderImpl.extractMetadata(this.tail.getSerializedTail(), 0, this.metadataSize, codec, this.bufferSize);
            }
            finally {
                OrcCodecPool.returnCodec(this.compressionKind, codec);
            }
        }
        if (this.stripeStats == null) {
            this.stripeStats = this.metadata.getStripeStatsList();
        }
        ArrayList<StripeStatistics> result = new ArrayList<StripeStatistics>();
        for (OrcProto.StripeStatistics ss : this.stripeStats) {
            result.add(new StripeStatistics(ss.getColStatsList()));
        }
        return result;
    }

    public List<OrcProto.UserMetadataItem> getOrcProtoUserMetadata() {
        return this.userMetadata;
    }

    @Override
    public List<Integer> getVersionList() {
        return this.versionList;
    }

    @Override
    public int getMetadataSize() {
        return this.metadataSize;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ORC Reader(");
        buffer.append(this.path);
        if (this.maxLength != -1L) {
            buffer.append(", ");
            buffer.append(this.maxLength);
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static class StripeInformationImpl
    implements StripeInformation {
        private final OrcProto.StripeInformation stripe;

        public StripeInformationImpl(OrcProto.StripeInformation stripe) {
            this.stripe = stripe;
        }

        @Override
        public long getOffset() {
            return this.stripe.getOffset();
        }

        @Override
        public long getLength() {
            return this.stripe.getDataLength() + this.getIndexLength() + this.getFooterLength();
        }

        @Override
        public long getDataLength() {
            return this.stripe.getDataLength();
        }

        @Override
        public long getFooterLength() {
            return this.stripe.getFooterLength();
        }

        @Override
        public long getIndexLength() {
            return this.stripe.getIndexLength();
        }

        @Override
        public long getNumberOfRows() {
            return this.stripe.getNumberOfRows();
        }

        public String toString() {
            return "offset: " + this.getOffset() + " data: " + this.getDataLength() + " rows: " + this.getNumberOfRows() + " tail: " + this.getFooterLength() + " index: " + this.getIndexLength();
        }
    }
}

