/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.events.PreAddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.hadoop.hive.metastore.events.PreDropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreDropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreDropTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.metastore.events.PreReadDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreReadTableEvent;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.HiveMetastoreAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveMetastoreAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveMultiPartitionAuthorizationProviderBase;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hive.com.google.common.base.Function;
import org.apache.hive.com.google.common.collect.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AuthorizationPreEventListener
extends MetaStorePreEventListener {
    public static final Logger LOG = LoggerFactory.getLogger(AuthorizationPreEventListener.class);
    private static final ThreadLocal<Configuration> tConfig = new ThreadLocal<Configuration>(){

        @Override
        protected Configuration initialValue() {
            return new HiveConf(AuthorizationPreEventListener.class);
        }
    };
    private static final ThreadLocal<HiveMetastoreAuthenticationProvider> tAuthenticator = new ThreadLocal<HiveMetastoreAuthenticationProvider>(){

        @Override
        protected HiveMetastoreAuthenticationProvider initialValue() {
            try {
                return (HiveMetastoreAuthenticationProvider)HiveUtils.getAuthenticator((Configuration)tConfig.get(), HiveConf.ConfVars.HIVE_METASTORE_AUTHENTICATOR_MANAGER);
            }
            catch (HiveException he) {
                throw new IllegalStateException("Authentication provider instantiation failure", he);
            }
        }
    };
    private static final ThreadLocal<List<HiveMetastoreAuthorizationProvider>> tAuthorizers = new ThreadLocal<List<HiveMetastoreAuthorizationProvider>>(){

        @Override
        protected List<HiveMetastoreAuthorizationProvider> initialValue() {
            try {
                return HiveUtils.getMetaStoreAuthorizeProviderManagers((Configuration)tConfig.get(), HiveConf.ConfVars.HIVE_METASTORE_AUTHORIZATION_MANAGER, (HiveAuthenticationProvider)tAuthenticator.get());
            }
            catch (HiveException he) {
                throw new IllegalStateException("Authorization provider instantiation failure", he);
            }
        }
    };
    private static final ThreadLocal<Boolean> tConfigSetOnAuths = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public AuthorizationPreEventListener(Configuration config) throws HiveException {
        super(config);
    }

    @Override
    public void onEvent(PreEventContext context) throws MetaException, NoSuchObjectException, InvalidOperationException {
        if (!tConfigSetOnAuths.get().booleanValue()) {
            tConfig.set(context.getHandler().getConf());
            tAuthenticator.get().setConf(tConfig.get());
            for (HiveMetastoreAuthorizationProvider authorizer : tAuthorizers.get()) {
                authorizer.setConf(tConfig.get());
            }
            tConfigSetOnAuths.set(true);
        }
        tAuthenticator.get().setMetaStoreHandler(context.getHandler());
        for (HiveMetastoreAuthorizationProvider authorizer : tAuthorizers.get()) {
            authorizer.setMetaStoreHandler(context.getHandler());
        }
        switch (context.getEventType()) {
            case CREATE_TABLE: {
                this.authorizeCreateTable((PreCreateTableEvent)context);
                break;
            }
            case DROP_TABLE: {
                this.authorizeDropTable((PreDropTableEvent)context);
                break;
            }
            case ALTER_TABLE: {
                this.authorizeAlterTable((PreAlterTableEvent)context);
                break;
            }
            case READ_TABLE: {
                this.authorizeReadTable((PreReadTableEvent)context);
                break;
            }
            case READ_DATABASE: {
                this.authorizeReadDatabase((PreReadDatabaseEvent)context);
                break;
            }
            case ADD_PARTITION: {
                this.authorizeAddPartition((PreAddPartitionEvent)context);
                break;
            }
            case DROP_PARTITION: {
                this.authorizeDropPartition((PreDropPartitionEvent)context);
                break;
            }
            case ALTER_PARTITION: {
                this.authorizeAlterPartition((PreAlterPartitionEvent)context);
                break;
            }
            case CREATE_DATABASE: {
                this.authorizeCreateDatabase((PreCreateDatabaseEvent)context);
                break;
            }
            case DROP_DATABASE: {
                this.authorizeDropDatabase((PreDropDatabaseEvent)context);
                break;
            }
            case LOAD_PARTITION_DONE: {
                break;
            }
            case AUTHORIZATION_API_CALL: {
                this.authorizeAuthorizationAPICall();
            }
        }
    }

    private void authorizeReadTable(PreReadTableEvent context) throws InvalidOperationException, MetaException {
        if (!this.isReadAuthzEnabled()) {
            return;
        }
        try {
            TableWrapper wrappedTable = new TableWrapper(context.getTable());
            for (HiveMetastoreAuthorizationProvider authorizer : tAuthorizers.get()) {
                authorizer.authorize(wrappedTable, new Privilege[]{Privilege.SELECT}, null);
            }
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeReadDatabase(PreReadDatabaseEvent context) throws InvalidOperationException, MetaException {
        if (!this.isReadAuthzEnabled()) {
            return;
        }
        try {
            for (HiveMetastoreAuthorizationProvider authorizer : tAuthorizers.get()) {
                authorizer.authorize(new Database(context.getDatabase()), new Privilege[]{Privilege.SELECT}, null);
            }
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private boolean isReadAuthzEnabled() {
        return tConfig.get().getBoolean(HiveConf.ConfVars.HIVE_METASTORE_AUTHORIZATION_AUTH_READS.varname, true);
    }

    private void authorizeAuthorizationAPICall() throws InvalidOperationException, MetaException {
        for (HiveMetastoreAuthorizationProvider authorizer : tAuthorizers.get()) {
            try {
                authorizer.authorizeAuthorizationApiInvocation();
            }
            catch (AuthorizationException e) {
                throw this.invalidOperationException(e);
            }
            catch (HiveException e) {
                throw this.metaException(e);
            }
        }
    }

    private void authorizeCreateDatabase(PreCreateDatabaseEvent context) throws InvalidOperationException, MetaException {
        try {
            for (HiveMetastoreAuthorizationProvider authorizer : tAuthorizers.get()) {
                authorizer.authorize(new Database(context.getDatabase()), HiveOperation.CREATEDATABASE.getInputRequiredPrivileges(), HiveOperation.CREATEDATABASE.getOutputRequiredPrivileges());
            }
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeDropDatabase(PreDropDatabaseEvent context) throws InvalidOperationException, MetaException {
        try {
            for (HiveMetastoreAuthorizationProvider authorizer : tAuthorizers.get()) {
                authorizer.authorize(new Database(context.getDatabase()), HiveOperation.DROPDATABASE.getInputRequiredPrivileges(), HiveOperation.DROPDATABASE.getOutputRequiredPrivileges());
            }
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeCreateTable(PreCreateTableEvent context) throws InvalidOperationException, MetaException {
        try {
            TableWrapper wrappedTable = new TableWrapper(context.getTable());
            for (HiveMetastoreAuthorizationProvider authorizer : tAuthorizers.get()) {
                authorizer.authorize(wrappedTable, HiveOperation.CREATETABLE.getInputRequiredPrivileges(), HiveOperation.CREATETABLE.getOutputRequiredPrivileges());
            }
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeDropTable(PreDropTableEvent context) throws InvalidOperationException, MetaException {
        try {
            TableWrapper wrappedTable = new TableWrapper(context.getTable());
            for (HiveMetastoreAuthorizationProvider authorizer : tAuthorizers.get()) {
                authorizer.authorize(wrappedTable, HiveOperation.DROPTABLE.getInputRequiredPrivileges(), HiveOperation.DROPTABLE.getOutputRequiredPrivileges());
            }
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeAlterTable(PreAlterTableEvent context) throws InvalidOperationException, MetaException {
        try {
            TableWrapper wrappedTable = new TableWrapper(context.getOldTable());
            for (HiveMetastoreAuthorizationProvider authorizer : tAuthorizers.get()) {
                authorizer.authorize(wrappedTable, null, new Privilege[]{Privilege.ALTER_METADATA});
            }
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeAddPartition(PreAddPartitionEvent context) throws InvalidOperationException, MetaException {
        try {
            for (org.apache.hadoop.hive.metastore.api.Partition mapiPart : context.getPartitions()) {
                PartitionWrapper wrappedPartiton = new PartitionWrapper(mapiPart, context);
                for (HiveMetastoreAuthorizationProvider authorizer : tAuthorizers.get()) {
                    authorizer.authorize(wrappedPartiton, HiveOperation.ALTERTABLE_ADDPARTS.getInputRequiredPrivileges(), HiveOperation.ALTERTABLE_ADDPARTS.getOutputRequiredPrivileges());
                }
            }
        }
        catch (NoSuchObjectException | AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeDropMultiPartition(HiveMultiPartitionAuthorizationProviderBase authorizer, PreDropPartitionEvent context) throws AuthorizationException, HiveException {
        Iterator<org.apache.hadoop.hive.metastore.api.Partition> partitionIterator = context.getPartitionIterator();
        final TableWrapper table = new TableWrapper(context.getTable());
        final Iterator<Partition> qlPartitionIterator = Iterators.transform(partitionIterator, new Function<org.apache.hadoop.hive.metastore.api.Partition, Partition>(){

            @Override
            public Partition apply(org.apache.hadoop.hive.metastore.api.Partition partition) {
                try {
                    return new PartitionWrapper(table, partition);
                }
                catch (Exception exception) {
                    LOG.error("Could not construct partition-object for: " + partition, exception);
                    throw new RuntimeException(exception);
                }
            }
        });
        authorizer.authorize(new TableWrapper(context.getTable()), new Iterable<Partition>(){

            @Override
            public Iterator<Partition> iterator() {
                return qlPartitionIterator;
            }
        }, HiveOperation.ALTERTABLE_DROPPARTS.getInputRequiredPrivileges(), HiveOperation.ALTERTABLE_DROPPARTS.getOutputRequiredPrivileges());
    }

    private void authorizeDropPartition(PreDropPartitionEvent context) throws InvalidOperationException, MetaException {
        try {
            for (HiveMetastoreAuthorizationProvider authorizer : tAuthorizers.get()) {
                if (authorizer instanceof HiveMultiPartitionAuthorizationProviderBase) {
                    this.authorizeDropMultiPartition((HiveMultiPartitionAuthorizationProviderBase)((Object)authorizer), context);
                    continue;
                }
                TableWrapper table = new TableWrapper(context.getTable());
                Iterator<org.apache.hadoop.hive.metastore.api.Partition> partitionIterator = context.getPartitionIterator();
                while (partitionIterator.hasNext()) {
                    authorizer.authorize(new PartitionWrapper(table, partitionIterator.next()), HiveOperation.ALTERTABLE_DROPPARTS.getInputRequiredPrivileges(), HiveOperation.ALTERTABLE_DROPPARTS.getOutputRequiredPrivileges());
                }
            }
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeAlterPartition(PreAlterPartitionEvent context) throws InvalidOperationException, MetaException {
        try {
            org.apache.hadoop.hive.metastore.api.Partition mapiPart = context.getNewPartition();
            PartitionWrapper wrappedPartition = new PartitionWrapper(mapiPart, context);
            for (HiveMetastoreAuthorizationProvider authorizer : tAuthorizers.get()) {
                authorizer.authorize(wrappedPartition, null, new Privilege[]{Privilege.ALTER_METADATA});
            }
        }
        catch (NoSuchObjectException | AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private InvalidOperationException invalidOperationException(Exception e) {
        InvalidOperationException ex = new InvalidOperationException(e.getMessage());
        ex.initCause(e.getCause());
        return ex;
    }

    private MetaException metaException(HiveException e) {
        MetaException ex = new MetaException(e.getMessage());
        ex.initCause(e);
        return ex;
    }

    public static class PartitionWrapper
    extends Partition {
        public PartitionWrapper(Table table, org.apache.hadoop.hive.metastore.api.Partition mapiPart) throws HiveException {
            this.initialize(table, mapiPart);
        }

        public PartitionWrapper(org.apache.hadoop.hive.metastore.api.Partition mapiPart, PreEventContext context) throws HiveException, NoSuchObjectException, MetaException {
            org.apache.hadoop.hive.metastore.api.Partition wrapperApiPart = mapiPart.deepCopy();
            org.apache.hadoop.hive.metastore.api.Table t = context.getHandler().get_table_core(mapiPart.getDbName(), mapiPart.getTableName());
            if (wrapperApiPart.getSd() == null) {
                wrapperApiPart.setSd(t.getSd().deepCopy());
            }
            this.initialize(new TableWrapper(t), wrapperApiPart);
        }
    }

    public static class TableWrapper
    extends Table {
        public TableWrapper(org.apache.hadoop.hive.metastore.api.Table apiTable) {
            org.apache.hadoop.hive.metastore.api.Table wrapperApiTable = apiTable.deepCopy();
            if (wrapperApiTable.getTableType() == null) {
                if (MetaStoreUtils.isExternalTable(wrapperApiTable)) {
                    wrapperApiTable.setTableType(TableType.EXTERNAL_TABLE.toString());
                } else if (MetaStoreUtils.isIndexTable(wrapperApiTable)) {
                    wrapperApiTable.setTableType(TableType.INDEX_TABLE.toString());
                } else if (MetaStoreUtils.isMaterializedViewTable(wrapperApiTable)) {
                    wrapperApiTable.setTableType(TableType.MATERIALIZED_VIEW.toString());
                } else if (wrapperApiTable.getSd() == null || wrapperApiTable.getSd().getLocation() == null) {
                    wrapperApiTable.setTableType(TableType.VIRTUAL_VIEW.toString());
                } else {
                    wrapperApiTable.setTableType(TableType.MANAGED_TABLE.toString());
                }
            }
            this.initialize(wrapperApiTable);
        }
    }
}

