/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;

public class HiveRelBuilder
extends RelBuilder {
    private HiveRelBuilder(Context context, RelOptCluster cluster, RelOptSchema relOptSchema) {
        super(context, cluster, relOptSchema);
    }

    public static RelBuilder create(FrameworkConfig config) {
        final RelOptCluster[] clusters = new RelOptCluster[]{null};
        final RelOptSchema[] relOptSchemas = new RelOptSchema[]{null};
        Frameworks.withPrepare(new Frameworks.PrepareAction<Void>(config){

            @Override
            public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, CalciteServerStatement statement) {
                clusters[0] = cluster;
                relOptSchemas[0] = relOptSchema;
                return null;
            }
        });
        return new HiveRelBuilder(config.getContext(), clusters[0], relOptSchemas[0]);
    }

    public static RelBuilderFactory proto(final Context context) {
        return new RelBuilderFactory(){

            @Override
            public RelBuilder create(RelOptCluster cluster, RelOptSchema schema) {
                return new HiveRelBuilder(context, cluster, schema);
            }
        };
    }

    public static RelBuilderFactory proto(Object ... factories) {
        return HiveRelBuilder.proto(Contexts.of(factories));
    }

    @Override
    public RelBuilder filter(Iterable<? extends RexNode> predicates) {
        RexNode x = RexUtil.simplify(this.cluster.getRexBuilder(), RexUtil.composeConjunction(this.cluster.getRexBuilder(), predicates, false));
        if (!x.isAlwaysTrue()) {
            RelNode input = this.build();
            RelNode filter = HiveRelFactories.HIVE_FILTER_FACTORY.createFilter(input, x);
            return this.push(filter);
        }
        return this;
    }

    @Override
    public RelBuilder empty() {
        RelNode input = this.build();
        RelNode sort = HiveRelFactories.HIVE_SORT_FACTORY.createSort(input, RelCollations.of(new RelFieldCollation[0]), null, this.literal(0));
        return this.push(sort);
    }
}

