/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSchema;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveVolcanoPlanner;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.joda.time.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveMaterializedViewsRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMaterializedViewsRegistry.class);
    private static final HiveMaterializedViewsRegistry SINGLETON = new HiveMaterializedViewsRegistry();
    private final ConcurrentMap<String, ConcurrentMap<ViewKey, RelOptMaterialization>> materializedViews = new ConcurrentHashMap<String, ConcurrentMap<ViewKey, RelOptMaterialization>>();
    private final ExecutorService pool = Executors.newCachedThreadPool();

    private HiveMaterializedViewsRegistry() {
    }

    public static HiveMaterializedViewsRegistry get() {
        return SINGLETON;
    }

    public void init(Hive db) {
        try {
            ArrayList<Table> tables = new ArrayList<Table>();
            for (String dbName : db.getAllDatabases()) {
                tables.addAll(db.getAllTableObjects(dbName));
            }
            this.pool.submit(new Loader(tables));
        }
        catch (HiveException e) {
            LOG.error("Problem connecting to the metastore when initializing the view registry");
        }
    }

    public RelOptMaterialization addMaterializedView(Table materializedViewTable) {
        ViewKey vk;
        if (!materializedViewTable.isRewriteEnabled()) {
            return null;
        }
        ConcurrentMap<ViewKey, RelOptMaterialization> cq = new ConcurrentHashMap();
        ConcurrentMap prevCq = this.materializedViews.putIfAbsent(materializedViewTable.getDbName(), cq);
        if (prevCq != null) {
            cq = prevCq;
        }
        if (cq.containsKey(vk = new ViewKey(materializedViewTable.getTableName(), materializedViewTable.getCreateTime()))) {
            return null;
        }
        String viewQuery = materializedViewTable.getViewOriginalText();
        RelNode tableRel = HiveMaterializedViewsRegistry.createTableScan(materializedViewTable);
        if (tableRel == null) {
            LOG.warn("Materialized view " + materializedViewTable.getCompleteName() + " ignored; error creating view replacement");
            return null;
        }
        RelNode queryRel = HiveMaterializedViewsRegistry.parseQuery(viewQuery);
        if (queryRel == null) {
            LOG.warn("Materialized view " + materializedViewTable.getCompleteName() + " ignored; error parsing original query");
            return null;
        }
        RelOptMaterialization materialization = new RelOptMaterialization(tableRel, queryRel, null);
        cq.put(vk, materialization);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cached materialized view for rewriting: " + tableRel.getTable().getQualifiedName());
        }
        return materialization;
    }

    public void dropMaterializedView(Table materializedViewTable) {
        if (!materializedViewTable.isRewriteEnabled()) {
            return;
        }
        ViewKey vk = new ViewKey(materializedViewTable.getTableName(), materializedViewTable.getCreateTime());
        ((ConcurrentMap)this.materializedViews.get(materializedViewTable.getDbName())).remove(vk);
    }

    Collection<RelOptMaterialization> getRewritingMaterializedViews(String dbName) {
        if (this.materializedViews.get(dbName) != null) {
            return Collections.unmodifiableCollection(((ConcurrentMap)this.materializedViews.get(dbName)).values());
        }
        return ImmutableList.of();
    }

    private static RelNode createTableScan(Table viewTable) {
        AbstractRelNode tableRel;
        RelDataType rowType;
        ColumnInfo colInfo;
        String colName;
        StructObjectInspector rowObjectInspector;
        RelOptPlanner planner = HiveVolcanoPlanner.createPlanner(null);
        RexBuilder rexBuilder = new RexBuilder(new JavaTypeFactoryImpl());
        RelOptCluster cluster = RelOptCluster.create(planner, rexBuilder);
        RowResolver rr = new RowResolver();
        try {
            rowObjectInspector = (StructObjectInspector)viewTable.getDeserializer().getObjectInspector();
        }
        catch (SerDeException e) {
            return null;
        }
        List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
        ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
        for (int i = 0; i < fields.size(); ++i) {
            colName = fields.get(i).getFieldName();
            colInfo = new ColumnInfo(fields.get(i).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()), null, false);
            rr.put(null, colName, colInfo);
            cInfoLst.add(colInfo);
        }
        ArrayList<ColumnInfo> nonPartitionColumns = new ArrayList<ColumnInfo>(cInfoLst);
        ArrayList<ColumnInfo> partitionColumns = new ArrayList<ColumnInfo>();
        for (FieldSchema part_col : viewTable.getPartCols()) {
            colName = part_col.getName();
            colInfo = new ColumnInfo(colName, TypeInfoFactory.getPrimitiveTypeInfo(part_col.getType()), null, true);
            rr.put(null, colName, colInfo);
            cInfoLst.add(colInfo);
            partitionColumns.add(colInfo);
        }
        try {
            rowType = TypeConverter.getType(cluster, rr, null);
        }
        catch (CalciteSemanticException e) {
            return null;
        }
        String fullyQualifiedTabName = viewTable.getDbName();
        fullyQualifiedTabName = fullyQualifiedTabName != null && !fullyQualifiedTabName.isEmpty() ? fullyQualifiedTabName + "." + viewTable.getTableName() : viewTable.getTableName();
        RelOptHiveTable optTable = new RelOptHiveTable(null, fullyQualifiedTabName, rowType, viewTable, nonPartitionColumns, partitionColumns, new ArrayList<VirtualColumn>(), SessionState.get().getConf(), new HashMap<String, PrunedPartitionList>(), new AtomicInteger());
        if (HiveMaterializedViewsRegistry.obtainTableType(viewTable) == TableType.DRUID) {
            String address = HiveConf.getVar(SessionState.get().getConf(), HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
            String dataSource = viewTable.getParameters().get("druid.datasource");
            HashSet<String> metrics = new HashSet<String>();
            ArrayList<RelDataType> druidColTypes = new ArrayList<RelDataType>();
            ArrayList<String> druidColNames = new ArrayList<String>();
            for (RelDataTypeField field : rowType.getFieldList()) {
                druidColTypes.add(field.getType());
                druidColNames.add(field.getName());
                if (field.getName().equals("__time") || field.getType().getSqlTypeName() == SqlTypeName.VARCHAR) continue;
                metrics.add(field.getName());
            }
            List<Interval> intervals = Arrays.asList(DruidTable.DEFAULT_INTERVAL);
            DruidTable druidTable = new DruidTable(new DruidSchema(address, address, false), dataSource, RelDataTypeImpl.proto(rowType), metrics, "__time", intervals);
            HiveTableScan scan = new HiveTableScan(cluster, cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, viewTable.getTableName(), null, false, false);
            tableRel = DruidQuery.create(cluster, cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, druidTable, ImmutableList.of(scan));
        } else {
            tableRel = new HiveTableScan(cluster, cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, viewTable.getTableName(), null, false, false);
        }
        return tableRel;
    }

    private static RelNode parseQuery(String viewQuery) {
        try {
            ASTNode node = ParseUtils.parse(viewQuery);
            QueryState qs = new QueryState(SessionState.get().getConf());
            CalcitePlanner analyzer = new CalcitePlanner(qs);
            analyzer.initCtx(new Context(SessionState.get().getConf()));
            analyzer.init(false);
            return analyzer.genLogicalPlan(node);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static TableType obtainTableType(Table tabMetaData) {
        if (tabMetaData.getStorageHandler() != null && tabMetaData.getStorageHandler().toString().equals("org.apache.hadoop.hive.druid.DruidStorageHandler")) {
            return TableType.DRUID;
        }
        return TableType.NATIVE;
    }

    private static enum TableType {
        DRUID,
        NATIVE;

    }

    private static class ViewKey {
        private String viewName;
        private int creationDate;

        private ViewKey(String viewName, int creationTime) {
            this.viewName = viewName;
            this.creationDate = creationTime;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ViewKey viewKey = (ViewKey)obj;
            return this.creationDate == viewKey.creationDate && (this.viewName == viewKey.viewName || this.viewName != null && this.viewName.equals(viewKey.viewName));
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + this.creationDate;
            hash = 31 * hash + this.viewName.hashCode();
            return hash;
        }

        public String toString() {
            return "ViewKey{" + this.viewName + "," + this.creationDate + "}";
        }
    }

    private class Loader
    implements Runnable {
        private final List<Table> tables;

        private Loader(List<Table> tables) {
            this.tables = tables;
        }

        @Override
        public void run() {
            for (Table table : this.tables) {
                if (!table.isMaterializedView()) continue;
                HiveMaterializedViewsRegistry.this.addMaterializedView(table);
            }
        }
    }
}

