/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.ql.io.orc.ExternalCache;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class MetastoreExternalCachesByConf
implements ExternalCache.ExternalFooterCachesByConf {
    @Override
    public ExternalCache.ExternalFooterCachesByConf.Cache getCache(HiveConf conf) throws IOException {
        try {
            return new HBaseCache(Hive.getWithFastCheck(conf));
        }
        catch (HiveException e) {
            throw new IOException(e);
        }
    }

    public static class HBaseCache
    implements ExternalCache.ExternalFooterCachesByConf.Cache {
        private Hive hive;

        public HBaseCache(Hive hive) {
            this.hive = hive;
        }

        @Override
        public Iterator<Map.Entry<Long, MetadataPpdResult>> getFileMetadataByExpr(List<Long> fileIds, ByteBuffer sarg, boolean doGetFooters) throws HiveException {
            return this.hive.getFileMetadataByExpr(fileIds, sarg, doGetFooters).iterator();
        }

        @Override
        public void clearFileMetadata(List<Long> fileIds) throws HiveException {
            this.hive.clearFileMetadata(fileIds);
        }

        @Override
        public Iterator<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> fileIds) throws HiveException {
            return this.hive.getFileMetadata(fileIds).iterator();
        }

        @Override
        public void putFileMetadata(ArrayList<Long> fileIds, ArrayList<ByteBuffer> metadata) throws HiveException {
            this.hive.putFileMetadata(fileIds, metadata);
        }
    }
}

