/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.keyseries;

import org.apache.hadoop.hive.ql.exec.vector.keyseries.VectorKeySeriesSerialized;
import org.apache.hadoop.hive.ql.exec.vector.keyseries.VectorKeySeriesSingleImpl;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.common.util.HashCodeUtil;

public abstract class VectorKeySeriesSerializedImpl<T extends SerializeWrite>
extends VectorKeySeriesSingleImpl
implements VectorKeySeriesSerialized {
    protected T serializeWrite;
    protected int bufferOffset;
    public int serializedStart;
    public int serializedLength;
    public byte[] serializedBytes;
    protected final ByteStream.Output output;
    protected final int[] serializedKeyLengths;

    public VectorKeySeriesSerializedImpl(T serializeWrite) {
        this.serializeWrite = serializeWrite;
        this.output = new ByteStream.Output();
        this.serializedKeyLengths = new int[1024];
    }

    @Override
    public boolean validate() {
        super.validate();
        int nullCount = 0;
        for (int i = 0; i < this.seriesCount; ++i) {
            if (!this.seriesIsAllNull[i]) continue;
            ++nullCount;
        }
        Preconditions.checkState(nullCount + this.nonNullKeyCount == this.seriesCount);
        int lengthSum = 0;
        for (int i = 0; i < this.nonNullKeyCount; ++i) {
            int keyLength = this.serializedKeyLengths[i];
            Preconditions.checkState(keyLength > 0);
            Preconditions.checkState((lengthSum += keyLength) <= this.output.getLength());
        }
        return true;
    }

    @Override
    public byte[] getSerializedBytes() {
        return this.serializedBytes;
    }

    @Override
    public int getSerializedStart() {
        return this.serializedStart;
    }

    @Override
    public int getSerializedLength() {
        return this.serializedLength;
    }

    protected void computeSerializedHashCodes() {
        int offset = 0;
        byte[] bytes = this.output.getData();
        for (int i = 0; i < this.nonNullKeyCount; ++i) {
            int keyLength = this.serializedKeyLengths[i];
            this.hashCodes[i] = HashCodeUtil.murmurHash(bytes, offset, keyLength);
            offset += keyLength;
        }
    }

    @Override
    public void positionToFirst() {
        this.bufferOffset = 0;
        super.positionToFirst();
        this.serializedBytes = this.output.getData();
    }

    @Override
    public void setNextNonNullKey(int nonNullKeyPosition) {
        this.serializedStart = this.bufferOffset;
        this.serializedLength = this.serializedKeyLengths[nonNullKeyPosition];
        Preconditions.checkState(this.serializedStart + this.serializedLength <= this.output.getData().length);
        this.bufferOffset += this.serializedLength;
    }
}

