/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.util.Util;
import org.apache.hive.com.google.common.collect.ImmutableList;

public class CompositeSingleOperandTypeChecker
extends CompositeOperandTypeChecker
implements SqlSingleOperandTypeChecker {
    CompositeSingleOperandTypeChecker(CompositeOperandTypeChecker.Composition composition, ImmutableList<? extends SqlSingleOperandTypeChecker> allowedRules, String allowedSignatures) {
        super(composition, allowedRules, allowedSignatures, null);
    }

    public ImmutableList<? extends SqlSingleOperandTypeChecker> getRules() {
        return this.allowedRules;
    }

    @Override
    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
        boolean ret;
        assert (this.allowedRules.size() >= 1);
        ImmutableList<? extends SqlSingleOperandTypeChecker> rules = this.getRules();
        if (this.composition == CompositeOperandTypeChecker.Composition.SEQUENCE) {
            return ((SqlSingleOperandTypeChecker)rules.get(iFormalOperand)).checkSingleOperandType(callBinding, node, 0, throwOnFailure);
        }
        int typeErrorCount = 0;
        boolean throwOnAndFailure = this.composition == CompositeOperandTypeChecker.Composition.AND && throwOnFailure;
        for (SqlSingleOperandTypeChecker sqlSingleOperandTypeChecker : rules) {
            if (sqlSingleOperandTypeChecker.checkSingleOperandType(callBinding, node, iFormalOperand, throwOnAndFailure)) continue;
            ++typeErrorCount;
        }
        switch (this.composition) {
            case AND: {
                ret = typeErrorCount == 0;
                break;
            }
            case OR: {
                ret = typeErrorCount < this.allowedRules.size();
                break;
            }
            default: {
                throw Util.unexpected(this.composition);
            }
        }
        if (!ret && throwOnFailure) {
            for (SqlSingleOperandTypeChecker sqlSingleOperandTypeChecker : rules) {
                sqlSingleOperandTypeChecker.checkSingleOperandType(callBinding, node, iFormalOperand, true);
            }
            throw callBinding.newValidationSignatureError();
        }
        return ret;
    }
}

