/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.hive.com.google.common.base.Predicate;
import org.apache.hive.com.google.common.collect.ImmutableList;

public abstract class FilterTableScanRule
extends RelOptRule {
    public static final Predicate<TableScan> PREDICATE = new Predicate<TableScan>(){

        @Override
        public boolean apply(TableScan scan) {
            RelOptTable table = scan.getTable();
            return table.unwrap(FilterableTable.class) != null || table.unwrap(ProjectableFilterableTable.class) != null;
        }
    };
    public static final FilterTableScanRule INSTANCE = new FilterTableScanRule(FilterTableScanRule.operand(Filter.class, FilterTableScanRule.operand(TableScan.class, null, PREDICATE, FilterTableScanRule.none()), new RelOptRuleOperand[0]), "FilterTableRule"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            TableScan scan = (TableScan)call.rel(1);
            this.apply(call, filter, scan);
        }
    };
    public static final FilterTableScanRule INTERPRETER = new FilterTableScanRule(FilterTableScanRule.operand(Filter.class, FilterTableScanRule.operand(EnumerableInterpreter.class, FilterTableScanRule.operand(TableScan.class, null, PREDICATE, FilterTableScanRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "FilterTableRule:interpreter"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            TableScan scan = (TableScan)call.rel(2);
            this.apply(call, filter, scan);
        }
    };

    protected FilterTableScanRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    protected void apply(RelOptRuleCall call, Filter filter, TableScan scan) {
        ImmutableIntList projects;
        ImmutableList.Builder filters = ImmutableList.builder();
        if (scan instanceof Bindables.BindableTableScan) {
            Bindables.BindableTableScan bindableScan = (Bindables.BindableTableScan)scan;
            filters.addAll(bindableScan.filters);
            projects = bindableScan.projects;
        } else {
            projects = scan.identity();
        }
        Mapping mapping = Mappings.target(projects, scan.getTable().getRowType().getFieldCount());
        filters.add(RexUtil.apply((Mappings.TargetMapping)mapping, filter.getCondition()));
        call.transformTo(Bindables.BindableTableScan.create(scan.getCluster(), scan.getTable(), (List<RexNode>)((Object)filters.build()), projects));
    }
}

