/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.plan.CopyWork;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Copy for Replication", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ReplCopyWork
extends CopyWork {
    protected boolean copyFiles = true;
    protected boolean listFilesOnOutput = false;
    protected boolean readListFromInput = false;

    public ReplCopyWork() {
    }

    public ReplCopyWork(Path fromPath, Path toPath) {
        super(fromPath, toPath, true);
    }

    public ReplCopyWork(Path fromPath, Path toPath, boolean errorOnSrcEmpty) {
        super(fromPath, toPath, errorOnSrcEmpty);
    }

    public void setListFilesOnOutputBehaviour(boolean listFilesOnOutput) {
        this.listFilesOnOutput = listFilesOnOutput;
    }

    public boolean getListFilesOnOutputBehaviour() {
        return this.listFilesOnOutput;
    }

    public void setReadListFromInput(boolean readListFromInput) {
        this.readListFromInput = readListFromInput;
    }

    public boolean getReadListFromInput() {
        return this.readListFromInput;
    }

    public boolean getListFilesOnOutputBehaviour(FileStatus f) {
        if (f.getPath().toString().contains("_metadata")) {
            return false;
        }
        return this.listFilesOnOutput;
    }
}

