/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputSignature {
    private final String name;
    private final ArrayList<TypeInfo> typeArray;
    private static final Logger LOG = LoggerFactory.getLogger(InputSignature.class.getName());

    public InputSignature(String name) {
        this.name = name;
        this.typeArray = new ArrayList();
    }

    public InputSignature(String name, TypeInfo ... classList) {
        this(name);
        if (classList.length != 0) {
            for (TypeInfo cl : classList) {
                this.typeArray.add(cl);
            }
        }
    }

    public InputSignature(String name, Class<?> ... classList) {
        this(name);
        if (classList.length != 0) {
            for (Class<?> cl : classList) {
                this.typeArray.add(TypeInfoFactory.getPrimitiveTypeInfoFromPrimitiveWritable(cl));
            }
        }
    }

    public void add(TypeInfo paramType) {
        this.typeArray.add(paramType);
    }

    public String getName() {
        return this.name.toUpperCase();
    }

    public ArrayList<TypeInfo> getTypeArray() {
        return this.typeArray;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        InputSignature other = null;
        try {
            other = (InputSignature)obj;
        }
        catch (ClassCastException cce) {
            return false;
        }
        return this.name.equalsIgnoreCase(other.getName()) && other.typeArray.equals(this.typeArray);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("(");
        boolean isfirst = true;
        for (TypeInfo cls : this.getTypeArray()) {
            if (!isfirst) {
                sb.append(",");
            }
            sb.append(cls.toString());
            isfirst = false;
        }
        sb.append(")");
        return sb.toString();
    }
}

