/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.sql.Date;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.util.ZonelessDatetime;

public class ZonelessDate
extends ZonelessDatetime {
    private static final long serialVersionUID = -6385775986251759394L;
    protected transient Date tempDate;

    @Override
    public void setZonelessTime(long value) {
        super.setZonelessTime(value);
        this.clearTime();
    }

    @Override
    public void setZonedTime(long value, TimeZone zone) {
        super.setZonedTime(value, zone);
        this.clearTime();
    }

    @Override
    public Object toJdbcObject() {
        return new Date(this.getJdbcDate(DateTimeUtils.DEFAULT_ZONE));
    }

    public String toString() {
        Date jdbcDate = this.getTempDate(this.getJdbcDate(DateTimeUtils.DEFAULT_ZONE));
        return jdbcDate.toString();
    }

    public String toString(String format) {
        DateFormat formatter = this.getFormatter(format);
        Date jdbcDate = this.getTempDate(this.getTime());
        return formatter.format(jdbcDate);
    }

    public static ZonelessDate parse(String s) {
        return ZonelessDate.parse(s, "yyyy-MM-dd");
    }

    public static ZonelessDate parse(String s, String format) {
        Calendar cal = DateTimeUtils.parseDateFormat(s, format, DateTimeUtils.GMT_ZONE);
        if (cal == null) {
            return null;
        }
        ZonelessDate zd = new ZonelessDate();
        zd.setZonelessTime(cal.getTimeInMillis());
        return zd;
    }

    protected Date getTempDate(long value) {
        if (this.tempDate == null) {
            this.tempDate = new Date(value);
        } else {
            this.tempDate.setTime(value);
        }
        return this.tempDate;
    }
}

