/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.hive.com.google.common.base.Throwables;
import org.apache.hive.com.google.common.collect.HashMultimap;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.com.google.common.collect.Multimap;

public abstract class ReflectiveSqlOperatorTable
implements SqlOperatorTable {
    public static final String IS_NAME = "INFORMATION_SCHEMA";
    private final Multimap<Key, SqlOperator> operators = HashMultimap.create();

    protected ReflectiveSqlOperatorTable() {
    }

    public final void init() {
        for (Field field : this.getClass().getFields()) {
            try {
                SqlOperator op;
                if (SqlFunction.class.isAssignableFrom(field.getType())) {
                    op = (SqlFunction)field.get(this);
                    if (op == null) continue;
                    this.register(op);
                    continue;
                }
                if (!SqlOperator.class.isAssignableFrom(field.getType())) continue;
                op = (SqlOperator)field.get(this);
                this.register(op);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw Throwables.propagate(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        String simpleName;
        if (opName.names.size() > 1) {
            if (!((String)opName.names.get(opName.names.size() - 2)).equals(IS_NAME)) return;
            simpleName = Util.last(opName.names);
        } else {
            simpleName = opName.getSimple();
        }
        Collection<SqlOperator> list = this.operators.get(new Key(simpleName, syntax));
        if (list.isEmpty()) {
            return;
        }
        for (SqlOperator op : list) {
            if (op.getSyntax() == syntax) {
                operatorList.add(op);
                continue;
            }
            if (syntax != SqlSyntax.FUNCTION || !(op instanceof SqlFunction)) continue;
            operatorList.add(op);
        }
        switch (syntax) {
            case BINARY: 
            case PREFIX: 
            case POSTFIX: {
                for (SqlOperator extra : this.operators.get(new Key(simpleName, syntax))) {
                    if (extra == null || operatorList.contains(extra)) continue;
                    operatorList.add(extra);
                }
                return;
            }
        }
    }

    public void register(SqlOperator op) {
        this.operators.put(new Key(op.getName(), op.getSyntax()), op);
        if (op instanceof SqlFunction) {
            SqlFunction function = (SqlFunction)op;
            SqlFunctionCategory funcType = function.getFunctionType();
            assert (funcType != null) : "Function type for " + function.getName() + " not set";
        }
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return ImmutableList.copyOf(this.operators.values());
    }

    private static class Key
    extends Pair<String, SqlSyntax> {
        Key(String name, SqlSyntax syntax) {
            super(name.toUpperCase(), Key.normalize(syntax));
        }

        private static SqlSyntax normalize(SqlSyntax syntax) {
            switch (syntax) {
                case BINARY: 
                case PREFIX: 
                case POSTFIX: {
                    return syntax;
                }
            }
            return SqlSyntax.FUNCTION;
        }
    }
}

