/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.com.google.common.collect.ImmutableMap;
import org.apache.hive.com.google.common.collect.Lists;

public final class MultiJoin
extends AbstractRelNode {
    private final List<RelNode> inputs;
    private final RexNode joinFilter;
    private final RelDataType rowType;
    private final boolean isFullOuterJoin;
    private final List<RexNode> outerJoinConditions;
    private final ImmutableList<JoinRelType> joinTypes;
    private final List<ImmutableBitSet> projFields;
    public final ImmutableMap<Integer, ImmutableIntList> joinFieldRefCountsMap;
    private final RexNode postJoinFilter;

    public MultiJoin(RelOptCluster cluster, List<RelNode> inputs, RexNode joinFilter, RelDataType rowType, boolean isFullOuterJoin, List<RexNode> outerJoinConditions, List<JoinRelType> joinTypes, List<ImmutableBitSet> projFields, ImmutableMap<Integer, ImmutableIntList> joinFieldRefCountsMap, RexNode postJoinFilter) {
        super(cluster, cluster.traitSetOf((RelTrait)Convention.NONE));
        this.inputs = Lists.newArrayList(inputs);
        this.joinFilter = joinFilter;
        this.rowType = rowType;
        this.isFullOuterJoin = isFullOuterJoin;
        this.outerJoinConditions = ImmutableNullableList.copyOf(outerJoinConditions);
        assert (outerJoinConditions.size() == inputs.size());
        this.joinTypes = ImmutableList.copyOf(joinTypes);
        this.projFields = ImmutableNullableList.copyOf(projFields);
        this.joinFieldRefCountsMap = joinFieldRefCountsMap;
        this.postJoinFilter = postJoinFilter;
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode p) {
        this.inputs.set(ordinalInParent, p);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new MultiJoin(this.getCluster(), inputs, this.joinFilter, this.rowType, this.isFullOuterJoin, this.outerJoinConditions, this.joinTypes, this.projFields, this.joinFieldRefCountsMap, this.postJoinFilter);
    }

    private Map<Integer, int[]> cloneJoinFieldRefCountsMap() {
        HashMap<Integer, int[]> clonedMap = new HashMap<Integer, int[]>();
        for (int i = 0; i < this.inputs.size(); ++i) {
            clonedMap.put(i, this.joinFieldRefCountsMap.get(i).toIntArray());
        }
        return clonedMap;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        ArrayList<String> joinTypeNames = new ArrayList<String>();
        ArrayList<String> outerJoinConds = new ArrayList<String>();
        ArrayList<String> projFieldObjects = new ArrayList<String>();
        for (int i = 0; i < this.inputs.size(); ++i) {
            joinTypeNames.add(((JoinRelType)((Object)this.joinTypes.get(i))).name());
            if (this.outerJoinConditions.get(i) == null) {
                outerJoinConds.add("NULL");
            } else {
                outerJoinConds.add(this.outerJoinConditions.get(i).toString());
            }
            if (this.projFields.get(i) == null) {
                projFieldObjects.add("ALL");
                continue;
            }
            projFieldObjects.add(this.projFields.get(i).toString());
        }
        super.explainTerms(pw);
        for (Ord<RelNode> ord : Ord.zip(this.inputs)) {
            pw.input("input#" + ord.i, (RelNode)ord.e);
        }
        return pw.item("joinFilter", this.joinFilter).item("isFullOuterJoin", this.isFullOuterJoin).item("joinTypes", joinTypeNames).item("outerJoinConditions", outerJoinConds).item("projFields", projFieldObjects).itemIf("postJoinFilter", this.postJoinFilter, this.postJoinFilter != null);
    }

    @Override
    public RelDataType deriveRowType() {
        return this.rowType;
    }

    @Override
    public List<RelNode> getInputs() {
        return this.inputs;
    }

    @Override
    public List<RexNode> getChildExps() {
        return ImmutableList.of(this.joinFilter);
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        RexNode joinFilter = shuttle.apply(this.joinFilter);
        List<RexNode> outerJoinConditions = shuttle.apply(this.outerJoinConditions);
        RexNode postJoinFilter = shuttle.apply(this.postJoinFilter);
        if (joinFilter == this.joinFilter && outerJoinConditions == this.outerJoinConditions && postJoinFilter == this.postJoinFilter) {
            return this;
        }
        return new MultiJoin(this.getCluster(), this.inputs, joinFilter, this.rowType, this.isFullOuterJoin, outerJoinConditions, this.joinTypes, this.projFields, this.joinFieldRefCountsMap, postJoinFilter);
    }

    public RexNode getJoinFilter() {
        return this.joinFilter;
    }

    public boolean isFullOuterJoin() {
        return this.isFullOuterJoin;
    }

    public List<RexNode> getOuterJoinConditions() {
        return this.outerJoinConditions;
    }

    public List<JoinRelType> getJoinTypes() {
        return this.joinTypes;
    }

    public List<ImmutableBitSet> getProjFields() {
        return this.projFields;
    }

    public ImmutableMap<Integer, ImmutableIntList> getJoinFieldRefCountsMap() {
        return this.joinFieldRefCountsMap;
    }

    public Map<Integer, int[]> getCopyJoinFieldRefCountsMap() {
        return this.cloneJoinFieldRefCountsMap();
    }

    public RexNode getPostJoinFilter() {
        return this.postJoinFilter;
    }

    boolean containsOuter() {
        for (JoinRelType joinType : this.joinTypes) {
            if (joinType == JoinRelType.INNER) continue;
            return true;
        }
        return false;
    }
}

