/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ppd;

import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FilterPusher {
    private static final Logger LOG = LoggerFactory.getLogger(FilterPusher.class);
    private final HiveConf hiveConf;
    private final Operator<TableScanDesc> tableScanOperator;
    private final TableScanDesc tableScanDesc;
    private final Table table;

    FilterPusher(HiveConf hiveConf, Operator<TableScanDesc> tableScanOperator) {
        this.hiveConf = hiveConf;
        this.tableScanOperator = tableScanOperator;
        this.tableScanDesc = tableScanOperator.getConf();
        this.table = this.tableScanDesc.getTableMetadata();
    }

    @Nullable
    ExprNodeGenericFuncDesc tryPushing(ExprNodeGenericFuncDesc originalPredicate) {
        if (this.shouldPushToInputFormat() || this.isIndexFilterEnabled()) {
            this.tableScanDesc.setFilterExpr(originalPredicate);
        }
        if (this.shouldPushToStorageHandler()) {
            return this.pushToStorageHandler(originalPredicate);
        }
        return originalPredicate;
    }

    @Nullable
    private ExprNodeGenericFuncDesc pushToStorageHandler(ExprNodeGenericFuncDesc originalPredicate) {
        if (this.isPredicateStorageHandler()) {
            return this.tryPushingDecomposedPredicate(originalPredicate);
        }
        return this.pushOriginalPredicate(originalPredicate);
    }

    @Nullable
    private ExprNodeGenericFuncDesc tryPushingDecomposedPredicate(ExprNodeGenericFuncDesc originalPredicate) {
        HiveStoragePredicateHandler.DecomposedPredicate decomposed = this.decomposePredicate(originalPredicate);
        if (this.canPushDownToStorageHandler(decomposed)) {
            this.logDecomposedPredicate(originalPredicate, decomposed);
            this.setFilterFieldsInTableScanDesc(decomposed);
            return decomposed.residualPredicate;
        }
        this.logPushDownNotPossible(originalPredicate);
        return originalPredicate;
    }

    private ExprNodeGenericFuncDesc pushOriginalPredicate(ExprNodeGenericFuncDesc originalPredicate) {
        this.tableScanDesc.setFilterExpr(originalPredicate);
        return originalPredicate;
    }

    private void setFilterFieldsInTableScanDesc(HiveStoragePredicateHandler.DecomposedPredicate decomposed) {
        this.tableScanDesc.setFilterExpr(decomposed.pushedPredicate);
        this.tableScanDesc.setFilterObject(decomposed.pushedPredicateObject);
    }

    private void logPushDownNotPossible(ExprNodeGenericFuncDesc originalPredicate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("No pushdown possible for predicate: {}", (Object)originalPredicate.getExprString());
        }
    }

    private void logDecomposedPredicate(ExprNodeGenericFuncDesc originalPredicate, HiveStoragePredicateHandler.DecomposedPredicate decomposed) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Original predicate: {}", (Object)originalPredicate.getExprString());
            if (decomposed.pushedPredicate != null) {
                LOG.debug("Pushed predicate: {}", (Object)decomposed.pushedPredicate.getExprString());
            }
            if (decomposed.residualPredicate != null) {
                LOG.debug("Residual predicate: {}", (Object)decomposed.residualPredicate.getExprString());
            }
        }
    }

    @Nullable
    private HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(ExprNodeGenericFuncDesc originalPredicate) {
        JobConf jobConf = this.createJobConfForPredicateHandler();
        Deserializer deserializer = this.table.getDeserializer();
        HiveStoragePredicateHandler predicateHandler = (HiveStoragePredicateHandler)((Object)this.table.getStorageHandler());
        return predicateHandler.decomposePredicate(jobConf, deserializer, originalPredicate);
    }

    private JobConf createJobConfForPredicateHandler() {
        JobConf jobConf = new JobConf((Configuration)this.hiveConf);
        Utilities.setColumnNameList(jobConf, this.tableScanOperator);
        Utilities.setColumnTypeList(jobConf, this.tableScanOperator);
        Utilities.copyTableJobPropertiesToConf(Utilities.getTableDesc(this.table), (Configuration)jobConf);
        return jobConf;
    }

    private boolean isPredicateStorageHandler() {
        return this.table.getStorageHandler() instanceof HiveStoragePredicateHandler;
    }

    private boolean isIndexFilterEnabled() {
        return this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVEOPTINDEXFILTER);
    }

    private boolean shouldPushToInputFormat() {
        if (this.table.isNonNative()) {
            return false;
        }
        Collection pushDownInputFormats = this.hiveConf.getStringCollection(HiveConf.ConfVars.HIVEOPTPUSHDOWNINPUTFORMATS.varname);
        return this.isTableInputFormatAssignableToAnyClass(pushDownInputFormats);
    }

    private boolean isTableInputFormatAssignableToAnyClass(Collection<String> pushDownInputFormats) {
        for (String pushDownInputFormat : pushDownInputFormats) {
            if (!this.isTableInputFormatAssignableToClass(pushDownInputFormat)) continue;
            return true;
        }
        return false;
    }

    private boolean isTableInputFormatAssignableToClass(String pushDownInputFormat) {
        try {
            Class<? extends InputFormat> pushDownInputFormatClass = this.loadClassWithoutInitialization(pushDownInputFormat);
            if (pushDownInputFormatClass.isAssignableFrom(this.table.getInputFormatClass())) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Pushing predicate enabled input format class: {} was not found.", (Object)pushDownInputFormat, (Object)e);
        }
        return false;
    }

    private boolean shouldPushToStorageHandler() {
        return this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVEOPTPPD_STORAGE) && this.table.isNonNative();
    }

    private boolean canPushDownToStorageHandler(HiveStoragePredicateHandler.DecomposedPredicate decomposed) {
        return decomposed != null;
    }

    private Class<?> loadClassWithoutInitialization(String className) throws ClassNotFoundException {
        return JavaUtils.loadClass(className, false);
    }
}

