/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.optimizer.physical.Vectorizer;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorExplainVectorization;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorGroupByDesc;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hive.common.util.AnnotationUtils;

@Explain(displayName="Group By Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class GroupByDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private Mode mode;
    private boolean bucketGroup;
    private ArrayList<ExprNodeDesc> keys;
    private List<Integer> listGroupingSets;
    private boolean groupingSetsPresent;
    private int groupingSetPosition = -1;
    private ArrayList<AggregationDesc> aggregators;
    private ArrayList<String> outputColumnNames;
    private float groupByMemoryUsage;
    private float memoryThreshold;
    private transient boolean isDistinct;
    private boolean dontResetAggrsDistinct;

    public GroupByDesc() {
        this.vectorDesc = new VectorGroupByDesc();
    }

    public GroupByDesc(Mode mode, ArrayList<String> outputColumnNames, ArrayList<ExprNodeDesc> keys, ArrayList<AggregationDesc> aggregators, float groupByMemoryUsage, float memoryThreshold, List<Integer> listGroupingSets, boolean groupingSetsPresent, int groupingSetsPosition, boolean isDistinct) {
        this(mode, outputColumnNames, keys, aggregators, false, groupByMemoryUsage, memoryThreshold, listGroupingSets, groupingSetsPresent, groupingSetsPosition, isDistinct);
    }

    public GroupByDesc(Mode mode, ArrayList<String> outputColumnNames, ArrayList<ExprNodeDesc> keys, ArrayList<AggregationDesc> aggregators, boolean bucketGroup, float groupByMemoryUsage, float memoryThreshold, List<Integer> listGroupingSets, boolean groupingSetsPresent, int groupingSetsPosition, boolean isDistinct) {
        this.vectorDesc = new VectorGroupByDesc();
        this.mode = mode;
        this.outputColumnNames = outputColumnNames;
        this.keys = keys;
        this.aggregators = aggregators;
        this.bucketGroup = bucketGroup;
        this.groupByMemoryUsage = groupByMemoryUsage;
        this.memoryThreshold = memoryThreshold;
        this.listGroupingSets = listGroupingSets;
        this.groupingSetsPresent = groupingSetsPresent;
        this.groupingSetPosition = groupingSetsPosition;
        this.isDistinct = isDistinct;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Explain(displayName="mode")
    public String getModeString() {
        switch (this.mode) {
            case COMPLETE: {
                return "complete";
            }
            case PARTIAL1: {
                return "partial1";
            }
            case PARTIAL2: {
                return "partial2";
            }
            case PARTIALS: {
                return "partials";
            }
            case HASH: {
                return "hash";
            }
            case FINAL: {
                return "final";
            }
            case MERGEPARTIAL: {
                return "mergepartial";
            }
        }
        return "unknown";
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Explain(displayName="keys")
    public String getKeyString() {
        return PlanUtils.getExprListString(this.keys);
    }

    @Explain(displayName="keys", explainLevels={Explain.Level.USER})
    public String getUserLevelExplainKeyString() {
        return PlanUtils.getExprListString(this.keys, true);
    }

    public ArrayList<ExprNodeDesc> getKeys() {
        return this.keys;
    }

    public void setKeys(ArrayList<ExprNodeDesc> keys) {
        this.keys = keys;
    }

    @Explain(displayName="outputColumnNames")
    public ArrayList<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    @Explain(displayName="Output", explainLevels={Explain.Level.USER})
    public ArrayList<String> getUserLevelExplainOutputColumnNames() {
        return this.outputColumnNames;
    }

    @Explain(displayName="pruneGroupingSetId", displayOnlyOnTrue=true)
    public boolean pruneGroupingSetId() {
        return this.groupingSetPosition >= 0 && this.outputColumnNames.size() != this.keys.size() + this.aggregators.size();
    }

    public void setOutputColumnNames(ArrayList<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    public float getGroupByMemoryUsage() {
        return this.groupByMemoryUsage;
    }

    public void setGroupByMemoryUsage(float groupByMemoryUsage) {
        this.groupByMemoryUsage = groupByMemoryUsage;
    }

    public float getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setMemoryThreshold(float memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    @Explain(displayName="aggregations", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<String> getAggregatorStrings() {
        ArrayList<String> res = new ArrayList<String>();
        for (AggregationDesc agg : this.aggregators) {
            res.add(agg.getExprString());
        }
        return res;
    }

    public ArrayList<AggregationDesc> getAggregators() {
        return this.aggregators;
    }

    public void setAggregators(ArrayList<AggregationDesc> aggregators) {
        this.aggregators = aggregators;
    }

    public boolean isAggregate() {
        return this.aggregators != null && !this.aggregators.isEmpty();
    }

    @Explain(displayName="bucketGroup", displayOnlyOnTrue=true)
    public boolean getBucketGroup() {
        return this.bucketGroup;
    }

    public void setBucketGroup(boolean bucketGroup) {
        this.bucketGroup = bucketGroup;
    }

    public boolean isDistinctLike() {
        ArrayList<AggregationDesc> aggregators = this.getAggregators();
        for (AggregationDesc ad : aggregators) {
            GenericUDAFEvaluator udafEval;
            UDFType annot;
            if (ad.getDistinct() || (annot = AnnotationUtils.getAnnotation((udafEval = ad.getGenericUDAFEvaluator()).getClass(), UDFType.class)) != null && annot.distinctLike()) continue;
            return false;
        }
        return true;
    }

    public List<Integer> getListGroupingSets() {
        return this.listGroupingSets;
    }

    public void setListGroupingSets(List<Integer> listGroupingSets) {
        this.listGroupingSets = listGroupingSets;
    }

    public boolean isGroupingSetsPresent() {
        return this.groupingSetsPresent;
    }

    public void setGroupingSetsPresent(boolean groupingSetsPresent) {
        this.groupingSetsPresent = groupingSetsPresent;
    }

    public int getGroupingSetPosition() {
        return this.groupingSetPosition;
    }

    public void setGroupingSetPosition(int groupingSetPosition) {
        this.groupingSetPosition = groupingSetPosition;
    }

    public boolean isDontResetAggrsDistinct() {
        return this.dontResetAggrsDistinct;
    }

    public void setDontResetAggrsDistinct(boolean dontResetAggrsDistinct) {
        this.dontResetAggrsDistinct = dontResetAggrsDistinct;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public void setDistinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="Group By Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public GroupByOperatorExplainVectorization getGroupByVectorization() {
        if (this.vectorDesc == null) {
            return null;
        }
        return new GroupByOperatorExplainVectorization(this, this.vectorDesc);
    }

    public class GroupByOperatorExplainVectorization
    extends OperatorExplainVectorization {
        private final GroupByDesc groupByDesc;
        private final VectorGroupByDesc vectorGroupByDesc;

        public GroupByOperatorExplainVectorization(GroupByDesc groupByDesc, VectorDesc vectorDesc) {
            super(vectorDesc, false);
            this.groupByDesc = groupByDesc;
            this.vectorGroupByDesc = (VectorGroupByDesc)vectorDesc;
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="keyExpressions", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getKeysExpression() {
            return this.vectorExpressionsToStringList(this.vectorGroupByDesc.getKeyExpressions());
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="aggregators", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getAggregators() {
            VectorAggregateExpression[] vecAggregators = this.vectorGroupByDesc.getAggregators();
            ArrayList<String> vecAggrList = new ArrayList<String>(vecAggregators.length);
            for (VectorAggregateExpression vecAggr : vecAggregators) {
                vecAggrList.add(vecAggr.toString());
            }
            return vecAggrList;
        }

        @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="vectorOutput", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public boolean getGroupByRowOutputCascade() {
            return this.vectorGroupByDesc.isVectorOutput();
        }

        @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="vectorOutputConditionsNotMet", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getVectorOutputConditionsNotMet() {
            VectorAggregateExpression[] vecAggregators;
            ArrayList<String> results = new ArrayList<String>();
            for (VectorAggregateExpression vecAggr : vecAggregators = this.vectorGroupByDesc.getAggregators()) {
                ObjectInspector.Category category = Vectorizer.aggregationOutputCategory(vecAggr);
                if (category == ObjectInspector.Category.PRIMITIVE) continue;
                results.add("Vector output of " + vecAggr.toString() + " output type " + (Object)((Object)category) + " requires PRIMITIVE IS false");
            }
            if (results.size() == 0) {
                return null;
            }
            return results;
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="projectedOutputColumns", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getProjectedOutputColumns() {
            return Arrays.toString(this.vectorGroupByDesc.getProjectedOutputColumns());
        }
    }

    public static enum Mode {
        COMPLETE,
        PARTIAL1,
        PARTIAL2,
        PARTIALS,
        FINAL,
        HASH,
        MERGEPARTIAL;

    }
}

