/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.com.esotericsoftware.kryo.serializers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.hive.com.esotericsoftware.kryo.Kryo;
import org.apache.hive.com.esotericsoftware.kryo.KryoException;
import org.apache.hive.com.esotericsoftware.kryo.KryoSerializable;
import org.apache.hive.com.esotericsoftware.kryo.Registration;
import org.apache.hive.com.esotericsoftware.kryo.Serializer;
import org.apache.hive.com.esotericsoftware.kryo.io.Input;
import org.apache.hive.com.esotericsoftware.kryo.io.Output;
import org.apache.hive.com.esotericsoftware.kryo.serializers.MapSerializer;

public class DefaultSerializers {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TreeMapSerializer
    extends MapSerializer {
        @Override
        public void write(Kryo kryo, Output output, Map map) {
            TreeMap treeMap = (TreeMap)map;
            boolean references = kryo.setReferences(false);
            kryo.writeClassAndObject(output, treeMap.comparator());
            kryo.setReferences(references);
            super.write(kryo, output, map);
        }

        @Override
        protected Map create(Kryo kryo, Input input, Class<Map> type) {
            return new TreeMap((Comparator)kryo.readClassAndObject(input));
        }

        @Override
        protected Map createCopy(Kryo kryo, Map original) {
            return new TreeMap(((TreeMap)original).comparator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CalendarSerializer
    extends Serializer<Calendar> {
        private static final long DEFAULT_GREGORIAN_CUTOVER = -12219292800000L;
        TimeZoneSerializer timeZoneSerializer = new TimeZoneSerializer();

        @Override
        public void write(Kryo kryo, Output output, Calendar object) {
            this.timeZoneSerializer.write(kryo, output, object.getTimeZone());
            output.writeLong(object.getTimeInMillis(), true);
            output.writeBoolean(object.isLenient());
            output.writeInt(object.getFirstDayOfWeek(), true);
            output.writeInt(object.getMinimalDaysInFirstWeek(), true);
            if (object instanceof GregorianCalendar) {
                output.writeLong(((GregorianCalendar)object).getGregorianChange().getTime(), false);
            } else {
                output.writeLong(-12219292800000L, false);
            }
        }

        @Override
        public Calendar read(Kryo kryo, Input input, Class<Calendar> type) {
            Calendar result = Calendar.getInstance((TimeZone)this.timeZoneSerializer.read(kryo, input, (Class)TimeZone.class));
            result.setTimeInMillis(input.readLong(true));
            result.setLenient(input.readBoolean());
            result.setFirstDayOfWeek(input.readInt(true));
            result.setMinimalDaysInFirstWeek(input.readInt(true));
            long gregorianChange = input.readLong(false);
            if (gregorianChange != -12219292800000L && result instanceof GregorianCalendar) {
                ((GregorianCalendar)result).setGregorianChange(new Date(gregorianChange));
            }
            return result;
        }

        @Override
        public Calendar copy(Kryo kryo, Calendar original) {
            return (Calendar)original.clone();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimeZoneSerializer
    extends Serializer<TimeZone> {
        public TimeZoneSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, TimeZone object) {
            output.writeString(object.getID());
        }

        @Override
        public TimeZone read(Kryo kryo, Input input, Class<TimeZone> type) {
            return TimeZone.getTimeZone(input.readString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionsSingletonSetSerializer
    extends Serializer<Set> {
        public CollectionsSingletonSetSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Set object) {
            kryo.writeClassAndObject(output, object.iterator().next());
        }

        @Override
        public Set read(Kryo kryo, Input input, Class type) {
            return Collections.singleton(kryo.readClassAndObject(input));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionsSingletonMapSerializer
    extends Serializer<Map> {
        public CollectionsSingletonMapSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Map object) {
            Map.Entry entry = object.entrySet().iterator().next();
            kryo.writeClassAndObject(output, entry.getKey());
            kryo.writeClassAndObject(output, entry.getValue());
        }

        @Override
        public Map read(Kryo kryo, Input input, Class type) {
            Object key = kryo.readClassAndObject(input);
            Object value = kryo.readClassAndObject(input);
            return Collections.singletonMap(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionsSingletonListSerializer
    extends Serializer<List> {
        public CollectionsSingletonListSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, List object) {
            kryo.writeClassAndObject(output, object.get(0));
        }

        @Override
        public List read(Kryo kryo, Input input, Class type) {
            return Collections.singletonList(kryo.readClassAndObject(input));
        }
    }

    public static class CollectionsEmptySetSerializer
    extends Serializer {
        public CollectionsEmptySetSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input, Class type) {
            return Collections.EMPTY_SET;
        }
    }

    public static class CollectionsEmptyMapSerializer
    extends Serializer {
        public CollectionsEmptyMapSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input, Class type) {
            return Collections.EMPTY_MAP;
        }
    }

    public static class CollectionsEmptyListSerializer
    extends Serializer {
        public CollectionsEmptyListSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input, Class type) {
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KryoSerializableSerializer
    extends Serializer<KryoSerializable> {
        @Override
        public void write(Kryo kryo, Output output, KryoSerializable object) {
            object.write(kryo, output);
        }

        @Override
        public KryoSerializable read(Kryo kryo, Input input, Class<KryoSerializable> type) {
            KryoSerializable object = kryo.newInstance(type);
            kryo.reference(object);
            object.read(kryo, input);
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringBuilderSerializer
    extends Serializer<StringBuilder> {
        public StringBuilderSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, StringBuilder object) {
            output.writeString(object);
        }

        @Override
        public StringBuilder read(Kryo kryo, Input input, Class<StringBuilder> type) {
            return input.readStringBuilder();
        }

        @Override
        public StringBuilder copy(Kryo kryo, StringBuilder original) {
            return new StringBuilder(original);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringBufferSerializer
    extends Serializer<StringBuffer> {
        public StringBufferSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, StringBuffer object) {
            output.writeString(object);
        }

        @Override
        public StringBuffer read(Kryo kryo, Input input, Class<StringBuffer> type) {
            String value = input.readString();
            if (value == null) {
                return null;
            }
            return new StringBuffer(value);
        }

        @Override
        public StringBuffer copy(Kryo kryo, StringBuffer original) {
            return new StringBuffer(original);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CurrencySerializer
    extends Serializer<Currency> {
        public CurrencySerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Currency object) {
            output.writeString(object == null ? null : object.getCurrencyCode());
        }

        @Override
        public Currency read(Kryo kryo, Input input, Class<Currency> type) {
            String currencyCode = input.readString();
            if (currencyCode == null) {
                return null;
            }
            return Currency.getInstance(currencyCode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumSetSerializer
    extends Serializer<EnumSet> {
        @Override
        public void write(Kryo kryo, Output output, EnumSet object) {
            if (object.isEmpty()) {
                throw new KryoException("An empty EnumSet cannot be serialized.");
            }
            Serializer serializer = kryo.writeClass(output, object.iterator().next().getClass()).getSerializer();
            output.writeInt(object.size(), true);
            for (Object element : object) {
                serializer.write(kryo, output, element);
            }
        }

        @Override
        public EnumSet read(Kryo kryo, Input input, Class<EnumSet> type) {
            Registration registration = kryo.readClass(input);
            EnumSet object = EnumSet.noneOf(registration.getType());
            Serializer serializer = registration.getSerializer();
            int length = input.readInt(true);
            for (int i = 0; i < length; ++i) {
                object.add(serializer.read(kryo, input, null));
            }
            return object;
        }

        @Override
        public EnumSet copy(Kryo kryo, EnumSet original) {
            return EnumSet.copyOf(original);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumSerializer
    extends Serializer<Enum> {
        private Object[] enumConstants;

        public EnumSerializer(Class<? extends Enum> type) {
            this.setImmutable(true);
            this.setAcceptsNull(true);
            this.enumConstants = type.getEnumConstants();
            if (this.enumConstants == null) {
                throw new IllegalArgumentException("The type must be an enum: " + type);
            }
        }

        @Override
        public void write(Kryo kryo, Output output, Enum object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(object.ordinal() + 1, true);
        }

        @Override
        public Enum read(Kryo kryo, Input input, Class<Enum> type) {
            int ordinal = input.readInt(true);
            if (ordinal == 0) {
                return null;
            }
            if (--ordinal < 0 || ordinal > this.enumConstants.length - 1) {
                throw new KryoException("Invalid ordinal for enum \"" + type.getName() + "\": " + ordinal);
            }
            Object constant = this.enumConstants[ordinal];
            return (Enum)constant;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateSerializer
    extends Serializer<Date> {
        @Override
        public void write(Kryo kryo, Output output, Date object) {
            output.writeLong(object.getTime(), true);
        }

        @Override
        public Date read(Kryo kryo, Input input, Class<Date> type) {
            return new Date(input.readLong(true));
        }

        @Override
        public Date copy(Kryo kryo, Date original) {
            return new Date(original.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassSerializer
    extends Serializer<Class> {
        public ClassSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Class object) {
            kryo.writeClass(output, object);
        }

        @Override
        public Class read(Kryo kryo, Input input, Class<Class> type) {
            return kryo.readClass(input).getType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigDecimalSerializer
    extends Serializer<BigDecimal> {
        private BigIntegerSerializer bigIntegerSerializer = new BigIntegerSerializer();

        public BigDecimalSerializer() {
            this.setAcceptsNull(true);
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, BigDecimal object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            BigDecimal value = object;
            this.bigIntegerSerializer.write(kryo, output, value.unscaledValue());
            output.writeInt(value.scale(), false);
        }

        @Override
        public BigDecimal read(Kryo kryo, Input input, Class<BigDecimal> type) {
            Object unscaledValue = this.bigIntegerSerializer.read(kryo, input, (Class)null);
            if (unscaledValue == null) {
                return null;
            }
            int scale = input.readInt(false);
            return new BigDecimal((BigInteger)unscaledValue, scale);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigIntegerSerializer
    extends Serializer<BigInteger> {
        public BigIntegerSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, BigInteger object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            BigInteger value = object;
            byte[] bytes = value.toByteArray();
            output.writeInt(bytes.length + 1, true);
            output.writeBytes(bytes);
        }

        @Override
        public BigInteger read(Kryo kryo, Input input, Class<BigInteger> type) {
            int length = input.readInt(true);
            if (length == 0) {
                return null;
            }
            byte[] bytes = input.readBytes(length - 1);
            return new BigInteger(bytes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringSerializer
    extends Serializer<String> {
        public StringSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, String object) {
            output.writeString(object);
        }

        @Override
        public String read(Kryo kryo, Input input, Class<String> type) {
            return input.readString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleSerializer
    extends Serializer<Double> {
        public DoubleSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Double object) {
            output.writeDouble(object);
        }

        @Override
        public Double read(Kryo kryo, Input input, Class<Double> type) {
            return input.readDouble();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatSerializer
    extends Serializer<Float> {
        public FloatSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Float object) {
            output.writeFloat(object.floatValue());
        }

        @Override
        public Float read(Kryo kryo, Input input, Class<Float> type) {
            return Float.valueOf(input.readFloat());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongSerializer
    extends Serializer<Long> {
        public LongSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Long object) {
            output.writeLong(object, false);
        }

        @Override
        public Long read(Kryo kryo, Input input, Class<Long> type) {
            return input.readLong(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntSerializer
    extends Serializer<Integer> {
        public IntSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Integer object) {
            output.writeInt(object, false);
        }

        @Override
        public Integer read(Kryo kryo, Input input, Class<Integer> type) {
            return input.readInt(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShortSerializer
    extends Serializer<Short> {
        public ShortSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Short object) {
            output.writeShort(object.shortValue());
        }

        @Override
        public Short read(Kryo kryo, Input input, Class<Short> type) {
            return input.readShort();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CharSerializer
    extends Serializer<Character> {
        public CharSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Character object) {
            output.writeChar(object.charValue());
        }

        @Override
        public Character read(Kryo kryo, Input input, Class<Character> type) {
            return Character.valueOf(input.readChar());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteSerializer
    extends Serializer<Byte> {
        public ByteSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Byte object) {
            output.writeByte(object);
        }

        @Override
        public Byte read(Kryo kryo, Input input, Class<Byte> type) {
            return input.readByte();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BooleanSerializer
    extends Serializer<Boolean> {
        public BooleanSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Boolean object) {
            output.writeBoolean(object);
        }

        @Override
        public Boolean read(Kryo kryo, Input input, Class<Boolean> type) {
            return input.readBoolean();
        }
    }
}

