/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionTask;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.WindowFunctionInfo;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMacro;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionResolver;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.util.ReflectionUtils;

public class Registry {
    private static final Log LOG = LogFactory.getLog(FunctionRegistry.class);
    private static final String WINDOW_FUNC_PREFIX = "@_";
    private final Map<String, FunctionInfo> mFunctions = new LinkedHashMap<String, FunctionInfo>();
    private final Set<Class<?>> builtIns = Collections.synchronizedSet(new HashSet());
    private final Set<ClassLoader> mSessionUDFLoaders = new LinkedHashSet<ClassLoader>();
    private final boolean isNative;

    Registry(boolean isNative) {
        this.isNative = isNative;
    }

    public Registry() {
        this(false);
    }

    public FunctionInfo registerFunction(String functionName, Class<?> udfClass, FunctionInfo.FunctionResource ... resources) {
        FunctionUtils.UDFClassType udfClassType = FunctionUtils.getUDFClassType(udfClass);
        switch (udfClassType) {
            case UDF: {
                return this.registerUDF(functionName, udfClass, false, resources);
            }
            case GENERIC_UDF: {
                return this.registerGenericUDF(functionName, udfClass, resources);
            }
            case GENERIC_UDTF: {
                return this.registerGenericUDTF(functionName, udfClass, resources);
            }
            case UDAF: {
                return this.registerUDAF(functionName, udfClass, resources);
            }
            case GENERIC_UDAF_RESOLVER: {
                return this.registerGenericUDAF(functionName, (GenericUDAFResolver)ReflectionUtils.newInstance(udfClass, null), resources);
            }
            case TABLE_FUNCTION_RESOLVER: {
                return this.registerTableFunction(functionName, udfClass, resources);
            }
        }
        return null;
    }

    public FunctionInfo registerUDF(String functionName, Class<? extends UDF> UDFClass, boolean isOperator, FunctionInfo.FunctionResource ... resources) {
        return this.registerUDF(functionName, UDFClass, isOperator, functionName.toLowerCase(), resources);
    }

    public FunctionInfo registerUDF(String functionName, Class<? extends UDF> UDFClass, boolean isOperator, String displayName, FunctionInfo.FunctionResource ... resources) {
        this.validateClass(UDFClass, UDF.class);
        FunctionInfo fI = new FunctionInfo(this.isNative, displayName, new GenericUDFBridge(displayName, isOperator, UDFClass.getName()), resources);
        this.addFunction(functionName, fI);
        return fI;
    }

    public FunctionInfo registerGenericUDF(String functionName, Class<? extends GenericUDF> genericUDFClass, FunctionInfo.FunctionResource ... resources) {
        this.validateClass(genericUDFClass, GenericUDF.class);
        FunctionInfo fI = new FunctionInfo(this.isNative, functionName, (GenericUDF)ReflectionUtils.newInstance(genericUDFClass, null), resources);
        this.addFunction(functionName, fI);
        return fI;
    }

    public FunctionInfo registerGenericUDTF(String functionName, Class<? extends GenericUDTF> genericUDTFClass, FunctionInfo.FunctionResource ... resources) {
        this.validateClass(genericUDTFClass, GenericUDTF.class);
        FunctionInfo fI = new FunctionInfo(this.isNative, functionName, (GenericUDTF)ReflectionUtils.newInstance(genericUDTFClass, null), resources);
        this.addFunction(functionName, fI);
        return fI;
    }

    public FunctionInfo registerGenericUDAF(String functionName, GenericUDAFResolver genericUDAFResolver, FunctionInfo.FunctionResource ... resources) {
        WindowFunctionInfo function = new WindowFunctionInfo(this.isNative, functionName, genericUDAFResolver, resources);
        this.addFunction(functionName, function);
        this.addFunction(WINDOW_FUNC_PREFIX + functionName, function);
        return function;
    }

    public FunctionInfo registerUDAF(String functionName, Class<? extends UDAF> udafClass, FunctionInfo.FunctionResource ... resources) {
        this.validateClass(udafClass, UDAF.class);
        WindowFunctionInfo function = new WindowFunctionInfo(this.isNative, functionName, new GenericUDAFBridge((UDAF)ReflectionUtils.newInstance(udafClass, null)), resources);
        this.addFunction(functionName, function);
        this.addFunction(WINDOW_FUNC_PREFIX + functionName, function);
        return function;
    }

    public FunctionInfo registerTableFunction(String functionName, Class<? extends TableFunctionResolver> tFnCls, FunctionInfo.FunctionResource ... resources) {
        this.validateClass(tFnCls, TableFunctionResolver.class);
        FunctionInfo function = new FunctionInfo(this.isNative, functionName, tFnCls, resources);
        this.addFunction(functionName, function);
        return function;
    }

    public FunctionInfo registerMacro(String macroName, ExprNodeDesc body, List<String> colNames, List<TypeInfo> colTypes) {
        return this.registerMacro(macroName, body, colNames, colTypes, null);
    }

    public FunctionInfo registerMacro(String macroName, ExprNodeDesc body, List<String> colNames, List<TypeInfo> colTypes, FunctionInfo.FunctionResource ... resources) {
        GenericUDFMacro macro = new GenericUDFMacro(macroName, body, colNames, colTypes);
        FunctionInfo fI = new FunctionInfo(this.isNative, macroName, macro, resources);
        this.addFunction(macroName, fI);
        return fI;
    }

    public FunctionInfo registerPermanentFunction(String functionName, String className, boolean registerToSession, FunctionInfo.FunctionResource ... resources) {
        String qualifiedName;
        FunctionInfo function = new FunctionInfo(functionName, className, resources);
        if (registerToSession && this.registerToSessionRegistry(qualifiedName = FunctionUtils.qualifyFunctionName(functionName, SessionState.get().getCurrentDatabase().toLowerCase()), function) != null) {
            this.addFunction(functionName, function);
            return function;
        }
        this.addFunction(functionName, function);
        return null;
    }

    void registerWindowFunction(String name, GenericUDAFResolver wFn) {
        this.addFunction(WINDOW_FUNC_PREFIX + name, new WindowFunctionInfo(this.isNative, name, wFn, null));
    }

    private void validateClass(Class input, Class expected) {
        if (!expected.isAssignableFrom(input)) {
            throw new RuntimeException("Registering UDF Class " + input + " which does not extend " + expected);
        }
    }

    public synchronized FunctionInfo getFunctionInfo(String functionName) throws SemanticException {
        if (FunctionUtils.isQualifiedFunctionName(functionName = functionName.toLowerCase())) {
            return this.getQualifiedFunctionInfo(functionName);
        }
        FunctionInfo functionInfo = this.mFunctions.get(functionName);
        if (functionInfo != null && functionInfo.isBlockedFunction()) {
            throw new SemanticException("UDF " + functionName + " is not allowed");
        }
        if (functionInfo == null) {
            String qualifiedName = FunctionUtils.qualifyFunctionName(functionName, SessionState.get().getCurrentDatabase().toLowerCase());
            functionInfo = this.getQualifiedFunctionInfo(qualifiedName);
        }
        return functionInfo;
    }

    public WindowFunctionInfo getWindowFunctionInfo(String functionName) throws SemanticException {
        FunctionInfo info = this.getFunctionInfo(WINDOW_FUNC_PREFIX + functionName);
        if (info instanceof WindowFunctionInfo) {
            return (WindowFunctionInfo)info;
        }
        return null;
    }

    public boolean isBuiltInFunc(Class<?> udfClass) {
        return udfClass != null && this.builtIns.contains(udfClass);
    }

    public synchronized Set<String> getCurrentFunctionNames() {
        return this.getFunctionNames((Pattern)null);
    }

    public synchronized Set<String> getFunctionNames(String funcPatternStr) {
        try {
            return this.getFunctionNames(Pattern.compile(funcPatternStr));
        }
        catch (PatternSyntaxException e) {
            return Collections.emptySet();
        }
    }

    public synchronized Set<String> getFunctionNames(Pattern funcPattern) {
        TreeSet<String> funcNames = new TreeSet<String>();
        for (String funcName : this.mFunctions.keySet()) {
            if (funcName.contains(WINDOW_FUNC_PREFIX) || funcPattern != null && !funcPattern.matcher(funcName).matches()) continue;
            funcNames.add(funcName);
        }
        return funcNames;
    }

    public synchronized void getFunctionSynonyms(String funcName, FunctionInfo funcInfo, Set<String> synonyms) throws SemanticException {
        Class<?> funcClass = funcInfo.getFunctionClass();
        for (Map.Entry<String, FunctionInfo> entry : this.mFunctions.entrySet()) {
            FunctionInfo function;
            String name = entry.getKey();
            if (name.contains(WINDOW_FUNC_PREFIX) || name.equals(funcName) || (function = entry.getValue()).getFunctionClass() != funcClass) continue;
            synonyms.add(name);
        }
    }

    public GenericUDAFEvaluator getGenericUDAFEvaluator(String name, List<ObjectInspector> argumentOIs, boolean isDistinct, boolean isAllColumns) throws SemanticException {
        GenericUDAFResolver udafResolver = this.getGenericUDAFResolver(name);
        if (udafResolver == null) {
            return null;
        }
        ObjectInspector[] args = new ObjectInspector[argumentOIs.size()];
        for (int ii = 0; ii < argumentOIs.size(); ++ii) {
            args[ii] = argumentOIs.get(ii);
        }
        SimpleGenericUDAFParameterInfo paramInfo = new SimpleGenericUDAFParameterInfo(args, isDistinct, isAllColumns);
        GenericUDAFEvaluator udafEvaluator = udafResolver instanceof GenericUDAFResolver2 ? ((GenericUDAFResolver2)udafResolver).getEvaluator(paramInfo) : udafResolver.getEvaluator(paramInfo.getParameters());
        return udafEvaluator;
    }

    public GenericUDAFEvaluator getGenericWindowingEvaluator(String functionName, List<ObjectInspector> argumentOIs, boolean isDistinct, boolean isAllColumns) throws SemanticException {
        WindowFunctionInfo info = this.getWindowFunctionInfo(functionName = functionName.toLowerCase());
        if (info == null) {
            return null;
        }
        if (!functionName.equals("lead") && !functionName.equals("lag")) {
            return this.getGenericUDAFEvaluator(functionName, argumentOIs, isDistinct, isAllColumns);
        }
        ObjectInspector[] args = new ObjectInspector[argumentOIs.size()];
        GenericUDAFResolver udafResolver = info.getGenericUDAFResolver();
        SimpleGenericUDAFParameterInfo paramInfo = new SimpleGenericUDAFParameterInfo(argumentOIs.toArray(args), isDistinct, isAllColumns);
        return ((GenericUDAFResolver2)udafResolver).getEvaluator(paramInfo);
    }

    private synchronized void addFunction(String functionName, FunctionInfo function) {
        if (this.isNative ^ function.isNative()) {
            throw new RuntimeException("Function " + functionName + " is not for this registry");
        }
        FunctionInfo prev = this.mFunctions.get(functionName = functionName.toLowerCase());
        if (prev != null) {
            if (this.isBuiltInFunc(prev.getFunctionClass())) {
                throw new RuntimeException("Function " + functionName + " is hive builtin function, which cannot be overriden.");
            }
            prev.discarded();
        }
        this.mFunctions.put(functionName, function);
        if (function.isBuiltIn()) {
            this.builtIns.add(function.getFunctionClass());
        }
    }

    public synchronized void unregisterFunction(String functionName) throws HiveException {
        FunctionInfo fi = this.mFunctions.get(functionName = functionName.toLowerCase());
        if (fi != null) {
            if (fi.isBuiltIn()) {
                throw new HiveException(ErrorMsg.DROP_NATIVE_FUNCTION.getMsg(functionName));
            }
            this.mFunctions.remove(functionName);
            fi.discarded();
        }
    }

    public GenericUDAFResolver getGenericUDAFResolver(String functionName) throws SemanticException {
        FunctionInfo info = this.getFunctionInfo(functionName);
        if (info != null) {
            return info.getGenericUDAFResolver();
        }
        return null;
    }

    private FunctionInfo getQualifiedFunctionInfo(String qualifiedName) throws SemanticException {
        FunctionInfo info = this.mFunctions.get(qualifiedName);
        if (info != null && info.isBlockedFunction()) {
            throw new SemanticException("UDF " + qualifiedName + " is not allowed");
        }
        if (!this.isNative && info != null && info.isDiscarded()) {
            this.mFunctions.remove(qualifiedName);
            return null;
        }
        if (this.isNative && info != null && info.isPersistent()) {
            return this.registerToSessionRegistry(qualifiedName, info);
        }
        return info;
    }

    private FunctionInfo registerToSessionRegistry(String qualifiedName, FunctionInfo function) {
        FunctionInfo ret = null;
        ClassLoader prev = Utilities.getSessionSpecifiedClassLoader();
        try {
            FunctionInfo.FunctionResource[] resources = function.getResources();
            try {
                FunctionTask.addFunctionResources(resources);
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to load resources for " + qualifiedName + ":" + e), (Throwable)e);
                return null;
            }
            ClassLoader loader = Utilities.getSessionSpecifiedClassLoader();
            Class<?> udfClass = Class.forName(function.getClassName(), true, loader);
            ret = FunctionRegistry.registerTemporaryUDF(qualifiedName, udfClass, resources);
            if (ret == null) {
                LOG.error((Object)(function.getClassName() + " is not a valid UDF class and was not registered."));
            }
            if (SessionState.get().isHiveServerQuery()) {
                SessionState.getRegistryForWrite().addToUDFLoaders(loader);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Unable to load UDF class: " + e));
            Utilities.restoreSessionSpecifiedClassLoader(prev);
        }
        function.shareStateWith(ret);
        return ret;
    }

    private void checkFunctionClass(FunctionInfo cfi) throws ClassNotFoundException {
        Class<?> udfClass = cfi.getFunctionClass();
        Class.forName(udfClass.getName(), true, Utilities.getSessionSpecifiedClassLoader());
    }

    public synchronized void clear() {
        if (this.isNative) {
            throw new IllegalStateException("System function registry cannot be cleared");
        }
        this.mFunctions.clear();
        this.builtIns.clear();
    }

    public synchronized void closeCUDFLoaders() {
        try {
            for (ClassLoader loader : this.mSessionUDFLoaders) {
                JavaUtils.closeClassLoader(loader);
            }
        }
        catch (IOException ie) {
            LOG.error((Object)("Error in close loader: " + ie));
        }
        this.mSessionUDFLoaders.clear();
    }

    public synchronized void addToUDFLoaders(ClassLoader loader) {
        this.mSessionUDFLoaders.add(loader);
    }

    public synchronized void removeFromUDFLoaders(ClassLoader loader) {
        this.mSessionUDFLoaders.remove(loader);
    }

    public void setupPermissionsForUDFs(String whiteListStr, String blackListStr) {
        HashSet whiteList = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)whiteListStr.toLowerCase()));
        HashSet blackList = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)blackListStr.toLowerCase()));
        blackList.removeAll(FunctionRegistry.HIVE_OPERATORS);
        for (Map.Entry<String, FunctionInfo> funcEntry : this.mFunctions.entrySet()) {
            funcEntry.getValue().setBlockedFunction(this.isUdfBlocked(funcEntry.getKey(), whiteList, blackList));
        }
    }

    boolean isUdfBlocked(String functionName, Set<String> whiteList, Set<String> blackList) {
        return blackList.contains(functionName = functionName.toLowerCase()) || !whiteList.isEmpty() && !whiteList.contains(functionName);
    }
}

